/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class LinkSettingPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_KEY = "linkentry";
    private static final String COL_LINKNAME = "linkname";
    private static final String COL_MULILANGLINKNAME = "mulilanglinkname";
    private static final String COL_LINKURL = "linkurl";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public void afterCreateNewData(EventObject evt) {
        List linkDatas = (List)this.getView().getFormShowParameter().getCustomParam("linkData");
        if (CollectionUtils.isNotEmpty((Collection)linkDatas)) {
            this.getModel().clearNoDataRow();
            linkDatas.forEach(linkMap -> {
                String linkName = (String)linkMap.get(COL_LINKNAME);
                int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
                this.getModel().setValue(COL_LINKNAME, (Object)linkName, rowIndex);
                this.getModel().setValue(COL_MULILANGLINKNAME, (Object)this.getLocaleString(linkMap.get(COL_MULILANGLINKNAME), linkName), rowIndex);
                this.getModel().setValue(COL_LINKURL, linkMap.get(COL_LINKURL), rowIndex);
            });
        }
    }

    private ILocaleString getLocaleString(Object localeStr, String defaultValue) {
        Object localeData = localeStr instanceof Map && ((Map)localeStr).size() > 0 ? (ILocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)localeStr), LocaleString.class) : new LocaleString(defaultValue);
        return localeData;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        Object source = evt.getSource();
        if (source instanceof Donothing) {
            DynamicObjectCollection dyObjs = this.getModel().getEntryEntity(ENTRY_KEY);
            if (CollectionUtils.isEmpty((Collection)dyObjs)) {
                return;
            }
            for (DynamicObject dyObj : dyObjs) {
                boolean isMulilangEmpty;
                ILocaleString linkMulilangName = dyObj.getLocaleString(COL_MULILANGLINKNAME);
                String linkUrl = dyObj.getString(COL_LINKURL);
                boolean bl = isMulilangEmpty = linkMulilangName == null || StringUtils.isEmpty((String)linkMulilangName.getLocaleValue());
                if (!isMulilangEmpty && !StringUtils.isEmpty((String)linkUrl)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u94fe\u63a5\u540d\u79f0\u548c\u94fe\u63a5\u5730\u5740\u3002", (String)"LinkSettingPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey = evt.getOperateKey();
        if ("donothing".equals(opKey)) {
            HashMap para = new HashMap(0);
            HashMap<String, DynamicObjectCollection> data = new HashMap<String, DynamicObjectCollection>(0);
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_KEY);
            data.put("linkData", collection);
            para.put("value", data);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String linkUrl;
        if (COL_LINKURL.equals(e.getProperty().getName()) && StringUtils.isNotEmpty((String)(linkUrl = (String)e.getChangeSet()[0].getNewValue())) && !linkUrl.toLowerCase(Locale.ENGLISH).startsWith("http")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5305\u542bhttp\u6216https\u7684\u5b8c\u6574\u94fe\u63a5\uff0c\u4f8b\uff1ahttps://www.kingdee.com", (String)"LinkSettingPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }
}

