/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.cloudplatform.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.apusic.aas.util.codec.binary.StringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cloudplatform.model.CloudPlatformConfigInfo;
import kd.bos.login.cloudplatform.model.CloudPlatformResult;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections.MapUtils;

public class CloudPlatformUtils {
    private static Log logger = LogFactory.getLog(CloudPlatformUtils.class);
    public static final String ERRCODE = "errcode";
    public static final String DESCRIPTION = "description";
    private static final String RSA_METHOD = "RSA";
    private static final String RSA_ENCODE_MODE = "RSA/ECB/OAEPPadding";
    private static final String RSA_OAEP_MD_NAME = "SHA-256";
    private static final String RSA_OAEP_MG_NAME = "MGF1";
    private static final OAEPParameterSpec OAEP_PARAMETER_SPEC = new OAEPParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), PSource.PSpecified.DEFAULT);

    public static CloudPlatformResult createAppSecretByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, List<Map<String, String>> productList) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params, "1");
        Map<String, Object> body = CloudPlatformUtils.getBody(cloudPlatformConfigInfo, productList.get(0));
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getUrl() + "/seedapi/seedService/createApp"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            Map result = (Map)JSONUtils.cast((String)response, HashMap.class);
            if (result == null) {
                return cloudPlatformResult;
            }
            cloudPlatformResult.setErrCode(String.valueOf(result.get(ERRCODE)));
            if (result != null && "0".equals(String.valueOf(result.get(ERRCODE)))) {
                result = (Map)result.get("data");
                cloudPlatformResult.setData(result.get("id") + "");
            } else {
                cloudPlatformResult.setMessage(String.valueOf(result.get(DESCRIPTION)));
            }
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult getAppSecretByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, String createAppId) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params, "1");
        HashMap<String, String> body = new HashMap<String, String>(8);
        body.put("id", createAppId);
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getUrl() + "/seedapi/seedService/getApp"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                JSONArray array = json.getJSONArray("data");
                json = array.getJSONObject(0).getJSONObject("appInfo");
                json.put("appSrt", (Object)json.getString("secret"));
                json.remove((Object)"secret");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult sendVcodeByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws Exception, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params);
        String str = DefaultParameterService.getDefaultValueByKey((String)"bos_svc_cloud_platform_str");
        if (body != null) {
            if (body.get("phone") != null) {
                body.put("phone", CloudPlatformUtils.encryptByOAEP(str, body.get("phone").toString()));
            }
            if (body.get("email") != null) {
                body.put("email", CloudPlatformUtils.encryptByOAEP(str, body.get("email").toString()));
            }
        }
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getServiceUrl() + "/api/user/sendVcode"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            if (!"0".equals(json.getString(ERRCODE))) {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult bindCloudAccountByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params);
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getServiceUrl() + "/api/user/bindCloudAccount"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                json = json.getJSONObject("data");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult unbindCloudAccountByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params);
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getServiceUrl() + "/api/user/unbindCloudAccount"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            if (!"0".equals(json.getString(ERRCODE))) {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult verifyIdentityByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params);
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getServiceUrl() + "/api/user/verifyIdentity"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                json = json.getJSONObject("data");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult getBindCodeByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws Exception, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params);
        if (body != null) {
            String str = DefaultParameterService.getDefaultValueByKey((String)"bos_svc_cloud_platform_str");
            if (body.get("phone") != null) {
                body.put("phone", CloudPlatformUtils.encryptByOAEP(str, body.get("phone").toString()));
            }
            if (body.get("email") != null) {
                body.put("email", CloudPlatformUtils.encryptByOAEP(str, body.get("email").toString()));
            }
        }
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getServiceUrl() + "/api/user/getBindCode"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                json = json.getJSONObject("data");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult identity2codeByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params);
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getServiceUrl() + "/api/user/identity2code"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                json = json.getJSONObject("data");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    public static CloudPlatformResult refreshIdentityByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws IOException, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params);
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getServiceUrl() + "/api/user/refreshIdentity"), header, body);
        logger.info(response);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)response)) {
            JSONObject json = JSON.parseObject((String)response);
            cloudPlatformResult.setErrCode(json.getString(ERRCODE));
            if ("0".equals(json.getString(ERRCODE))) {
                json = json.getJSONObject("data");
                cloudPlatformResult.setData(json.toJSONString());
            } else {
                cloudPlatformResult.setMessage(json.getString(DESCRIPTION));
            }
        }
        return cloudPlatformResult;
    }

    public static String createQRcode(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, Object> body) throws IOException, InterruptedException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cloudPlatformConfigInfo.getServiceUrl());
        stringBuilder.append("/portal/erp/bind?");
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            stringBuilder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            params.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        String timestamp = System.currentTimeMillis() + "";
        stringBuilder.append("&timestamp=").append(timestamp);
        String nonce = kd.bos.util.StringUtils.randomWord((int)32);
        stringBuilder.append("&nonce=").append(nonce);
        stringBuilder.append("&sign=").append(CloudPlatformUtils.sign(cloudPlatformConfigInfo.getSeedStr(), timestamp, nonce, params));
        return stringBuilder.toString();
    }

    private static Map<String, String> getHeader(CloudPlatformConfigInfo cloudPlatformConfigInfo, SortedMap<String, String> params) {
        return CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params, null);
    }

    private static Map<String, Object> getBody(CloudPlatformConfigInfo cloudPlatformConfigInfo, Map<String, String> product) {
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("prodLine", "C05");
        ArrayList list = new ArrayList(8);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("serviceId", cloudPlatformConfigInfo.getServiceId());
        HashMap<String, String> param = new HashMap<String, String>(8);
        param.put("code", product.get("productNo"));
        param.put("swCode", product.get("softwareCode"));
        param.put("instanceCode", product.get("prodInstCode"));
        map.put("prodInfo", param);
        list.add(map);
        body.put("prodList", list);
        return body;
    }

    private static String sign(String appSecret, String timestamp, String nonce, SortedMap<String, String> params) {
        StringBuilder sber = new StringBuilder();
        sber.append(timestamp).append(nonce);
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)v)) {
                    byte[] bytes = StringUtils.getBytesUtf8((String)v);
                    sber.append(new String(bytes, 0, Math.min(bytes.length, 100), StandardCharsets.UTF_8));
                }
            });
        }
        return com.apusic.aas.util.codec.binary.Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, StringUtils.getBytesUtf8((String)appSecret)).hmac(StringUtils.getBytesUtf8((String)sber.toString())));
    }

    public static String decryptGCM(String key, String ciphertext) throws Exception {
        byte[] str = Base64.getDecoder().decode(ciphertext);
        byte[] iv = new byte[16];
        byte[] content = new byte[str.length - iv.length];
        System.arraycopy(str, 0, iv, 0, iv.length);
        System.arraycopy(str, iv.length, content, 0, content.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec a = new SecretKeySpec(key.getBytes(), "AES");
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)a, spec);
        return new String(cipher.doFinal(content), "utf-8");
    }

    private static String encryptByOAEP(String publicKeyString, String data) throws Exception {
        byte[] publicKeyBytes = Base64.getDecoder().decode(publicKeyString);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_METHOD);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Cipher oaepFromInit = Cipher.getInstance(RSA_ENCODE_MODE);
        oaepFromInit.init(1, (Key)publicKey, OAEP_PARAMETER_SPEC);
        byte[] encryptedData = oaepFromInit.doFinal(data.getBytes());
        return Base64.getEncoder().encodeToString(encryptedData);
    }

    private static Map<String, String> getHeader(CloudPlatformConfigInfo cloudPlatformConfigInfo, SortedMap<String, String> params, String type) {
        HashMap<String, String> header = new HashMap<String, String>(8);
        String timestamp = System.currentTimeMillis() + "";
        header.put("x-acgw-timestamp", timestamp);
        String nonce = kd.bos.util.StringUtils.randomWord((int)32);
        header.put("x-acgw-nonce", nonce);
        if ("1".equals(type)) {
            header.put("x-acgw-appid", cloudPlatformConfigInfo.getSeedId());
            header.put("x-acgw-sign", CloudPlatformUtils.sign(cloudPlatformConfigInfo.getSeedStr(), timestamp, nonce, params));
        } else {
            header.put("x-acgw-appid", cloudPlatformConfigInfo.getAppId());
            header.put("x-acgw-sign", CloudPlatformUtils.sign(cloudPlatformConfigInfo.getAppStr(), timestamp, nonce, params));
        }
        return header;
    }

    public static CloudPlatformResult checkNetWork(CloudPlatformConfigInfo cloudPlatformConfigInfo, String createAppId) throws Exception, InterruptedException {
        CloudPlatformResult cloudPlatformResult = new CloudPlatformResult();
        TreeMap<String, String> params = new TreeMap<String, String>();
        Map<String, String> header = CloudPlatformUtils.getHeader(cloudPlatformConfigInfo, params, "1");
        HashMap<String, String> body = new HashMap<String, String>(8);
        body.put("id", createAppId);
        String response = HttpClientUtils.postAppJson((String)(cloudPlatformConfigInfo.getUrl() + "/seedapi/seedService/getApp"), header, body);
        cloudPlatformResult.setSuccess(true);
        return cloudPlatformResult;
    }
}

