/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.params;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.user.ConfigureationService;
import kd.bos.login.util.GlobalDeployUtils;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;

public class LoginBaseParamPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.ldapConfig();
        this.globalDeployConfig();
        this.oemConfig();
    }

    private void globalDeployConfig() {
        boolean isGlobalDeploy = GlobalDeployUtils.isGlobalDeploy((String)RequestContext.get().getTenantId());
        if (isGlobalDeploy) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"open_sms_login", "labelap1", "msg_timeout", "labelap3"});
        }
    }

    private void oemConfig() {
        boolean isOemEnv = DevVerifyServiceHelper.isOEMEnv();
        if (isOemEnv) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ai_insight_panel"});
        }
    }

    private void ldapConfig() {
        Object isenablead = this.getModel().getValue("isenablead");
        Account currentCenter = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
        Map parameters = ConfigureationService.getCommonParameters((Account)currentCenter);
        Object type = parameters.get("identitychecktype");
        this.isEnableLdapChanged(isenablead, type);
    }

    private void showNewLdap(boolean enableLdap) {
        this.getView().setVisible(Boolean.valueOf(enableLdap), new String[]{"flexpanelap4"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"identitychecktype", "ldapurl", "labelap4", "ladpusermapping", "labelap6", "userfdn", "labelap7", "admindn", "labelap8", "adminpassword", "labelap9", "check_user_type"});
        this.getModel().setValue("identitychecktype", (Object)"0");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"domain", "labelap5", "ldap_search_prefix", "flexpanelap5", "ldap_search_dn", "flexpanelap6"});
    }

    private void showOldLdap(boolean enableLdap) {
        this.getView().setVisible(Boolean.valueOf(enableLdap), new String[]{"flexpanelap4"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"identitychecktype", "ldapurl", "labelap4", "domain", "labelap5", "ldap_search_prefix", "flexpanelap5", "ldap_search_dn", "flexpanelap6", "check_user_type"});
        this.getModel().setValue("identitychecktype", (Object)"1");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"ladpusermapping", "labelap6", "userfdn", "labelap7", "admindn", "labelap8", "adminpassword", "labelap9"});
    }

    private boolean isEnableLdapChanged(Object isenablead, Object type) {
        boolean ldap = false;
        if (isenablead instanceof Boolean) {
            ldap = (Boolean)isenablead;
            if (ldap && null == type) {
                this.showOldLdap(ldap);
            } else if (null != type && type.equals("1")) {
                this.showOldLdap(ldap);
            } else {
                this.showNewLdap(ldap);
            }
        }
        return ldap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("isenablead")) {
            newValue = e.getChangeSet()[0].getNewValue();
            Object type = this.getModel().getValue("identitychecktype");
            this.isEnableLdapChanged(newValue, type);
        }
        if (name.equals("identitychecktype")) {
            newValue = e.getChangeSet()[0].getNewValue();
            boolean isEnablead = Boolean.parseBoolean(String.valueOf(this.getModel().getValue("isenablead")));
            if (newValue.equals("1")) {
                this.showOldLdap(isEnablead);
            } else {
                this.showNewLdap(isEnablead);
            }
        }
        if ("adminpassword".equals(name)) {
            Object getNewValue = e.getChangeSet()[0].getNewValue();
            String value = String.valueOf(getNewValue);
            if (!ObjectUtils.isEmpty((Object)getNewValue) && !Encrypters.isEncrypted((String)value)) {
                String decode = Encrypters.encode((String)Encrypters.decode((String)value));
                this.getModel().setValue("adminpassword", (Object)decode);
            }
        }
    }
}

