/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractThirdAppAuthPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(AbstractThirdAppAuthPlugin.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    protected static final String ENABLE = "enable";
    private static final String THIRDAPP_CONFIRM_DELETE = "thirdapp_confirm_delete";
    private static final String THIRDAPP_CONFIRM_ENABLE = "thirdapp_confirm_enable";
    private static final String THIRDAPP_CONFIRM_DISABLE = "thirdapp_confirm_disable";
    private static final String CURRENT_OP_ID = "current_op_id";
    private static final String APP_ENTITY = "appentity";
    private static final String LOGENTRYENTITY = "logentryentity";

    protected abstract String getFormId();

    protected abstract String getConfigDetecFormId();

    protected abstract void initalEntityData();

    protected abstract Long getImType();

    protected abstract String getErrorCodeMsg(String var1);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"createapppabel", "createappicon", "createapplabel", "editap", "deleteap", ENABLE, "connectdetec", "namepanel"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void createNewData(BizDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initalEntityData();
        this.initalThirdAuthLogEntityData();
    }

    private void initalThirdAuthLogEntityData() {
        this.clearOldNotify(LOGENTRYENTITY);
        QFilter thirdTypeFilter = new QFilter("imtype", "=", (Object)this.getImType());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_log_thirdapp_auth", (String)"id, corpid, agentid, opdesc, url, optime, status, resourceid", (QFilter[])new QFilter[]{thirdTypeFilter}, (String)"optime desc", (int)10000);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("corpid", new Object[0]);
        vs.addField("agentid", new Object[0]);
        vs.addField("opdesc", new Object[0]);
        vs.addField("url", new Object[0]);
        vs.addField("status", new Object[0]);
        vs.addField("optime", new Object[0]);
        for (DynamicObject dynamicObject : dynamicObjects) {
            vs.addRow(new Object[]{dynamicObject.get("corpid"), dynamicObject.get("agentid"), this.getMsg(dynamicObject), dynamicObject.get("url"), dynamicObject.get("status"), dynamicObject.get("optime")});
        }
        model.batchCreateNewEntryRow(LOGENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(LOGENTRYENTITY);
    }

    private String getMsg(DynamicObject dynamicObject) {
        String resourceid = dynamicObject.getString("resourceid");
        String opdesc = dynamicObject.getString("opdesc");
        if (StringUtils.isNotBlank((CharSequence)resourceid)) {
            String msg = this.getErrorCodeMsg(resourceid);
            if (StringUtils.isNotBlank((CharSequence)opdesc)) {
                try {
                    List<?> datas = SerializationUtils.fromJsonStringToList(opdesc, String.class);
                    return String.format(msg, datas.toArray(new Object[0]));
                }
                catch (Exception e) {
                    logger.info("Serialize fail:" + opdesc);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return msg;
            }
        }
        return opdesc;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "createapppabel": 
            case "createapplabel": 
            case "createappicon": {
                this.showThirdAppConfig();
                break;
            }
            case "editap": 
            case "namepanel": {
                this.showThirdAppConfigEdit();
                break;
            }
            case "deleteap": {
                this.showConfirm();
                break;
            }
            case "connectdetec": {
                this.showConnectDetec();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_refresh".equals(itemKey)) {
            this.getView().updateView();
        }
    }

    private void showThirdAppConfig() {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(this.getFormId());
        bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)bsp);
    }

    private long getSelectRowId() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(APP_ENTITY);
        int[] row = cardEntry.getSelectRows();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(APP_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(row[0]);
        return dynamicObject.getLong("id");
    }

    private void showThirdAppConfigEdit() {
        long id = this.getSelectRowId();
        String pageId = this.getPageCache().get(this.getPageKey(id));
        IFormView view = this.getView().getView(pageId);
        if (view != null) {
            view.activate();
            this.getView().sendFormAction(view);
        } else {
            BillShowParameter bsp = new BillShowParameter();
            bsp.setFormId(this.getFormId());
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setPkId((Object)id);
            bsp.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)bsp);
            this.getPageCache().put(this.getPageKey(id), bsp.getPageId());
        }
    }

    private void showConnectDetec() {
        String formId = this.getConfigDetecFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        long pkValue = this.getSelectRowId();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("pkValue", (Object)pkValue);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "connectDetec"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("connectDetec".equals(actionId)) {
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            this.getView().updateView();
        }
    }

    private void showConfirm() {
        if (!this.checkPermission("4715e1f1000000ac")) {
            String formName = this.getView().getFormShowParameter().getFormName();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractThirdAppAuthPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), formName, ResManager.loadKDString((String)"\u5220\u9664", (String)"AbstractThirdAppAuthPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl(APP_ENTITY);
        int[] row = cardEntry.getSelectRows();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(APP_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(row[0]);
        String number = dynamicObject.getString("number");
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(THIRDAPP_CONFIRM_DELETE, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"GridContainerPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"GridContainerPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5e94\u7528%s\u5417\uff0c\u5220\u9664\u540e\u7528\u6237\u5c06\u65e0\u6cd5\u514d\u767b\u8bbf\u95ee\u5e94\u7528\uff0c\u5220\u9664\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"AbstractThirdAppAuthPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), number), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, btnNameMaps);
    }

    private boolean checkPermission(String permItem) {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String formId = this.getFormId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)formId, (String)permItem);
    }

    private String getPageKey(long id) {
        return "pkid_" + id;
    }

    void clearOldNotify(String entryentityName) {
        this.getModel().deleteEntryData(entryentityName);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String id = e.getName();
        if ("initalEntityData".equals(id)) {
            this.initalEntityData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (ENABLE.equals(propertyName)) {
            String msg;
            String callBackId;
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            DynamicObject dynamicObject = changeData.getDataEntity();
            long id = dynamicObject.getLong("id");
            DynamicObject thirdApp = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getFormId());
            if (newValue != null && newValue.toString().equals(String.valueOf(thirdApp.getBoolean(ENABLE)))) {
                return;
            }
            String name = dynamicObject.getString("name");
            if (newValue != null && Boolean.parseBoolean(newValue.toString())) {
                if (!this.checkPermission("4730fc5d000000ac")) {
                    this.getView().addClientCallBack("initalEntityData");
                    String formName = this.getView().getFormShowParameter().getFormName();
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractThirdAppAuthPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), formName, ResManager.loadKDString((String)"\u542f\u7528", (String)"AbstractThirdAppAuthPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
                    return;
                }
                callBackId = THIRDAPP_CONFIRM_ENABLE;
                msg = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u542f\u7528\u5e94\u7528%s\u5417\uff0c\u542f\u7528\u540e\u7528\u6237\u53ef\u514d\u767b\u8bbf\u95ee\u5e94\u7528\u3002", (String)"AbstractThirdAppAuthPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), name);
            } else {
                if (!this.checkPermission("47160c2b000000ac")) {
                    this.getView().addClientCallBack("initalEntityData");
                    String formName = this.getView().getFormShowParameter().getFormName();
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractThirdAppAuthPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), formName, ResManager.loadKDString((String)"\u7981\u7528", (String)"AbstractThirdAppAuthPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
                    return;
                }
                callBackId = THIRDAPP_CONFIRM_DISABLE;
                msg = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u7981\u7528\u5e94\u7528%s\u5417\uff0c\u7981\u7528\u540e\u7528\u6237\u5c06\u65e0\u6cd5\u514d\u767b\u8bbf\u95ee\u5e94\u7528\u3002", (String)"AbstractThirdAppAuthPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), name);
            }
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, callBackListener);
            this.getPageCache().put(CURRENT_OP_ID, String.valueOf(id));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && THIRDAPP_CONFIRM_DELETE.equals(key)) {
            long id = this.getSelectRowId();
            QFilter idFilter = new QFilter("id", "=", (Object)id);
            DeleteServiceHelper.delete((String)this.getFormId(), (QFilter[])new QFilter[]{idFilter});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractThirdAppAuthPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            this.getView().updateView();
        } else if (THIRDAPP_CONFIRM_DISABLE.equals(key)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String id = this.getPageCache().get(CURRENT_OP_ID);
                if (id != null) {
                    this.updateThirdApp(Long.parseLong(id), Boolean.FALSE);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"AbstractThirdAppAuthPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                }
            } else {
                this.getView().updateView();
            }
        } else if (THIRDAPP_CONFIRM_ENABLE.equals(key)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String id = this.getPageCache().get(CURRENT_OP_ID);
                if (id != null) {
                    this.updateThirdApp(Long.parseLong(id), Boolean.TRUE);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"AbstractThirdAppAuthPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                }
            } else {
                this.getView().updateView();
            }
        }
    }

    private void updateThirdApp(long id, boolean enable) {
        DynamicObject thirdapp = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getFormId());
        boolean dataenable = thirdapp.getBoolean(ENABLE);
        if (!String.valueOf(dataenable).equals(String.valueOf(enable))) {
            thirdapp.set(ENABLE, (Object)enable);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{thirdapp});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Long userId = RequestContext.get().getCurrUserId();
        FormShowParameter fsp = e.getFormShowParameter();
        String appId = fsp.getAppId();
        String formId = this.getFormId();
        if (!PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac")) {
            e.setCancel(true);
            String formName = fsp.getFormName();
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractThirdAppAuthPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), formName, ResManager.loadKDString((String)"\u67e5\u8be2", (String)"AbstractThirdAppAuthPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
        }
    }
}

