/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractThirdAppConfigPlugin
extends AbstractFormPlugin {
    private static final String CURRENTHOST = "host";
    private static final String CREATEURL = "createurl";
    private static final String BTNCREATEAPP = "btncreateapp";
    private static final String GETIPLABEL = "getiplabel";
    private static final String CARETAURLPANEL = "caretaurlpanel";

    protected abstract Long getImType();

    protected abstract String createUrl(String var1);

    protected abstract boolean createUrlEnable();

    protected abstract String getConfigDetecFormId();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{CREATEURL, CARETAURLPANEL, "operationurl", BTNCREATEAPP, GETIPLABEL, "copyweburlicon", "copymobileurlicon", "copyipicon"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW) {
            this.initData();
        }
        String weburl = (String)this.getModel().getValue("weburl");
        String mobileurl = (String)this.getModel().getValue("mobileurl");
        if (StringUtils.isNotBlank((CharSequence)weburl) || StringUtils.isNotBlank((CharSequence)mobileurl)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showurlflexpanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipflexpanel"});
            DynamicObject webform = (DynamicObject)this.getModel().getValue("webform");
            DynamicObject mobileform = (DynamicObject)this.getModel().getValue("mobileform");
            this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)weburl) && webform != null), new String[]{"weburlpanel"});
            this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)mobileurl) && mobileform != null), new String[]{"mobileurlpanel"});
        }
        if (status == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"edit", "connectdetec"});
        } else if (status == OperationStatus.EDIT || status == OperationStatus.ADDNEW) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "connectdetec"});
        }
    }

    private void initData() {
        String domainUrl = UrlService.getDomainContextUrl();
        if (StringUtils.isNotBlank((CharSequence)domainUrl)) {
            domainUrl = RevProxyUtil.removeSlash((String)domainUrl);
        }
        this.getModel().setValue(CURRENTHOST, (Object)domainUrl);
        QFilter imtypeFilter = new QFilter("imtype", "=", (Object)this.getImType());
        DynamicObject pluginData = QueryServiceHelper.queryOne((String)"bos_thirdapp_plugin", (String)"id, pluginconfig, pluginname", (QFilter[])new QFilter[]{imtypeFilter});
        String pluginconfig = "1";
        String pluginName = "";
        if (pluginData != null) {
            pluginconfig = pluginData.getString("pluginconfig");
            pluginName = pluginData.getString("pluginname");
        }
        this.getModel().setValue("pluginconfig", (Object)pluginconfig);
        this.getModel().setValue("pluginname", (Object)pluginName);
        boolean flag = "2".equals(pluginconfig);
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"pluginname"});
        TextEdit pluginname = (TextEdit)this.getControl("pluginname");
        pluginname.setMustInput(flag);
        this.getModel().setDataChanged(false);
        this.setCreateUrlEnableAndFcColor();
        this.setPluginLabelDirection("standardplugin");
        this.setPluginLabelDirection("customplugin");
    }

    private void setPluginLabelDirection(String key) {
        HashMap metadataMap = new HashMap(16);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("lDir", "h");
        metadataMap.put("item", map);
        HashMap<String, String> l = new HashMap<String, String>(16);
        l.put("l", "-8px");
        HashMap<String, HashMap<String, String>> s = new HashMap<String, HashMap<String, String>>(16);
        s.put("m", l);
        metadataMap.put("s", s);
        this.getView().updateControlMetadata(key, metadataMap);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "createurl": {
                this.setUrlValue();
                break;
            }
            case "copyweburlicon": {
                this.copyUrl("weburl");
                break;
            }
            case "copymobileurlicon": {
                this.copyUrl("mobileurl");
                break;
            }
            case "copyipicon": {
                this.copyUrl("trustedip");
                break;
            }
        }
    }

    private void showConnectDetec() {
        String formId = this.getConfigDetecFormId();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        long pkValue = (Long)this.getModel().getValue("id");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("pkValue", (Object)pkValue);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "connectDetec"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if ("connectDetec".equals(actionId)) {
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            IFormView parentView = this.getView().getParentView();
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    private void copyUrl(String key) {
        String url = (String)this.getModel().getValue(key);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.addCopyAction(url);
        }
    }

    private void addCopyAction(String content) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("content", content);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("pageId", this.getView().getPageId());
        params.put("data", data);
        proxy.addAction("copyLocal", params);
    }

    private void setUrlValue() {
        String mobileformUrl;
        String webformUrl = this.createUrl("webform");
        if (StringUtils.isNotBlank((CharSequence)webformUrl)) {
            this.getModel().setValue("weburl", (Object)webformUrl);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showurlflexpanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipflexpanel"});
        }
        if (StringUtils.isNotBlank((CharSequence)(mobileformUrl = this.createUrl("mobileform")))) {
            this.getModel().setValue("mobileurl", (Object)mobileformUrl);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showurlflexpanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipflexpanel"});
        }
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)webformUrl)), new String[]{"weburlpanel"});
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)mobileformUrl)), new String[]{"mobileurlpanel"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        String itemkey = evt.getOperateKey();
        if ("save".equals(itemkey)) {
            this.savePluginConfig();
        } else if ("edit".equals(itemkey)) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().cacheFormShowParameter();
            this.getView().updateView();
        } else if ("connectdetec".equals(itemkey)) {
            this.showConnectDetec();
        }
    }

    private void savePluginConfig() {
        Long imType = this.getImType();
        QFilter imtypeFilter = new QFilter("imtype", "=", (Object)imType);
        DynamicObject pluginData = BusinessDataServiceHelper.loadSingle((String)"bos_thirdapp_plugin", (String)"id, pluginconfig, pluginname", (QFilter[])new QFilter[]{imtypeFilter});
        if (pluginData == null) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_thirdapp_plugin");
            pluginData = new DynamicObject((DynamicObjectType)dt);
            pluginData.set("imtype", (Object)imType);
        }
        Object pluginconfig = this.getModel().getValue("pluginconfig");
        Object pluginname = this.getModel().getValue("pluginname");
        pluginData.set("pluginconfig", pluginconfig);
        pluginData.set("pluginname", pluginname);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pluginData});
        this.getView().setStatus(OperationStatus.VIEW);
        this.getView().updateView();
        IFormView parentView = this.getView().getParentView();
        parentView.updateView();
        this.getView().sendFormAction(parentView);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("pluginconfig".equals(propertyName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            boolean flag = "2".equals(newValue);
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"pluginname"});
            TextEdit pluginname = (TextEdit)this.getControl("pluginname");
            pluginname.setMustInput(flag);
        } else if (CURRENTHOST.equals(propertyName) || "webform".equals(propertyName) || "mobileform".equals(propertyName)) {
            this.setCreateUrlEnableAndFcColor();
        }
    }

    protected void setCreateUrlEnableAndFcColor() {
        boolean flag = this.createUrlEnable();
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{CARETAURLPANEL, CREATEURL});
        HashMap<String, String> colorData = new HashMap<String, String>(16);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (flag && (status == OperationStatus.EDIT || status == OperationStatus.ADDNEW)) {
            colorData.put("fc", "#0E5FD8");
        } else {
            colorData.put("fc", "#B2B2B2");
        }
        this.getView().updateControlMetadata(CREATEURL, colorData);
    }

    String getLangValue() {
        Lang lang = RequestContext.get().getLang();
        String langValue = lang == Lang.zh_CN || lang == Lang.zh_TW ? "zh-CN" : "en-US";
        return langValue;
    }
}

