/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.login.plugin.AbstractThirdAppConfigPlugin;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class DingDingConfigFormPlugin
extends AbstractThirdAppConfigPlugin {
    @Override
    protected Long getImType() {
        return 2L;
    }

    @Override
    protected String getConfigDetecFormId() {
        return "bos_dingdingconfig_detec";
    }

    @Override
    protected String createUrl(String key) {
        DynamicObject form;
        String urlParamsFormat;
        if ("webform".equals(key)) {
            urlParamsFormat = "%s/index.html?formId=%s&accountId=%s&corpid=%s&apptype=dd&appkey=%s&agentid=%s";
        } else if ("mobileform".equals(key)) {
            urlParamsFormat = "%s/mobile.html?form=%s&accountId=%s&corpid=%s&apptype=dd&appkey=%s&agentid=%s";
        } else {
            return "";
        }
        String domainUrl = (String)this.getModel().getValue("host");
        if (StringUtils.isNotBlank((CharSequence)domainUrl)) {
            domainUrl = RevProxyUtil.removeSlash((String)domainUrl);
        }
        if ((form = (DynamicObject)this.getModel().getValue(key)) == null) {
            return "";
        }
        String formId = form.getString("number");
        String accountId = RequestContext.get().getAccountId();
        String appkey = (String)this.getModel().getValue("appkey");
        String corpid = (String)this.getModel().getValue("corpid");
        String agentid = (String)this.getModel().getValue("agentid");
        String url = String.format(urlParamsFormat, domainUrl, formId, accountId, corpid, appkey, agentid);
        return url;
    }

    @Override
    protected boolean createUrlEnable() {
        String currenthost = (String)this.getModel().getValue("host");
        Object webform = this.getModel().getValue("webform");
        Object mobileform = this.getModel().getValue("mobileform");
        String appkey = (String)this.getModel().getValue("appkey");
        String corpid = (String)this.getModel().getValue("corpid");
        String agentid = (String)this.getModel().getValue("agentid");
        boolean flag = StringUtils.isNotBlank((CharSequence)appkey) && StringUtils.isNotBlank((CharSequence)corpid) && StringUtils.isNotBlank((CharSequence)agentid) && StringUtils.isNotBlank((CharSequence)currenthost) && (webform != null || mobileform != null);
        return flag;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "operationurl": {
                String url = "https://vip.kingdee.com/knowledge/specialDetail/228892721203874816?category=228893083373702400&id=228922658535279872&lang=%s";
                this.getView().openUrl(String.format(url, this.getLangValue()));
                break;
            }
            case "btncreateapp": {
                this.getView().openUrl("https://login.dingtalk.com");
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("appkey".equals(propertyName) || "corpid".equals(propertyName) || "agentid".equals(propertyName)) {
            this.setCreateUrlEnableAndFcColor();
        }
    }
}

