/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.plugin.AbstractThirdAppConfigPlugin;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class FlyBookConfigFormPlugin
extends AbstractThirdAppConfigPlugin {
    private static final Log logger = LogFactory.getLog(FlyBookConfigFormPlugin.class);

    @Override
    protected Long getImType() {
        return 6L;
    }

    @Override
    protected String getConfigDetecFormId() {
        return "";
    }

    @Override
    protected String createUrl(String key) {
        DynamicObject form;
        String urlParamsFormat;
        if ("webform".equals(key)) {
            urlParamsFormat = "%1s/index.html?formId=%2s&accountId=%3s&apptype=feishu&flyBookAppId=%4s";
        } else if ("mobileform".equals(key)) {
            urlParamsFormat = "%1s/mobile.html?form=%2s&accountId=%3s&apptype=feishu&flyBookAppId=%4s";
        } else {
            return "";
        }
        String domainUrl = (String)this.getModel().getValue("host");
        if (StringUtils.isNotBlank((CharSequence)domainUrl)) {
            domainUrl = RevProxyUtil.removeSlash((String)domainUrl);
        }
        if ((form = (DynamicObject)this.getModel().getValue(key)) == null) {
            return "";
        }
        String accountId = RequestContext.get().getAccountId();
        String formId = form.getString("number");
        String appid = (String)this.getModel().getValue("appid");
        String url = String.format(urlParamsFormat, domainUrl, formId, accountId, appid);
        return this.createUrl(domainUrl, key, url);
    }

    private String createUrl(String domainUrl, String key, String urlParamsFormat) {
        DynamicObject form = (DynamicObject)this.getModel().getValue(key);
        if (form == null) {
            return "";
        }
        String formId = form.getString("number");
        String accountId = RequestContext.get().getAccountId();
        String appid = (String)this.getModel().getValue("appid");
        String url = String.format(urlParamsFormat, domainUrl, formId, accountId, appid);
        try {
            String encodeUrl = URLEncoder.encode(url, StandardCharsets.UTF_8.name());
            String wxUrl = String.format("https://open.feishu.cn/open-apis/authen/v1/index?app_id=%1s&redirect_uri=%2s", appid, encodeUrl);
            return wxUrl;
        }
        catch (Exception e) {
            logger.info("encode url error", (Object)e);
            return "";
        }
    }

    @Override
    protected boolean createUrlEnable() {
        String currenthost = (String)this.getModel().getValue("host");
        Object webform = this.getModel().getValue("webform");
        Object mobileform = this.getModel().getValue("mobileform");
        String appid = (String)this.getModel().getValue("appid");
        boolean flag = StringUtils.isNotBlank((CharSequence)appid) && StringUtils.isNotBlank((CharSequence)currenthost) && (webform != null || mobileform != null);
        return flag;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "operationurl": {
                String url = "https://vip.kingdee.com/knowledge/specialDetail/228892721203874816?category=228893083373702400&id=238758427345172736&lang=%s";
                this.getView().openUrl(String.format(url, this.getLangValue()));
                break;
            }
            case "btncreateapp": {
                this.getView().openUrl("https://open.feishu.cn/app/");
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("pluginconfig".equals(propertyName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            this.getView().setVisible(Boolean.valueOf("2".equals(newValue)), new String[]{"pluginname"});
        } else if ("appid".equals(propertyName)) {
            this.setCreateUrlEnableAndFcColor();
        }
    }
}

