/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.apusic.aas.util.codec.binary.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SmsSignatureFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(SmsSignatureFormPlugin.class);
    private static final String SYSTEM_TYPE = "bos-portal-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"update_status"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            Map map = LicenseServiceHelper.getProductInfo();
            if (MapUtils.isEmpty((Map)map) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)map.get("prodInstCode")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u5b9e\u4f8b\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SmsSignatureFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String signName = this.getView().getModel().getValue("name") + "";
            String businessLicenseImage = this.getBusinessLicenseImage(this.getView().getModel().getValue("businesslicense") + "");
            String signId = this.createSign((String)map.get("prodInstCode"), signName, businessLicenseImage);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)signId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u7533\u8bf7\u5931\u8d25\u3002", (String)"SmsSignatureFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getView().getModel().setValue("signid", (Object)signId);
            this.getModel().getDataEntity().set("signid", (Object)signId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBusinessLicenseImage(String imagePath) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            String base64Image;
            int bytesRead;
            FileService imageFileService = FileServiceFactory.getImageFileService();
            inputStream = imageFileService.getInputStream(imagePath);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] imageBytes = baos.toByteArray();
            String string = base64Image = Base64.getEncoder().encodeToString(imageBytes);
            return string;
        }
        catch (IOException e) {
            logger.info("getBusinessLicenseImage#", (Object)e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                baos.close();
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
    }

    private String createSign(String prodInstCode, String signName, String businessLicenseImage) {
        try {
            String url = DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_sms_url");
            String timestamp = System.currentTimeMillis() + "";
            HashMap<String, String> header = new HashMap<String, String>(8);
            header.put("x-acgw-timestamp", timestamp);
            String nonce = kd.bos.login.utils.StringUtils.randomWord((int)32);
            header.put("x-acgw-nonce", nonce);
            String smsAppSrtInfo = DefaultParameterService.getDefaultValueByKey((String)"login_business_app_config");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)smsAppSrtInfo)) {
                return "";
            }
            Map smsAppSrt = (Map)JSONUtils.cast((String)smsAppSrtInfo, HashMap.class);
            header.put("x-acgw-appid", (String)smsAppSrt.get("appId"));
            TreeMap<String, String> params = new TreeMap<String, String>();
            header.put("x-acgw-sign", SmsSignatureFormPlugin.sign((String)smsAppSrt.get("appSrt"), timestamp, nonce, params));
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("applicantPhone", RequestContext.get().getUserName());
            body.put("sn", prodInstCode);
            body.put("signName", signName);
            body.put("businessLicenseImage", businessLicenseImage);
            body.put("applyReason", ResManager.loadKDString((String)"\u7533\u8bf7\u8be5\u7b7e\u540d\u7528\u4e8e\u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1\u3002", (String)"SmsSignatureFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            String responseData = HttpClientUtils.postAppJson((String)(url + "/sms/sign/create"), header, body);
            logger.info(responseData);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)responseData)) {
                logger.info("createSign responseData is null ");
                return "";
            }
            JSONObject json = JSON.parseObject((String)responseData);
            if (!"0".equals(String.valueOf(json.get((Object)"errcode")))) {
                logger.info(responseData);
                this.getView().showTipNotification(json.get((Object)"description") + "");
                return "";
            }
            if (ObjectUtils.isNotEmpty((Object)json.get((Object)"data"))) {
                JSONObject data = json.getJSONObject("data");
                return data.get((Object)"serialId") + "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String sign(String appSecret, String timestamp, String nonce, SortedMap<String, String> params) {
        StringBuilder sber = new StringBuilder();
        sber.append(timestamp).append(nonce);
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)v)) {
                    byte[] bytes = StringUtils.getBytesUtf8((String)v);
                    sber.append(new String(bytes, 0, Math.min(bytes.length, 100), StandardCharsets.UTF_8));
                }
            });
        }
        return com.apusic.aas.util.codec.binary.Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, StringUtils.getBytesUtf8((String)appSecret)).hmac(StringUtils.getBytesUtf8((String)sber.toString())));
    }
}

