/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.apusic.aas.util.codec.binary.Base64;
import com.apusic.aas.util.codec.binary.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SmsSignatureListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(SmsSignatureListPlugin.class);
    private static final String SYSTEM_TYPE = "bos-portal-plugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"update_status", "baritemap_del"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"update_status", (CharSequence)evt.getItemKey())) {
            Map map = LicenseServiceHelper.getProductInfo();
            if (MapUtils.isEmpty((Map)map) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)map.get("prodInstCode")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u5b9e\u4f8b\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SmsSignatureFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)"bos_sms_signature", (String)"id,signid,status,applyreason", (QFilter[])new QFilter[]{new QFilter("status", "!=", (Object)"1")});
            Map<String, Object> signStatusMap = this.getSignStatus((String)map.get("prodInstCode"));
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
            if (signStatusMap != null && signStatusMap.size() > 0) {
                for (DynamicObject data : dataArray) {
                    if ("pass".equals(signStatusMap.get(data.getString("signid")))) {
                        data.set("status", (Object)"1");
                        list.add(data);
                        continue;
                    }
                    if (!"fail".equals(signStatusMap.get(data.getString("signid")))) continue;
                    data.set("status", (Object)"2");
                    data.set("applyreason", signStatusMap.get(data.getString("signid") + "auditResult"));
                    list.add(data);
                }
            }
            if (list != null && list.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u6210\u529f\u3002", (String)"SmsSignatureListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            this.getView().updateView();
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"baritemap_del", (CharSequence)evt.getItemKey())) {
            // empty if block
        }
    }

    private Map<String, Object> getSignStatus(String prodInstCode) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>(8);
            String url = DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_sms_url");
            String timestamp = System.currentTimeMillis() + "";
            HashMap<String, String> header = new HashMap<String, String>(8);
            header.put("x-acgw-timestamp", timestamp);
            String nonce = kd.bos.login.utils.StringUtils.randomWord((int)32);
            header.put("x-acgw-nonce", nonce);
            String smsAppSrtInfo = DefaultParameterService.getDefaultValueByKey((String)"login_business_app_config");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)smsAppSrtInfo)) {
                return result;
            }
            Map smsAppSrt = (Map)JSONUtils.cast((String)smsAppSrtInfo, HashMap.class);
            header.put("x-acgw-appid", (String)smsAppSrt.get("appId"));
            TreeMap<String, String> params = new TreeMap<String, String>();
            header.put("x-acgw-sign", SmsSignatureListPlugin.sign((String)smsAppSrt.get("appSrt"), timestamp, nonce, params));
            HashMap<String, Integer> body = new HashMap<String, Integer>(8);
            body.put("count", 100);
            String responseData = HttpClientUtils.postAppJson((String)(url + "/sms/sign/batch"), header, body);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)responseData)) {
                logger.info("getSignStatus responseData is null ");
                return null;
            }
            JSONObject json = JSON.parseObject((String)responseData);
            if (!"0".equals(String.valueOf(json.get((Object)"errcode")))) {
                logger.info(responseData);
                this.getView().showTipNotification(json.get((Object)"description") + "");
                return null;
            }
            if (ObjectUtils.isNotEmpty((Object)json.get((Object)"data"))) {
                JSONArray array = json.getJSONObject("data").getJSONArray("signList");
                for (int i = 0; i < array.size(); ++i) {
                    json = array.getJSONObject(i);
                    result.put(json.getString("signId"), json.getString("auditStatus"));
                    result.put(json.getString("signId") + "auditResult", json.getString("auditResult"));
                }
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String sign(String appSecret, String timestamp, String nonce, SortedMap<String, String> params) {
        StringBuilder sber = new StringBuilder();
        sber.append(timestamp).append(nonce);
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (org.apache.commons.lang.StringUtils.isNotEmpty((String)v)) {
                    byte[] bytes = StringUtils.getBytesUtf8((String)v);
                    sber.append(new String(bytes, 0, Math.min(bytes.length, 100), StandardCharsets.UTF_8));
                }
            });
        }
        return Base64.encodeBase64String((byte[])new HmacUtils(HmacAlgorithms.HMAC_SHA_256, StringUtils.getBytesUtf8((String)appSecret)).hmac(StringUtils.getBytesUtf8((String)sber.toString())));
    }

    public void initialize() {
        Map map = LicenseServiceHelper.getProductInfo();
        if (MapUtils.isEmpty((Map)map) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)map.get("prodInstCode")))) {
            return;
        }
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)"bos_sms_signature", (String)"id,signid,status,applyreason", (QFilter[])new QFilter[]{new QFilter("status", "!=", (Object)"1")});
        Map<String, Object> signStatusMap = this.getSignStatus((String)map.get("prodInstCode"));
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        if (signStatusMap != null && signStatusMap.size() > 0) {
            for (DynamicObject data : dataArray) {
                if ("pass".equals(signStatusMap.get(data.getString("signid")))) {
                    data.set("status", (Object)"1");
                    list.add(data);
                    continue;
                }
                if (!"fail".equals(signStatusMap.get(data.getString("signid")))) continue;
                data.set("status", (Object)"2");
                data.set("applyreason", signStatusMap.get(data.getString("signid") + "auditResult"));
                list.add(data);
            }
        }
        if (list != null && list.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
        }
    }
}

