/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class TenantAuthConfigDetailListPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TenantAuthConfigDetailListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"distribut_btn", "distribut"});
    }

    public void afterCreateNewData(EventObject e) {
        List ids;
        DynamicObject[] tenantAuthConfigArray;
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        Object tenantAuthConfigPks = this.getView().getFormShowParameter().getCustomParam("tenantAuthConfigPks");
        if (tenantAuthConfigPks != null && (tenantAuthConfigArray = BusinessDataServiceHelper.load((String)"tenant_auth_config", (String)"id,url,accountid,appid,appsecret,systemname,userflag,thirduser,distributnum", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(ids = (List)tenantAuthConfigPks))})) != null && tenantAuthConfigArray.length > 0) {
            DynamicObject[] tenantConfigDetailList = BusinessDataServiceHelper.load((String)"tenant_auth_config_detail", (String)"id,tenantconfigid,authtenantconfigid,distribut_status,distributdate", null);
            this.loadEntryentity(tenantAuthConfigArray, tenantConfigDetailList);
        }
        if ("detail".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonap_cancel", "distribut_btn"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"buttonap_confirm"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonap_confirm"});
        }
        this.getView().updateView();
    }

    private void loadEntryentity(DynamicObject[] tenantAuthConfigArray, DynamicObject[] tenantConfigDetailList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        HashMap<String, DynamicObject> tenantConfigDetailMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject tenantConfigDetail : tenantConfigDetailList) {
            if (tenantConfigDetail.get("tenantconfigid") == null || tenantConfigDetail.get("authtenantconfigid") == null) continue;
            tenantConfigDetailMap.put(tenantConfigDetail.getString("tenantconfigid.id") + tenantConfigDetail.getString("authtenantconfigid.id"), tenantConfigDetail);
        }
        DynamicObject[] allConfigArray = BusinessDataServiceHelper.load((String)"tenant_auth_config", (String)"id,url,accountid,appid,appsecret,systemname,userflag,thirduser,distributnum", null);
        for (DynamicObject tenantAuthConfig : tenantAuthConfigArray) {
            for (DynamicObject data : allConfigArray) {
                String tenantConfigId = tenantAuthConfig.getString("id");
                String authTenantConfigId = data.getString("id");
                if (StringUtils.isBlank((CharSequence)tenantConfigId) || tenantConfigId.equals(authTenantConfigId)) continue;
                if (tenantConfigDetailMap.containsKey(tenantConfigId + authTenantConfigId)) {
                    list.add((DynamicObject)tenantConfigDetailMap.get(tenantConfigId + authTenantConfigId));
                    continue;
                }
                DynamicObject authConfigDetail = BusinessDataServiceHelper.newDynamicObject((String)"tenant_auth_config_detail");
                authConfigDetail.set("tenantconfigid", (Object)tenantAuthConfig);
                authConfigDetail.set("authtenantconfigid", (Object)data);
                authConfigDetail.set("distribut_status", (Object)"0");
                list.add(authConfigDetail);
            }
        }
        this.fillData(list);
    }

    private void fillData(List<DynamicObject> list) {
        IDataModel model = this.getModel();
        for (DynamicObject data : list) {
            int newEntryRow = model.createNewEntryRow("entryentity");
            this.getModel().beginInit();
            model.setValue("distribut_tenant", data.get("tenantconfigid.systemname"), newEntryRow);
            model.setValue("accountid", data.get("tenantconfigid.accountid"), newEntryRow);
            model.setValue("distribut_status", data.get("distribut_status"), newEntryRow);
            model.setValue("auth_tenant", data.get("authtenantconfigid.systemname"), newEntryRow);
            model.setValue("auth_accountid", data.get("authtenantconfigid.accountid"), newEntryRow);
            model.setValue("auth_appid", data.get("authtenantconfigid.appid"), newEntryRow);
            if (data.get("distributdate") != null) {
                model.setValue("distributdate", data.get("distributdate"), newEntryRow);
            }
            this.getModel().endInit();
        }
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("distribut_btn".equals(key)) {
            ArrayList<DynamicObject> configDetailInsertList = new ArrayList<DynamicObject>(8);
            ArrayList<DynamicObject> tenantconfigUpdateList = new ArrayList<DynamicObject>(8);
            DynamicObject[] tenantConfig = BusinessDataServiceHelper.load((String)"tenant_auth_config", (String)"id,url,accountid,appid,appsecret,systemname,userflag,thirduser,distributnum", null);
            DynamicObject[] tenantConfigDetailList = BusinessDataServiceHelper.load((String)"tenant_auth_config_detail", (String)"id,tenantconfigid,authtenantconfigid,distribut_status,distributdate", null);
            HashMap<String, DynamicObject> tenantConfigDetailMap = new HashMap<String, DynamicObject>(8);
            for (DynamicObject tenantConfigDetail : tenantConfigDetailList) {
                if (tenantConfigDetail.get("tenantconfigid") == null || tenantConfigDetail.get("authtenantconfigid") == null) continue;
                tenantConfigDetailMap.put(tenantConfigDetail.getString("tenantconfigid.id") + tenantConfigDetail.get("authtenantconfigid.id"), tenantConfigDetail);
            }
            for (DynamicObject dynamicObject : tenantConfig) {
                String token = this.getAccessToken(dynamicObject);
                if (!StringUtils.isNotBlank((CharSequence)token)) continue;
                this.dispenseData(tenantConfig, token, dynamicObject.getString("url"), dynamicObject.getString("id"), dynamicObject.getString("appid"));
                dynamicObject.set("distributnum", (Object)(tenantConfig.length - 1));
                tenantconfigUpdateList.add(dynamicObject);
                for (DynamicObject data : tenantConfig) {
                    String authTenantConfigId;
                    String tenantConfigId = dynamicObject.getString("id");
                    if (tenantConfigId.equals(authTenantConfigId = data.getString("id")) || tenantConfigDetailMap.containsKey(tenantConfigId + authTenantConfigId)) continue;
                    DynamicObject configDetail = BusinessDataServiceHelper.newDynamicObject((String)"tenant_auth_config_detail");
                    configDetail.set("tenantconfigid", (Object)dynamicObject);
                    configDetail.set("authtenantconfigid", (Object)data);
                    configDetail.set("distribut_status", (Object)"1");
                    configDetail.set("distributdate", (Object)new Date());
                    configDetail.set("createrid", (Object)RequestContext.get().getCurrUserId());
                    configDetailInsertList.add(configDetail);
                }
            }
            if (tenantconfigUpdateList != null && tenantconfigUpdateList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])tenantconfigUpdateList.toArray(new DynamicObject[tenantconfigUpdateList.size()]));
            }
            if (configDetailInsertList != null && configDetailInsertList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])configDetailInsertList.toArray(new DynamicObject[configDetailInsertList.size()]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u53d1\u5b8c\u6210\u3002", (String)"TenantAuthConfigDetailListPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
            this.getView().getParentView().updateView();
            this.getView().close();
        }
    }

    private String getAccessToken(DynamicObject dynamicObject) {
        String token = "";
        try {
            Map result;
            HashMap headerParam = new HashMap(8);
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("user", dynamicObject.getString("thirduser"));
            body.put("usertype", "UserName");
            String appId = dynamicObject.getString("appid");
            body.put("appId", appId);
            String thirdAccountId = dynamicObject.getString("accountid");
            body.put("accountId", thirdAccountId);
            String appSecuret = dynamicObject.getString("appsecret");
            if (Encrypters.isEncrypted((String)appSecuret)) {
                appSecuret = Encrypters.decode((String)appSecuret);
            }
            body.put("appSecuret", appSecuret);
            String resp = HttpClientUtils.postAppJson((String)(dynamicObject.getString("url") + "/api/login.do"), headerParam, body, (int)5000, (int)3000);
            if (StringUtils.isNotEmpty((CharSequence)resp) && (result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true)).get("data") != null) {
                Map tokenData = (Map)result.get("data");
                token = tokenData.get("access_token").toString();
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return token;
    }

    private boolean dispenseData(DynamicObject[] array, String accessToken, String url, String id, String appId) {
        try {
            Map result;
            HashMap<String, String> headerParam = new HashMap<String, String>(8);
            headerParam.put("accessToken", accessToken);
            HashMap<String, List<Map<String, Object>>> body = new HashMap<String, List<Map<String, Object>>>(8);
            List<Map<String, Object>> list = this.getListData(array, id, appId);
            body.put("params", list);
            String resp = HttpClientUtils.postAppJson((String)(url + "/kapi/v2/secm/tenantConfig/dispense"), headerParam, body, (int)5000, (int)3000);
            logger.info(resp);
            if (StringUtils.isNotEmpty((CharSequence)resp) && (result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true)).get("data") != null) {
                Map tokenData = (Map)result.get("data");
                return true;
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return false;
    }

    private List<Map<String, Object>> getListData(DynamicObject[] array, String id, String appId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject data : array) {
            if (!StringUtils.isBlank((CharSequence)id) && id.equals(data.getString("id"))) continue;
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("thirduser", data.getString("thirduser"));
            body.put("appid", data.getString("appid"));
            body.put("accountid", data.getString("accountid"));
            body.put("appsecret", data.getString("appsecret"));
            body.put("systemname", data.getString("systemname"));
            body.put("userflag", data.getString("userflag"));
            body.put("url", data.getString("url"));
            body.put("oepnApiAppId", appId);
            list.add(body);
        }
        return list;
    }
}

