/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class TenantAuthConfigListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(TenantAuthConfigListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("baritemap_dispense".equals(evt.getItemKey())) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] data = selectedRows.getPrimaryKeyValues();
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("tenant_config_detail_list");
            fsp.setCustomParam("tenantAuthConfigPks", (Object)data);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_config_detail"));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObject[] configArray;
        super.afterDeleteRow(e);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        DeleteServiceHelper.delete((String)"tenant_auth_config_detail", (QFilter[])new QFilter[]{new QFilter("tenantconfigid.id", "in", (Object)ids).or(new QFilter("authtenantconfigid.id", "in", (Object)ids))});
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"tenant_auth_config_detail", (String)"id,tenantconfigid", (QFilter[])new QFilter[]{new QFilter("tenantconfigid.id", "not in", (Object)ids)});
        HashMap<String, Integer> map = new HashMap<String, Integer>(8);
        for (DynamicObject data : array) {
            int num = 1;
            if (map.containsKey(data.getString("tenantconfigid.id"))) {
                num = (Integer)map.get(data.getString("tenantconfigid.id")) + 1;
            }
            map.put(data.getString("tenantconfigid.id"), num);
        }
        for (DynamicObject config : configArray = BusinessDataServiceHelper.load((String)"tenant_auth_config", (String)"id,distributnum", null)) {
            int num = map.get(config.get("id")) != null ? (Integer)map.get(config.get("id")) : 0;
            config.set("distributnum", (Object)num);
        }
        SaveServiceHelper.update((DynamicObject[])configArray);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"distributnum", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] ids = selectedRows.getPrimaryKeyValues();
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("tenant_config_detail_list");
            fsp.setCustomParam("type", (Object)"detail");
            fsp.setCustomParam("tenantAuthConfigPks", (Object)new Object[]{ids[0]});
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView();
    }

    private String getAccessToken(DynamicObject dynamicObject) {
        String token = "";
        try {
            Map result;
            HashMap headerParam = new HashMap(8);
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("user", dynamicObject.getString("thirduser"));
            body.put("usertype", "UserName");
            String appId = dynamicObject.getString("appid");
            body.put("appId", appId);
            String thirdAccountId = dynamicObject.getString("accountid");
            body.put("accountId", thirdAccountId);
            String appSecuret = dynamicObject.getString("appsecret");
            if (Encrypters.isEncrypted((String)appSecuret)) {
                appSecuret = Encrypters.decode((String)appSecuret);
            }
            body.put("appSecuret", appSecuret);
            String resp = HttpClientUtils.postAppJson((String)(dynamicObject.getString("url") + "/api/login.do"), headerParam, body, (int)5000, (int)3000);
            if (StringUtils.isNotEmpty((CharSequence)resp) && (result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true)).get("data") != null) {
                Map tokenData = (Map)result.get("data");
                token = tokenData.get("access_token").toString();
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return token;
    }
}

