/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class ThirdSSOConfigDetecFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object pkValue = fsp.getCustomParam("pkValue");
        if (pkValue != null) {
            this.getView().getPageCache().put("pkValue", pkValue.toString());
            this.detecThirdSSOConfig(pkValue);
        }
    }

    private void detecThirdSSOConfig(Object pkValue) {
        try {
            pkValue = this.getView().getPageCache().get("pkValue");
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"third_sso_auth_config");
            String url = data.getString("url");
            Map<String, Object> body = this.getRequestBody(data);
            Map<String, Object> map = this.detecNetworkservice(url, null, body);
        }
        catch (Exception e) {
            return;
        }
    }

    private Map<String, Object> getRequestBody(DynamicObject data) {
        HashMap<String, Object> body = new HashMap<String, Object>(8);
        body.put("user", data.getString("thirduser"));
        body.put("usertype", "UserName");
        String appId = data.getString("appid");
        body.put("appId", appId);
        String thirdAccountId = data.getString("accountid");
        body.put("accountId", thirdAccountId);
        String appSecuret = data.getString("appsecret");
        if (Encrypters.isEncrypted((String)appSecuret)) {
            appSecuret = Encrypters.decode((String)appSecuret);
        }
        body.put("appSecuret", appSecuret);
        return body;
    }

    private Map<String, Object> detecNetworkservice(String url, Map<String, String> headerParam, Map<String, Object> body) {
        HashMap<String, Object> result = new HashMap(8);
        try {
            result = ThirdSSOConfigDetecFormPlugin.getAccessToken(url, headerParam, body);
        }
        catch (Exception e) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"net_flexpanelap3", "net_labelap3"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"net_labelap2"});
            throw new KDException(new ErrorCode("timed out", "timed out"), new Object[0]);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"net_labelap2"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"net_labelap1"});
        return result;
    }

    private static Map<String, Object> getAccessToken(String url, Map<String, String> headerParam, Map<String, Object> body) throws Exception {
        String resp = HttpClientUtils.postAppJson((String)(url + "/api/login.do"), headerParam, body);
        Map<String, Object> result = new HashMap<String, Object>(8);
        if (StringUtils.isNotEmpty((CharSequence)resp)) {
            result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true);
        }
        return result;
    }
}

