/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ThirdUserMappingDealExcelDataPlugin
extends AbstractFormPlugin {
    private static final String EMPLOYEE = "EMPLOYEE";
    private static final String PHONE = "PHONE";

    public void beforeImportData(BeforeImportDataEventArgs data) {
        super.beforeImportData(data);
        Map sourceDataMap = data.getSourceData();
        if (sourceDataMap.get("userid") == null) {
            data.setCancel(true);
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        Map<String, List<String>> employeePhoneMap = this.getEmployeePhoneMap(sourceDataList);
        Map<String, Map<String, DynamicObject>> phoneEmployeeDynamicObjectMap = this.getPhoneDynamicObjectMap(employeePhoneMap);
        this.fillField(sourceDataList, phoneEmployeeDynamicObjectMap);
    }

    private void fillField(List<Map<String, Object>> sourceDataList, Map<String, Map<String, DynamicObject>> phoneEmployeeDynamicObjectMap) {
        for (Map<String, Object> sourceDataMap : sourceDataList) {
            this.fillSourceDataMap(sourceDataMap, phoneEmployeeDynamicObjectMap);
        }
    }

    private void fillSourceDataMap(Map<String, Object> sourceDataMap, Map<String, Map<String, DynamicObject>> phoneEmployeeDynamicObjectMap) {
        String phoneNum;
        Map<String, DynamicObject> phoneDynamicObjectMap = phoneEmployeeDynamicObjectMap.get(PHONE);
        if (phoneDynamicObjectMap.get(phoneNum = (String)sourceDataMap.get("third_user_phone_num")) != null) {
            sourceDataMap.put("userid", phoneDynamicObjectMap.get(phoneNum).get("id"));
            sourceDataMap.put("user", this.getUserMap(phoneDynamicObjectMap.get(phoneNum)));
            sourceDataMap.put("createdate", new Date());
            return;
        }
        JSONObject userMap = (JSONObject)sourceDataMap.get("user");
        if (userMap == null) {
            return;
        }
        String employeeNo = (String)userMap.get((Object)"number");
        if (StringUtils.isBlank((CharSequence)employeeNo)) {
            return;
        }
        Map<String, DynamicObject> employeeDynamicObjectMap = phoneEmployeeDynamicObjectMap.get(EMPLOYEE);
        if (employeeDynamicObjectMap.get(employeeNo) != null) {
            sourceDataMap.put("userid", employeeDynamicObjectMap.get(employeeNo).get("id"));
            sourceDataMap.put("user", this.getUserMap(employeeDynamicObjectMap.get(employeeNo)));
            sourceDataMap.put("createdate", new Date());
        }
    }

    private Map<String, Map<String, DynamicObject>> getPhoneDynamicObjectMap(Map<String, List<String>> employeePhoneMap) {
        List<String> employeeList = employeePhoneMap.get(EMPLOYEE);
        QFilter employeeFilter = new QFilter("number", "in", employeeList);
        Map userConfigMapByEmployee = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{employeeFilter});
        HashMap employeeDynamicObjectMap = new HashMap();
        userConfigMapByEmployee.entrySet().stream().forEach(entry -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)employeeDynamicObjectMap.put((String)((DynamicObject)entry.getValue()).get("number"), entry.getValue());
        });
        List<String> phoneNumList = employeePhoneMap.get(PHONE);
        QFilter phoneFilter = new QFilter("phone", "in", phoneNumList);
        Map userConfigMapByPhone = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{phoneFilter});
        HashMap phoneDynamicObjectMap = new HashMap();
        userConfigMapByPhone.entrySet().stream().forEach(entry -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)phoneDynamicObjectMap.put((String)((DynamicObject)entry.getValue()).get("phone"), entry.getValue());
        });
        return ImmutableMap.of((Object)EMPLOYEE, employeeDynamicObjectMap, (Object)PHONE, phoneDynamicObjectMap);
    }

    private Map<String, List<String>> getEmployeePhoneMap(List<Map<String, Object>> sourceDataList) {
        ArrayList<String> phoneNumList = new ArrayList<String>(0);
        ArrayList<String> employeeList = new ArrayList<String>(0);
        ImmutableMap employeePhoneMap = ImmutableMap.of((Object)EMPLOYEE, employeeList, (Object)PHONE, phoneNumList);
        for (Map<String, Object> sourceDataMap : sourceDataList) {
            JSONObject userMap = (JSONObject)sourceDataMap.get("user");
            if (userMap == null) {
                this.getAndAddPhoneNum(sourceDataMap, phoneNumList);
                continue;
            }
            String employeeNo = (String)userMap.get((Object)"number");
            if (StringUtils.isBlank((CharSequence)employeeNo)) {
                this.getAndAddPhoneNum(sourceDataMap, phoneNumList);
                continue;
            }
            employeeList.add(employeeNo);
        }
        return employeePhoneMap;
    }

    private void getAndAddPhoneNum(Map<String, Object> sourceDataMap, List<String> phoneNumList) {
        String phoneNum = (String)sourceDataMap.get("third_user_phone_num");
        if (StringUtils.isNotBlank((CharSequence)phoneNum)) {
            phoneNumList.add(phoneNum);
        }
    }

    private Map<String, Object> getUserMap(DynamicObject userConfig) {
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("importprop", "id");
        userMap.put("id", userConfig.get("id"));
        return userMap;
    }
}

