/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class ThirdUserMappingPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener {
    private static final String USER = "user";
    private static final String IMTYPE = "imtype";
    private static final String CONFIRM = "confirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(USER);
        edit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit imtype = (BasedataEdit)this.getView().getControl(IMTYPE);
        imtype.addAfterF7SelectListener((AfterF7SelectListener)this);
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String key;
        switch (key = ((BasedataEdit)evt.getSource()).getKey()) {
            case "user": {
                this.copyUserIdToUserIdField();
                break;
            }
            case "imtype": {
                DynamicObject imtype = (DynamicObject)this.getModel().getValue(IMTYPE);
                String number = (String)imtype.get("number");
                if ("WXQYH".equals(number)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"encryopenid"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"encryopenid"});
            }
        }
    }

    private void copyUserIdToUserIdField() {
        DynamicObject user = (DynamicObject)this.getModel().getValue(USER);
        if (this.userIsDeleted(user)) {
            this.getModel().setValue("userid", null);
            return;
        }
        Object userId = user.get("id");
        this.getModel().setValue("userid", userId);
    }

    private boolean userIsDeleted(DynamicObject user) {
        return Objects.isNull(user);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey())) {
            DynamicObject imtype = (DynamicObject)this.getModel().getValue(IMTYPE);
            String number = (String)imtype.get("number");
            if ("WXQYH".equals(number)) {
                String openId = (String)this.getModel().getValue("openid");
                String encryopenid = (String)this.getModel().getValue("encryopenid");
                if (StringUtils.isBlank((CharSequence)openId) && StringUtils.isBlank((CharSequence)encryopenid)) {
                    args.setCancel(true);
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7b2c\u4e09\u65b9\u7528\u6237ID\u201d\u6216\u201c\u7b2c\u4e09\u65b9\u5bc6\u6587\u7528\u6237ID\u201d\u81f3\u5c11\u4e00\u4e2a\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdUserMappingPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
                }
            } else {
                String openId = (String)this.getModel().getValue("openid");
                if (StringUtils.isBlank((CharSequence)openId)) {
                    args.setCancel(true);
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7b2c\u4e09\u65b9\u7528\u6237ID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ThirdUserMappingPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

