/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.plugin.AbstractThirdAppConfigPlugin;
import kd.bos.login.thirdauth.app.tencent.WxqyhUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class WxqyhConfigFormPlugin
extends AbstractThirdAppConfigPlugin {
    private static final Log logger = LogFactory.getLog(WxqyhConfigFormPlugin.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String CURRENTHOST = "host";

    @Override
    protected Long getImType() {
        return 3L;
    }

    @Override
    protected String getConfigDetecFormId() {
        return "third_qywxconfig_detec";
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String trustedip = (String)this.getModel().getValue("trustedip");
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)trustedip)), new String[]{"iptimepanel", "copyipicon"});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "operationurl": {
                String url = "https://vip.kingdee.com/knowledge/specialDetail/228892721203874816?category=228893083373702400&id=228896192930124032&lang=%s";
                this.getView().openUrl(String.format(url, this.getLangValue()));
                break;
            }
            case "btncreateapp": {
                this.getView().openUrl("https://work.weixin.qq.com/wework_admin/loginpage_wx");
                break;
            }
            case "getiplabel": {
                this.getTrustedIp();
                break;
            }
        }
    }

    @Override
    protected String createUrl(String key) {
        DynamicObject form;
        String urlParamsFormat;
        if ("webform".equals(key)) {
            urlParamsFormat = "%s/index.html?formId=%s&accountId=%s&apptype=wxqyh&corpid=%s&agentid=%s";
        } else if ("mobileform".equals(key)) {
            urlParamsFormat = "%s/mobile.html?form=%s&accountId=%s&apptype=wxqyh&corpid=%s&agentid=%s";
        } else {
            return "";
        }
        String domainUrl = (String)this.getModel().getValue(CURRENTHOST);
        if (StringUtils.isNotBlank((CharSequence)domainUrl)) {
            domainUrl = RevProxyUtil.removeSlash((String)domainUrl);
        }
        if ((form = (DynamicObject)this.getModel().getValue(key)) == null) {
            return "";
        }
        String formId = form.getString("number");
        String accountId = RequestContext.get().getAccountId();
        String corpid = (String)this.getModel().getValue("corpid");
        String agentid = (String)this.getModel().getValue("agentid");
        String url = String.format(urlParamsFormat, domainUrl, formId, accountId, corpid, agentid);
        try {
            String encodeUrl = URLEncoder.encode(url, StandardCharsets.UTF_8.name());
            String wxUrl = String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_privateinfo&state=STATE&agentid=%s#wechat_redirect", corpid, encodeUrl, agentid);
            return wxUrl;
        }
        catch (Exception e) {
            logger.info("encode url error", (Object)e);
            return "";
        }
    }

    @Override
    protected boolean createUrlEnable() {
        String currenthost = (String)this.getModel().getValue(CURRENTHOST);
        Object webform = this.getModel().getValue("webform");
        Object mobileform = this.getModel().getValue("mobileform");
        String corpid = (String)this.getModel().getValue("corpid");
        String agentid = (String)this.getModel().getValue("agentid");
        boolean flag = StringUtils.isNotBlank((CharSequence)corpid) && StringUtils.isNotBlank((CharSequence)agentid) && StringUtils.isNotBlank((CharSequence)currenthost) && (webform != null || mobileform != null);
        return flag;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("corpid".equals(propertyName) || "agentid".equals(propertyName)) {
            this.setCreateUrlEnableAndFcColor();
        }
    }

    private void getTrustedIp() {
        String corpid = (String)this.getModel().getValue("corpid");
        String corpsecret = (String)this.getModel().getValue("corpsecret");
        if (StringUtils.isBlank((CharSequence)corpid) || StringUtils.isBlank((CharSequence)corpsecret)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u3010\u4f01\u4e1aID\u3011\u4e0e\u3010\u5e94\u7528\u5bc6\u94a5\u3011\u3002", (String)"WxqyhConfigFormPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        try {
            String subopdesc;
            String ip;
            String errmsg;
            Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
            String accessToken = WxqyhUtils.getAccess_token((String)corpid, (String)corpsecret, (Account)account);
            String encode = Base64.getEncoder().encodeToString(corpid.getBytes(StandardCharsets.UTF_8));
            String code = encode.length() > 10 ? encode.substring(0, 10) : encode;
            Map map = WxqyhUtils.getUserByCodeWithException((String)accessToken, (String)code, (Account)account);
            if (map.get("errcode") != null && ("60020".equals(String.valueOf(map.get("errcode"))) || "40029".equals(String.valueOf(map.get("errcode")))) && (errmsg = (String)map.get("errmsg")).contains("ip:") && StringUtils.isNotBlank((CharSequence)(ip = (subopdesc = errmsg.substring(errmsg.indexOf("ip:") + 3)).substring(0, subopdesc.indexOf(","))))) {
                this.getModel().setValue("trustedip", (Object)ip.trim());
                this.getModel().setValue("iptime", (Object)new Date());
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"iptimepanel", "copyipicon"});
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6ip\u5931\u8d25\u3002", (String)"WxqyhConfigFormPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }
}

