/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.thirdauth.app.tencent.WxqyhUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.DisCardUtil;
import org.apache.commons.lang3.StringUtils;

public class WxqyhDetecFormPlugin
extends AbstractFormPlugin {
    private static final String AGENTID = "agentid";
    private static final String CORPID = "corpid";
    private static final String CORPSECRET = "corpsecret";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"start_detec", "cancel_detec", "redetec"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object pkValue = fsp.getCustomParam("pkValue");
        if (pkValue != null) {
            this.getPageCache().put("selectedPk", pkValue.toString());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String pkValue = this.getPageCache().get("selectedPk");
        if ("start_detec".equals(key)) {
            this.startDetecConfig(pkValue);
        } else if ("redetec".equals(key)) {
            this.reStartDetecConfig(pkValue);
        }
    }

    private void startDetecConfig(String pkValue) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tabpageap_detec");
        this.getView().addClientCallBack("detecNetworkservice");
    }

    private void reStartDetecConfig(String pkValue) {
        this.getView().updateView();
        this.startDetecConfig(pkValue);
    }

    private boolean detecTrustIP(String corpId, String corpSecret, Account currentCenter) {
        String accessToken = "";
        try {
            accessToken = WxqyhUtils.getAccessTokenWithException((String)corpId, (String)corpSecret, (Account)currentCenter);
            String string = WxqyhUtils.getUserIdWithException((Map)WxqyhUtils.getUserByCodeWithException((String)accessToken, (String)"jdfjsdfdsgfjhhjh", (Account)currentCenter));
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            if ("60020".equals(e.getErrorCode().getCode())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"ip_labelflexpanelap3", "ip_labelap3"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ip_labelap2"});
                throw e;
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"ip_labelap2"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"ip_labelap"});
        return true;
    }

    private boolean detecGetAccessToken(String corpId, String corpSecret, Account currentCenter) {
        String accessToken = "";
        try {
            accessToken = WxqyhUtils.getAccessTokenWithException((String)corpId, (String)corpSecret, (Account)currentCenter);
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"gettoken_labelap2"});
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"gettoken_lflexpanelap3", "gettoken_labelap3"});
            throw new KDException(new ErrorCode("getAccessToken_error", "getAccessToken is error"), new Object[0]);
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"gettoken_labelap1"});
        this.getView().addClientCallBack("detecTrustIP");
        return true;
    }

    private boolean detecPluginConfig(DynamicObject data) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"plugin_labelap2"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"plugin_labelap1"});
        this.getView().addClientCallBack("detecGetAccessToken");
        return true;
    }

    private boolean detecParamsConfig(DynamicObject data) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"params_labelap2"});
        if (!"true".equals(data.getString("enable")) || StringUtils.isBlank((CharSequence)data.getString(AGENTID)) || StringUtils.isBlank((CharSequence)data.getString(CORPID)) || StringUtils.isBlank((CharSequence)data.getString(CORPSECRET))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"params_flexpanelap3", "params_labelap3"});
            throw new KDException(new ErrorCode("parsms_error", "parsms is error"), new Object[0]);
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"params_labelap1"});
        this.getView().addClientCallBack("detecPluginConfig");
        return true;
    }

    private boolean detecNetworkservice(String corpId, String corpSecret, Account currentCenter) {
        try {
            String string = WxqyhUtils.getAccessTokenWithException((String)corpId, (String)corpSecret, (Account)currentCenter);
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            if ("timed out".equals(e.getErrorCode().getCode())) {
                String url = WxqyhUtils.getQywxhHost((Account)currentCenter);
                if (StringUtils.isNotBlank((CharSequence)url) && !url.contains("https://qyapi.weixin.qq.com")) {
                    Label label = (Label)this.getControl("labelap_net_tip");
                    label.setText(ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u4f01\u4e1a\u5fae\u4fe1\u5730\u5740\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u53c2\u6570--\u4f01\u4e1a\u5fae\u4fe1\u53c2\u6570--\u4f01\u4e1a\u5fae\u4fe1URL\u662f\u5426\u6b63\u786e\u3002", (String)"WxqyhDetecFormPlugin_2", (String)"bos-portal-plugin", (Object[])new Object[0]));
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"net_flexpanelap3", "net_labelap3"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"net_labelap2"});
                throw e;
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"net_labelap1"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"net_labelap2"});
        this.getView().addClientCallBack("detecParamsConfig");
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isChange = this.getView().getPageCache().get("isChange");
        this.getView().returnDataToParent((Object)isChange);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String pkValue = this.getPageCache().get("selectedPk");
        if (StringUtils.isBlank((CharSequence)pkValue)) {
            return;
        }
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkValue), (String)"bos_wxqy_config");
        if (data == null) {
            return;
        }
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            DisCardUtil.discard();
        }
        try {
            if ("detecNetworkservice".equals(e.getName())) {
                this.detecNetworkservice(data.getString(CORPID), data.getString(CORPSECRET), currentCenter);
            } else if ("detecParamsConfig".equals(e.getName())) {
                this.detecParamsConfig(data);
            } else if ("detecPluginConfig".equals(e.getName())) {
                this.detecPluginConfig(data);
            } else if ("detecGetAccessToken".equals(e.getName())) {
                this.detecGetAccessToken(data.getString(CORPID), data.getString(CORPSECRET), currentCenter);
            } else if ("detecTrustIP".equals(e.getName()) && this.detecTrustIP(data.getString(CORPID), data.getString(CORPSECRET), currentCenter)) {
                data.set("connstatus", (Object)"1");
                SaveServiceHelper.update((DynamicObject)data);
                Tab tab = (Tab)this.getView().getControl("tabap");
                tab.activeTab("tabpageap_success");
            }
        }
        catch (Exception ex) {
            data.set("connstatus", (Object)"2");
            SaveServiceHelper.update((DynamicObject)data);
            Label label = (Label)this.getControl("labelap_title");
            label.setText(ResManager.loadKDString((String)"\u914d\u7f6e\u68c0\u6d4b\u7ec8\u6b62", (String)"WxqyhDetecFormPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancel_detec"});
        }
        this.getView().getPageCache().put("isChange", "true");
    }
}

