/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.devportal.plugin.AppListPlugin;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AllUserAppBlackListPlugin
extends AbstractListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        args.getCustomParams().put("isOrgBaseAdmin", Boolean.TRUE);
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAdminChargeOrg((Long)userId, (String)"01");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            List perOrgList = hasPermOrgResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("org", "in", (Object)perOrgList);
            filters.add(orgFilter);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!isAdmin) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4ec5\u7ba1\u7406\u5458\u53ef\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"AllUserAppBlackListPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                List appIds = rows.stream().map(row -> {
                    DynamicObject bizApp = row.getDynamicObject("app");
                    if (bizApp != null) {
                        return bizApp.getString("id");
                    }
                    return "";
                }).collect(Collectors.toList());
                Map dictionaries = AppListPlugin.getDictionaries(appIds);
                for (DynamicObject row2 : rows) {
                    String appId;
                    Map appMap;
                    DynamicObject bizApp = row2.getDynamicObject("app");
                    if (bizApp == null || (appMap = (Map)dictionaries.get(appId = bizApp.getString("id"))) == null) continue;
                    Object extName = appMap.get("name");
                    row2.set("app.name", extName);
                }
                return rows;
            }
        });
    }
}

