/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.login.utils.LoginUtils;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.IPrivacyStatementService;
import kd.bos.portal.service.impl.PrivacyStatementServiceImpl;
import kd.bos.portal.util.PortalLogUtils;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.url.UrlService;

public class PrivacyStatementOperationPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_BACKOUT = "btnbkout";
    private static final String BTN_ISEE = "btnisee";
    private static final String VECTORAP_DOWNLOAD = "vectorap_download";
    private static final String LABELAP_DOWNLOAD = "labelap_download";
    private static final String LOCATION = "location";
    private static final String DISAGREE_CONFIRM = "disagree_comfirm";
    private static final String BACKOUT_STATUS = "2";
    private static final String AGREE_STATUS = "1";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private IPrivacyStatementService privacyStatementService = new PrivacyStatementServiceImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_OK, BTN_BACKOUT, VECTORAP_DOWNLOAD, LABELAP_DOWNLOAD});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        Map<Object, Object> mapData = new HashMap(8);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            mapData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        }
        if (ObjectUtils.isEmpty(mapData)) {
            String privacystmtId = (String)this.getView().getFormShowParameter().getCustomParam("privacystmtId");
            if (StringUtils.isBlank((CharSequence)privacystmtId)) {
                return;
            }
            mapData = this.getPrivacystmtData(privacystmtId);
            if (ObjectUtils.isEmpty(mapData)) {
                return;
            }
            data = SerializationUtils.toJsonString(mapData);
        }
        if (!ObjectUtils.isEmpty(mapData)) {
            String content = (String)mapData.get("content");
            Html html = (Html)this.getControl("htmlap");
            html.setConent(String.format("<div>%s</div>", content));
            this.getPageCache().put("data", data);
            this.getPageCache().put(LOCATION, (String)mapData.get(LOCATION));
            String location = (String)mapData.get(LOCATION);
            if ("searchPage".equals(location)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, BTN_CANCEL});
                String userid = (String)mapData.get("userid");
                String useridCtx = RequestContext.get().getUserId();
                if (!useridCtx.equals(userid)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BACKOUT});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ISEE});
                }
                String isagree = (String)mapData.get("isagree");
                if (!AGREE_STATUS.equals(isagree)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BACKOUT});
                    this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ISEE});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BACKOUT, BTN_ISEE});
            }
            HashMap<String, Boolean> controlMetadata = new HashMap<String, Boolean>();
            controlMetadata.put("isShowClose", Boolean.FALSE);
            this.getView().updateControlMetadata(this.getView().getRootControl().getKey(), controlMetadata);
            this.getView().updateView("htmlap");
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.agreeSign();
                this.getView().close();
                break;
            }
            case "btncancel": 
            case "btnbkout": {
                this.disagreeSign();
                break;
            }
            case "vectorap_download": 
            case "labelap_download": {
                this.downloadPrivacy();
                break;
            }
        }
    }

    private void downloadPrivacy() {
        Map<String, String> privacyData = this.getPrivacyData();
        String pkid = privacyData.get("pkid");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pkid)) {
            return;
        }
        ArrayList<Object> pkList = new ArrayList<Object>(2);
        pkList.add(Long.parseLong(pkid));
        this.printPrivacy(pkList);
    }

    private void printPrivacy(List<Object> pks) {
        PrintWork printWork = new PrintWork();
        printWork.setPrintLang(RequestContext.get().getLang().name());
        printWork.setExpType("pdf");
        PrintTask printTask = new PrintTask();
        printTask.setPkIds(pks);
        printTask.setTplId(BosPrintServiceHelper.getTplIdByNum((String)"kdprint_privacystatement_prtpl"));
        ArrayList<PrintTask> printTasks = new ArrayList<PrintTask>(2);
        printTasks.add(printTask);
        printWork.setTaskList(printTasks);
        PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)printWork);
        List attachDetails = prtAttach.getAttachDetail();
        if (attachDetails != null && !attachDetails.isEmpty()) {
            PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)attachDetails.get(0);
            String filePath = attachDetail.getFilePath();
            IFormView view = this.getView();
            if (view instanceof MobileFormView) {
                PrtTaskResult.Attach attach = new PrtTaskResult.Attach();
                attach.setAttachId(attachDetail.getAttachId());
                ArrayList<PrtTaskResult.Attach> attachList = new ArrayList<PrtTaskResult.Attach>(2);
                attachList.add(attach);
                PrintOperationHelper.mobilePreview((IFormView)view, (IFormView)view, (Object)prtAttach.getTaskId(), attachList);
                return;
            }
            if (filePath != null) {
                String url = LoginUtils.getPathString((String)UrlService.getDomainContextUrl()) + "api/print/download.do?taskId=%1s&attachId=%2s&downloadAttach=true";
                this.getView().download(String.format(url, prtAttach.getTaskId(), attachDetail.getAttachId()));
            }
        }
    }

    private void agreeSign() {
        this.saveEntity(1);
        this.getPageCache().remove("data");
    }

    private void disagreeSign() {
        String location = this.getPageCache().get(LOCATION);
        if ("searchPage".equals(location)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u9500\u201c\u9690\u79c1\u653f\u7b56\u201d\u7684\u540c\u610f\u540e\uff0c\u5c06\u65e0\u6cd5\u4f7f\u7528\u7cfb\u7edf\u5e76\u81ea\u52a8\u9000\u51fa\uff0c\u786e\u8ba4\u8981\u64a4\u9500\u5417\uff1f", (String)"PrivacyStatementOperationPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener(DISAGREE_CONFIRM, (IFormPlugin)this), null, BACKOUT_STATUS);
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u4e0d\u540c\u610f\u5e76\u9000\u51fa\u8d26\u53f7\uff1f", (String)"PrivacyStatementOperationPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener(DISAGREE_CONFIRM, (IFormPlugin)this), null, "0");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String value = mbce.getCustomVaule();
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals(DISAGREE_CONFIRM) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.saveEntity(Integer.valueOf(value));
            this.loginout();
        }
    }

    private void loginout() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>();
        mpURL.put("url", "auth/logout.do");
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
        PortalLogUtils.addLog("bos_user", "83bfebc8000037ac", "logout", new MultiLangEnumBridge("\u9000\u51fa", "PrivacyStatementOperationPlugin_2", BOS_PORTAL_PLUGIN), new MultiLangEnumBridge("\u9000\u51fa\u6210\u529f", "PrivacyStatementOperationPlugin_3", BOS_PORTAL_PLUGIN), new String[0]);
    }

    private void saveEntity(Integer isagree) {
        String privacystmtParam = "privacystmt";
        String isagreeParam = "isagree";
        String modifytimeParam = "modifytime";
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Map<String, String> mapData = this.getPrivacyData();
        String pkid = mapData.get("pkid");
        String formid = mapData.get("formid");
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter privacyFilter = null;
        privacyFilter = StringUtils.isNotBlank((CharSequence)formid) ? new QFilter("privacystmt.form", "=", (Object)formid).and(new QFilter("privacystmt.usescope", "=", (Object)"0")) : new QFilter("privacystmt.usescope", "=", (Object)AGREE_STATUS);
        DynamicObject userPrivacy = BusinessDataServiceHelper.loadSingle((String)"userprivacystmt", (String)"id, user, privacystmt, isagree, modifytime", (QFilter[])new QFilter[]{userFilter, privacyFilter});
        if (userPrivacy != null) {
            DynamicObject objForSave = BusinessDataServiceHelper.newDynamicObject((String)"userprivacystmthistory");
            objForSave.set("user", userPrivacy.get("user"));
            objForSave.set(privacystmtParam, userPrivacy.get(privacystmtParam));
            objForSave.set(isagreeParam, userPrivacy.get(isagreeParam));
            objForSave.set(modifytimeParam, userPrivacy.get(modifytimeParam));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objForSave});
        } else {
            userPrivacy = BusinessDataServiceHelper.newDynamicObject((String)"userprivacystmt");
        }
        userPrivacy.set("user", (Object)userId);
        userPrivacy.set(privacystmtParam, (Object)pkid);
        userPrivacy.set(isagreeParam, (Object)isagree);
        userPrivacy.set(modifytimeParam, (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userPrivacy});
    }

    private Map<String, String> getPrivacyData() {
        String data = this.getPageCache().get("data");
        return (Map)SerializationUtils.fromJsonString((String)data, Map.class);
    }

    private Map<String, String> getPrivacystmtData(String privacystmtId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("id", "=", (Object)Long.parseLong(privacystmtId)));
        DynamicObject[] dynamicObject = this.privacyStatementService.getPrivacyStatement(filters);
        HashMap<String, String> result = new HashMap<String, String>(8);
        if (dynamicObject != null && dynamicObject.length > 0) {
            DynamicObject privacystmt = dynamicObject[0];
            result.put("content", String.valueOf(privacystmt.get("content_tag")));
            result.put("pkid", String.valueOf(privacystmt.get("id")));
        }
        return result;
    }
}

