/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrivacyStatementPlugin
extends AbstractFormPlugin {
    public static final String FORM = "form";
    private static final Log logger = LogFactory.getLog(PrivacyStatementPlugin.class);
    private static final String KEY_MAINBAR = "tbmain";
    private static final String BTN_SAVE = "bar_save";
    private static final String BTN_SUBMIT = "bar_submit";
    private static final String BTN_SAVEANDNEW = "bar_saveandnew";
    private static final String BTN_CLOSE = "bar_close";
    private static final String CONTENT = "content_tag";
    private static final String PRIVACY_STATEMENT_TPL = "privacystatementtpl";
    private static final String HTMLEDIT = "htmledit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object obj = this.getModel().getValue(CONTENT);
        if (StringUtils.isNotBlank((Object)obj)) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(HTMLEDIT);
            richTextEditor.setText(obj.toString());
        }
        this.showViewByUseScope();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_save": 
            case "bar_submit": 
            case "bar_close": 
            case "bar_saveandnew": {
                this.copyRichtextedit2Content();
                break;
            }
        }
    }

    private void importByTpl() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)PRIVACY_STATEMENT_TPL, (boolean)false);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PRIVACY_STATEMENT_TPL));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (PRIVACY_STATEMENT_TPL.equals(actionId) && (selectedRows = (ListSelectedRowCollection)e.getReturnData()) != null && selectedRows.size() == 1) {
            Object pkId = selectedRows.getPrimaryKeyValues()[0];
            DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)PRIVACY_STATEMENT_TPL);
            String content = dyObj.getString(CONTENT);
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(HTMLEDIT);
            richTextEditor.setText(content);
        }
    }

    private void copyRichtextedit2Content() {
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(HTMLEDIT);
        String content = richTextEditor.getText();
        this.getModel().setValue(CONTENT, (Object)content);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (opKey) {
            case "importbytpl": {
                this.importByTpl();
                break;
            }
        }
        if (evt.getSource() instanceof SaveAndNew) {
            this.clearRichtextedit();
        }
    }

    private void clearRichtextedit() {
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(HTMLEDIT);
        richTextEditor.setText("");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"usescope", (CharSequence)fieldKey)) {
            this.showViewByUseScope();
        }
    }

    private void showViewByUseScope() {
        FieldEdit fieldEdit = (FieldEdit)this.getControl(FORM);
        if ("1".equals(this.getModel().getValue("usescope"))) {
            this.getModel().setValue(FORM, null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FORM});
            fieldEdit.setMustInput(false);
            this.getView().updateView(FORM);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FORM});
            fieldEdit.setMustInput(true);
            this.getView().updateView(FORM);
        }
    }
}

