/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PrivacyStatementSaveValidate
extends AbstractValidator {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public void validate() {
        for (ExtendedDataEntity dynamicObject : this.dataEntities) {
            DynamicObject countryObj;
            QFilter countryFilter;
            QFilter pkidNotEqFilter;
            String locale;
            QFilter localeFilter;
            QFilter[] filter;
            DynamicObjectCollection privacystmts;
            Object id = dynamicObject.getBillPkId();
            DynamicObject baseData = dynamicObject.getDataEntity();
            String version = baseData.getString("version");
            Pattern a = Pattern.compile("^[v]+\\d+(.\\d+){0,1}?$");
            Matcher m = a.matcher(version);
            if (!m.matches()) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u7248\u672c\u683c\u5f0f\u8981\u6c42\uff1a\u4ee5\u5c0f\u5199\u5b57\u6bcdv\u5f00\u5934\uff0c\u4f8b\u5982\u201cv1.0\u201d\u3001\u201cv2.3\u201d\u3002", (String)"PrivacyStatementSaveValidate_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                break;
            }
            DynamicObject formObj = baseData.getDynamicObject("form");
            String useScope = baseData.getString("usescope");
            if (formObj == null && "0".equals(useScope)) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"PrivacyStatementSaveValidate_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                break;
            }
            QFilter useScopeFilter = new QFilter("usescope", "=", (Object)useScope);
            DynamicObject localeObj = baseData.getDynamicObject("locale");
            if (localeObj == null) {
                this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u8bed\u79cd\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u8bed\u79cd\u3002", (String)"PrivacyStatementSaveValidate_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                break;
            }
            QFilter formFilter = null;
            if (formObj != null && StringUtils.isNotEmpty((CharSequence)formObj.getString("number"))) {
                String formid = formObj.getString("number");
                formFilter = new QFilter("form", "=", (Object)formid);
            }
            if (CollectionUtils.isEmpty((Collection)(privacystmts = QueryServiceHelper.query((String)"privacystatement", (String)"id, number, name, version, locale, form, content_tag", (QFilter[])(filter = new QFilter[]{formFilter, localeFilter = new QFilter("locale.number", "=", (Object)(locale = localeObj.getString("number"))), pkidNotEqFilter = new QFilter("id", "!=", id), useScopeFilter, countryFilter = new QFilter("country", "=", (countryObj = baseData.getDynamicObject("country")) == null ? Integer.valueOf(0) : countryObj.get("id"))}))))) continue;
            List list = privacystmts.stream().map(d -> d.getString("version")).collect(Collectors.toList());
            String maxVersion = list.stream().max(Comparator.comparing(v -> Double.valueOf(v.substring(1)))).orElse("v0");
            Double curVersionNum = Double.valueOf(version.substring(1));
            Double maxVersionNum = Double.valueOf(maxVersion.substring(1));
            int result = maxVersionNum.compareTo(curVersionNum);
            if (result < 0) continue;
            String message = String.format(ResManager.loadKDString((String)"\u65b0\u7248\u672c\u53f7\u9700\u8981\u5927\u4e8e\u5386\u53f2\u7248\u672c\uff1a%s\u3002", (String)"PrivacyStatementSaveValidate_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), maxVersion);
            this.addErrorMessage(dynamicObject, message);
            break;
        }
    }
}

