/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PrivacyStatementSignPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(PrivacyStatementSignPlugin.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String KEY_MAINBAR = "tbmain";

    public void chat(ChatEvent e) {
        e.setCancel(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        this.addUserFilter(filters);
    }

    private void addUserFilter(List<QFilter> filters) {
        RequestContext context = RequestContext.get();
        Long userId = Long.parseLong(context.getUserId());
        UserScopeResult userScopeResult = PermissionServiceHelper.getAdminChargeUser((Long)userId);
        if (!userScopeResult.isAllUser()) {
            List userIds = userScopeResult.getUserIDs();
            userIds.add(userId);
            QFilter userFilter = new QFilter("user", "in", (Object)userIds);
            filters.add(userFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "tbldetail": {
                this.showForm();
                break;
            }
            case "tblhistory": {
                this.showHistory();
                break;
            }
        }
    }

    private void showHistory() {
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = this.selectOneRow();
        }
        catch (Exception e) {
            logger.info("selectOneRow", (Object)e);
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        DynamicObject privacystmt = dynamicObject.getDynamicObject("privacystmt");
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"userprivacystmthistory", (boolean)false);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject user = dynamicObject.getDynamicObject("user");
        if (user == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"PrivacyStatementSignPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object userId = user.get("id");
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("userId", userId);
        DynamicObject formObject = privacystmt.getDynamicObject("form");
        if (!ObjectUtils.isEmpty((Object)formObject)) {
            Object formid = formObject.get("number");
            filterMap.put("form", formid);
        }
        lsp.setCustomParam("filterParams", (Object)SerializationUtils.toJsonString(filterMap));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private DynamicObject selectOneRow() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() != 1) {
            String message = rows.size() > 1 ? ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"PrivacyStatementSignPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PrivacyStatementSignPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            throw new KDException(new ErrorCode("sys.perm.selectOneRowError", message), new Object[0]);
        }
        ListSelectedRow row = rows.get(0);
        long id = (Long)row.getPrimaryKeyValue();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        String entityName = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
    }

    private void showForm() {
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = this.selectOneRow();
        }
        catch (Exception e) {
            logger.info("selectOneRow", (Object)e);
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        DynamicObject privacystmt = dynamicObject.getDynamicObject("privacystmt");
        String pkid = privacystmt.getString("id");
        privacystmt = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"privacystatement");
        String content = privacystmt.getString("content_tag");
        DynamicObject formObject = privacystmt.getDynamicObject("form");
        Object formid = "";
        if (!ObjectUtils.isEmpty((Object)formObject)) {
            formid = formObject.get("number");
        }
        DynamicObject user = dynamicObject.getDynamicObject("user");
        String userId = null;
        if (user != null) {
            userId = user.getString("id");
        }
        String isagree = dynamicObject.getString("isagree");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("privacystmtsignpage");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("pkid", pkid);
        data.put("content", content);
        data.put("formid", formid.toString());
        data.put("location", "searchPage");
        data.put("isagree", isagree);
        data.put("userid", userId);
        fsp.setCustomParam("data", (Object)SerializationUtils.toJsonString(data));
        this.getView().showForm(fsp);
    }
}

