/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.IPrivacyStatementService;
import kd.bos.portal.service.impl.PrivacyStatementServiceImpl;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PrivacyStatementTplListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(PrivacyStatementTplListPlugin.class);
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String ENABLE_MATCH_COUNTRY = "enable_match_country";
    public static final String CONFIRM_CALLBACK = "confirm_callback";
    private IPrivacyStatementService privacyStatementService = new PrivacyStatementServiceImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ENABLE_MATCH_COUNTRY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Optional<Boolean> countrySwitchOp = this.privacyStatementService.isCountrySwitchOpen();
        if (!countrySwitchOp.isPresent()) {
            this.insertData();
            return;
        }
        Boolean countrySwitch = countrySwitchOp.get();
        if (countrySwitch.booleanValue()) {
            this.changeButtonTextToClose();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (opKey) {
            case "enable_match_country": {
                this.openOrCloseSwitch();
                break;
            }
        }
    }

    private void openOrCloseSwitch() {
        Optional<Boolean> countrySwitchOp = this.privacyStatementService.isCountrySwitchOpen();
        if (!countrySwitchOp.isPresent()) {
            log.info("PrivacyStatementTplListPlugin openOrCloseSwitch countrySwitch is null");
            return;
        }
        Boolean countrySwitch = countrySwitchOp.get();
        if (countrySwitch.booleanValue()) {
            this.closeSwitch();
        } else {
            this.popUpConfirmationDialogs();
        }
    }

    private void closeSwitch() {
        this.updateSwitchToClose();
        this.changeButtonTextToOpen();
        this.popUpCloseSuccessToast();
    }

    private void popUpCloseSuccessToast() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f\u3002", (String)"PrivacyStatementTplListPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private void popUpOpenSuccessToast() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u542f\u6210\u529f\u3002", (String)"PrivacyStatementTplListPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private void changeButtonTextToOpen() {
        HashMap<String, LocaleString> buttonPropMap = new HashMap<String, LocaleString>();
        buttonPropMap.put("text", ResManager.getLocaleString((String)"\u5f00\u542f\u56fd\u5bb6\u5730\u533a\u6821\u9a8c", (String)"PrivacyStatementTplListPlugin_2", (String)BOS_PORTAL_PLUGIN));
        this.getView().updateControlMetadata(ENABLE_MATCH_COUNTRY, buttonPropMap);
    }

    private void popUpConfirmationDialogs() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5f00\u542f\u540e\uff0c\u4eba\u5458\u56fd\u5bb6\u5730\u533a\u4e3a\u7a7a\u65f6\uff0c\u7b7e\u7f72\u56fd\u5bb6\u5730\u533a\u4e3a\u7a7a\u7684\u9690\u79c1\u58f0\u660e\uff1b\u4eba\u5458\u56fd\u5bb6\u5730\u533a\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u7b7e\u7f72\u76f8\u540c\u56fd\u5bb6\u5730\u533a\u7684\u9690\u79c1\u58f0\u660e\u3002\u786e\u5b9a\u5f00\u542f\u56fd\u5bb6\u5730\u533a\u6821\u9a8c\u5417\uff1f", (String)"PrivacyStatementTplListPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALLBACK, (IFormPlugin)this));
    }

    private void updateSwitchToOpen() {
        HashMap<String, Boolean> switchMap = new HashMap<String, Boolean>();
        switchMap.put("privacy_country_switch", true);
        SystemParamServiceHelper.savePublicParameter(switchMap);
    }

    private void updateSwitchToClose() {
        HashMap<String, Boolean> switchMap = new HashMap<String, Boolean>();
        switchMap.put("privacy_country_switch", false);
        SystemParamServiceHelper.savePublicParameter(switchMap);
    }

    private String getEnableMatchCountrySql() {
        return "select fparam_value from T_BAS_DEFAULT_PARAMS where fparam_key = 'enableMatchCountry'";
    }

    private void insertData() {
        HashMap<String, Boolean> switchMap = new HashMap<String, Boolean>();
        switchMap.put("privacy_country_switch", false);
        SystemParamServiceHelper.savePublicParameter(switchMap);
    }

    public void setFilter(SetFilterEvent e) {
        String entityId = this.getView().getEntityId();
        if ("bos_listf7".equals(entityId)) {
            List filters = e.getQFilters();
            QFilter statusFilter = new QFilter("status", "in", Arrays.asList("B", "C"));
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            filters.add(statusFilter);
            filters.add(enableFilter);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!isAdmin) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4ec5\u7ba1\u7406\u5458\u53ef\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"PrivacyStatementTplListPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (CONFIRM_CALLBACK.equals(callBackId) && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.openSwitch();
        }
    }

    private void openSwitch() {
        this.updateSwitchToOpen();
        this.changeButtonTextToClose();
        this.popUpOpenSuccessToast();
    }

    private void changeButtonTextToClose() {
        HashMap<String, LocaleString> buttonPropMap = new HashMap<String, LocaleString>();
        buttonPropMap.put("text", ResManager.getLocaleString((String)"\u5173\u95ed\u56fd\u5bb6\u5730\u533a\u6821\u9a8c", (String)"PrivacyStatementTplListPlugin_3", (String)BOS_PORTAL_PLUGIN));
        this.getView().updateControlMetadata(ENABLE_MATCH_COUNTRY, buttonPropMap);
    }
}

