/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PrivacyStatementTplPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(PrivacyStatementTplPlugin.class);
    private static final String KEY_MAINBAR = "tbmain";
    private static final String BTN_SAVE = "bar_save";
    private static final String BTN_SUBMIT = "bar_submit";
    private static final String BTN_SAVEANDNEW = "bar_saveandnew";
    private static final String BTN_CLOSE = "bar_close";
    private static final String CONTENT = "content_tag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object obj = this.getModel().getValue(CONTENT);
        if (StringUtils.isNotBlank((Object)obj)) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("htmledit");
            richTextEditor.setText(obj.toString());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_save": 
            case "bar_submit": 
            case "bar_close": 
            case "bar_saveandnew": {
                this.copyRichtextedit2Content();
                break;
            }
        }
    }

    private void copyRichtextedit2Content() {
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("htmledit");
        String content = richTextEditor.getText();
        this.getModel().setValue(CONTENT, (Object)content);
    }

    public void afterDoOperation(AfterDoOperationEventArgs a) {
        super.afterDoOperation(a);
        if (a.getSource() instanceof SaveAndNew && a.getOperationResult().isSuccess()) {
            this.clearRichtextedit();
        }
    }

    private void clearRichtextedit() {
        RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("htmledit");
        richTextEditor.setText("");
    }
}

