/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.form.FieldTip;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.service.impl.SessionComServiceImpl;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.portal.util.PortalLogUtils;
import kd.bos.portal.util.PswStrategyCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.PasswordEncryptUtil;

public class UserPasswordSettingPlugin
extends AbstractFormPlugin {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String BUTTON_PWS = "btn_psw";
    private static final String PROPERTY_USERID = "userId";
    private static final String FIELD_NAME = "name";
    private static final String BOS_USER = "bos_user";
    private static final String FIELD_NEWPWS = "newpsw";
    private static final String FIELD_NEWPWSREPEAD = "newpswrepead";
    private static final String BUTTON_CANCEL = "btncancel";
    private static final String BUTTON_CLOSE = "btn_close";

    public void afterCreateNewData(EventObject evt) {
        String userId = (String)this.getView().getFormShowParameter().getCustomParam(PROPERTY_USERID);
        this.getModel().setValue(FIELD_NAME, (Object)userId);
        this.getView().setVisible(Boolean.FALSE, new String[]{BUTTON_CLOSE});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_PWS, BUTTON_CANCEL, BUTTON_CLOSE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            String key = button.getKey();
            String userId = (String)this.getView().getFormShowParameter().getCustomParam(PROPERTY_USERID);
            if (BUTTON_PWS.equals(key)) {
                this.setPassword(userId);
            }
        }
    }

    private void setPassword(String userId) {
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)BOS_USER);
        StringBuilder sql = new StringBuilder("select fid from t_sec_user_u where fid = ? ");
        final HashMap<String, Boolean> map = new HashMap<String, Boolean>(8);
        map.put("flag", Boolean.FALSE);
        DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{Long.parseLong(userId)}, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    map.put("flag", Boolean.TRUE);
                }
                return map;
            }
        });
        if (!Boolean.parseBoolean(map.get("flag").toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserPasswordSettingPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object newpsw = this.getModel().getValue(FIELD_NEWPWS);
        Object newpswrepead = this.getModel().getValue(FIELD_NEWPWSREPEAD);
        if (StringUtils.isNotBlank((Object)newpsw)) {
            String pattern = "\\s{1,}";
            String strNewPsw = newpsw.toString();
            String[] split = strNewPsw.split(pattern);
            if (split.length > 1 || !strNewPsw.equals(strNewPsw.trim())) {
                this.showFieldTips(FIELD_NEWPWS, ResManager.loadKDString((String)"\u4e0d\u80fd\u542b\u6709\u7a7a\u683c\uff0c\u4e2d\u6587\uff0c\u975e\u6cd5\u7b26\u53f7\u3002", (String)"UserPasswordSettingPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), false);
                this.showFieldTips(FIELD_NEWPWSREPEAD, "", true);
                return;
            }
            if (this.isContainChineseChar(strNewPsw)) {
                this.showFieldTips(FIELD_NEWPWS, ResManager.loadKDString((String)"\u4e0d\u80fd\u542b\u6709\u7a7a\u683c\uff0c\u4e2d\u6587\uff0c\u975e\u6cd5\u7b26\u53f7\u3002", (String)"UserPasswordSettingPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), false);
                this.showFieldTips(FIELD_NEWPWSREPEAD, "", true);
                return;
            }
            if (!StringUtils.isNotBlank((Object)newpswrepead)) {
                this.showFieldTips(FIELD_NEWPWSREPEAD, ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5bc6\u7801\u3002", (String)"UserPasswordSettingPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), false);
                this.showFieldTips(FIELD_NEWPWS, "", true);
                return;
            }
            if (StringUtils.isNotBlank((Object)newpswrepead) && !StringUtils.equals((CharSequence)strNewPsw, (CharSequence)newpswrepead.toString())) {
                this.showFieldTips(FIELD_NEWPWSREPEAD, ResManager.loadKDString((String)"\u4e24\u6b21\u8f93\u5165\u7684\u65b0\u5bc6\u7801\u4e0d\u76f8\u540c\u3002", (String)"UserPasswordSettingPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), false);
                this.showFieldTips(FIELD_NEWPWS, "", true);
                return;
            }
            Map<String, Object> verifyPwdResult = this.verifyPwdByStrategy(user, strNewPsw);
            if (verifyPwdResult != null && !((Boolean)verifyPwdResult.get("success")).booleanValue()) {
                this.getView().showTipNotification(verifyPwdResult.get("msg").toString());
                return;
            }
            String newPswStr = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)strNewPsw, (String)LoginUtils.getCorrectUserIDSalt((String)userId));
            user.set("password", (Object)newPswStr);
            user.set("psweffectivedate", (Object)new Date());
            user.set("islocked", (Object)"0");
            user.set("errcount", (Object)0);
            SaveServiceHelper.save((IDataEntityType)user.getDataEntityType(), (Object[])new Object[]{user});
            this.removePasswordCache(user.getString("username"), user.getString("phone"), user.getString("email"), userId);
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_NEWPWS, FIELD_NEWPWSREPEAD});
            this.getView().setVisible(Boolean.FALSE, new String[]{BUTTON_CANCEL, BUTTON_PWS});
            this.getView().setVisible(Boolean.TRUE, new String[]{BUTTON_CLOSE});
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bc6\u7801\u6210\u529f\u3002", (String)"UserPasswordSettingPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            SessionComServiceImpl service = new SessionComServiceImpl();
            String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            service.removeSessionByUserId(Collections.singletonList(userId), String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u4e8e%1$s\u88ab\u7ba1\u7406\u5458%2$s\u91cd\u7f6e\u5bc6\u7801\uff0c\u5c06\u81ea\u52a8\u9000\u51fa\u767b\u5f55\u3002\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserPasswordSettingPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), date, RequestContext.get().getUserName()), false);
            this.getView().close();
            PortalLogUtils.addLog(BOS_USER, BizAppServiceHelp.getAppIdByFormNum((String)BOS_USER), "setPassword", new MultiLangEnumBridge("\u8bbe\u7f6e\u5bc6\u7801", "UserPasswordSettingPlugin_6", BOS_PORTAL_PLUGIN), new MultiLangEnumBridge("\u8bbe\u7f6e\u5bc6\u7801\u6210\u529f\u3002", "UserPasswordSettingPlugin_5", BOS_PORTAL_PLUGIN), new String[0]);
        } else {
            this.showFieldTips(FIELD_NEWPWS, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5bc6\u7801", (String)"UserPasswordSettingPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), false);
            this.showFieldTips(FIELD_NEWPWSREPEAD, "", true);
        }
    }

    private boolean isContainChineseChar(String value) {
        String pattern = "[^\\x00-\\xff]{1,}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(value);
        return m.find();
    }

    private void showFieldTips(String field, String tips, boolean isHidden) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(field);
        LocaleString ls = new LocaleString(tips);
        fieldTip.setTip(ls.getLocaleValue());
        fieldTip.setSuccess(isHidden);
        this.getView().showFieldTip(fieldTip);
    }

    private Map<String, Object> verifyPwdByStrategy(DynamicObject user, String newpsw) {
        long userId = user.getLong("id");
        return PswStrategyCommonUtil.verifyPwdByStrategy((long)userId, (String)newpsw);
    }

    private void removePasswordCache(String fusername, String fphone, String femail, String userId) {
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        StrategeUtils.clearPasswordWrongTimes((Account)currentCenter, (String)userId, (String)LoginClientEnum.WEB.toString());
        String loginPassword = "s_login_password";
        LocalCacheUtils.remove((String)(fusername + loginPassword));
        LocalCacheUtils.remove((String)(fphone + loginPassword));
        LocalCacheUtils.remove((String)(femail + loginPassword));
    }
}

