/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.data.collect.service.DataCollectionDBService;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.RequestUtils;
import kd.bos.map.MapServiceUtils;
import kd.bos.portal.service.IPrivacyStatementService;
import kd.bos.portal.service.impl.PortalParamServiceImpl;
import kd.bos.portal.service.impl.PrivacyStatementServiceImpl;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class PortalAction {
    private static final Log logger = LogFactory.getLog(PortalAction.class);
    private IPrivacyStatementService privacyStatementService = new PrivacyStatementServiceImpl();

    public void getSystemParam(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String data = "";
        try {
            Object initTasksInfo;
            PortalParamServiceImpl portalParamService = new PortalParamServiceImpl();
            HashMap<String, Object> result = new HashMap<String, Object>(8);
            result.put("portalUserInfo", portalParamService.getPortalUserInfo());
            result.put("shortCutInfo", portalParamService.loadShortcutsBasedata());
            result.put("attachmentSysInfo", AttachmentKit.getAttachmentSysParams());
            result.put("mapServiceConfiguration", MapServiceUtils.getMapServiceConfiguration());
            String type = portalParamService.getSysModeType();
            if (StringUtils.isNotEmpty((String)type)) {
                result.put("modeType", Integer.parseInt(type));
            }
            if (!ObjectUtils.isEmpty((Object)(initTasksInfo = DispatchServiceHelper.invokeBOSService((String)"bos", (String)"SchTaskFormService", (String)"getUnConfirmTasks", (Object[])new Object[0])))) {
                result.put("initTasksInfo", initTasksInfo);
            }
            this.setSsoHeaderPramas(result);
            try {
                Map map = new HashMap();
                map = (Map)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IExtLoginConfigService", (String)"getExtData", (Object[])new Object[]{"BOS_SVC_PORTAL_SYSTEM_PARAM"});
                result.putAll(map);
            }
            catch (KDException e) {
                logger.info("getExtData error", (Object)e);
            }
            if (!ObjectUtils.isEmpty((Object)initTasksInfo)) {
                result.put("initTasksInfo", initTasksInfo);
            }
            result.put("systemEnvInfo", portalParamService.getSystemEnvInfo());
            result.put("systemForm", this.privacyStatementService.getPrivacyStatement());
            boolean isOEM = DevVerifyServiceHelper.isOEMEnv();
            if (isOEM) {
                result.put("productType", "oem");
                result.put("spreadAvailable", this.isOemSpreadJs());
            }
            data = SerializationUtils.toJsonString(result);
        }
        catch (Exception e) {
            logger.info("getSystemParam", (Object)e);
        }
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)data);
    }

    private boolean isOemSpreadJs() {
        try {
            LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"OEM_SPREADJS");
            if (checkResult != null) {
                return checkResult.getHasLicense() == null ? false : checkResult.getHasLicense();
            }
        }
        catch (Exception e) {
            logger.info("set spreadAvailable error", (Object)e);
        }
        return false;
    }

    private void setSsoHeaderPramas(Map<String, Object> result) {
        try {
            String globalSessionId = RequestContext.get().getGlobalSessionId();
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
            Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"ssoParmas"});
            String paramsMapStr = (String)sessionInfo.get("ssoParmas");
            if (StringUtils.isNotEmpty((String)paramsMapStr)) {
                HashMap paramsMap = (HashMap)JSONUtils.cast((String)paramsMapStr, HashMap.class);
                result.put("ssoParmas", paramsMap);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
        }
    }

    public void submitKDData(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String data = "";
        try {
            List<String> groupList;
            Map bodyMap;
            String requestBody = RequestUtils.getRequestBody((HttpServletRequest)servletRequest);
            if (StringUtils.isNotEmpty((String)requestBody) && (bodyMap = (Map)JSONUtils.cast((String)requestBody, HashMap.class)) != null && (groupList = this.getProjectId(bodyMap)) != null && groupList.size() > 0) {
                for (String groupId : groupList) {
                    if (!StringUtils.isNumericString((String)groupId)) continue;
                    String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest);
                    String accountId = RequestUtils.getParamerter((HttpServletRequest)servletRequest, (String)RequestContext.get().getAccountId());
                    Account currentAccount = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
                    DataCollectionDBService.removeByProjectId(currentAccount, Long.parseLong(groupId));
                }
            }
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(8);
        result.put("success", Boolean.TRUE);
        data = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)data);
    }

    private List<String> getProjectId(Map<String, Object> bodyMap) {
        List projectList = null;
        Object idObj = bodyMap.get("data");
        if (idObj instanceof List) {
            projectList = (List)idObj;
        }
        return projectList;
    }
}

