/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageBuilder;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.message.PushMessageType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.AICommandParameter;
import kd.bos.entity.api.AsynMessage;
import kd.bos.entity.api.IAsynMessageHandler;
import kd.bos.form.IFormView;
import kd.bos.form.aicommand.AICommandFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.pushservice.WebSocketIdReader;

public class AICommandMessageHandler
implements IAsynMessageHandler {
    private static final Log log = LogFactory.getLog(AICommandMessageHandler.class);

    public List<PushMessage> handle(AsynMessage message) {
        ArrayList<PushMessage> msgList = new ArrayList<PushMessage>();
        String body = message.getBody();
        Map messageBody = (Map)SerializationUtils.fromJsonString((String)body, Map.class);
        if (messageBody.containsKey("actionName") && messageBody.containsKey("parameter")) {
            String actionName = (String)messageBody.get("actionName");
            AICommandParameter parameter = new AICommandParameter();
            parameter.setPara((Map)messageBody.get("parameter"));
            msgList.addAll(this.doAICommand(actionName, parameter));
        }
        return msgList;
    }

    private List<PushMessage> doAICommand(String actionName, AICommandParameter parameter) {
        ArrayList<PushMessage> msgList = new ArrayList<PushMessage>();
        RequestContext rc = RequestContext.get();
        List rootPageIds = WebSocketIdReader.getWebSocketIds((String)rc.getAccountId(), (String)rc.getGlobalSessionId());
        log.info("\u5bfb\u627e\u5230\u5f53\u524d\u4f1a\u8bdd\u4e00\u5171\u6253\u5f00\u4e86\u8ddf\u9875\u9762\u5217\u8868\u5982\u4e0b :" + SerializationUtils.toJsonString((Object)rootPageIds));
        for (String rootPageId : rootPageIds) {
            try {
                IFormView view = SessionManager.getCurrent().getView(rootPageId);
                if (view == null) {
                    log.info("pageId :" + rootPageId + " websocket\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00");
                    continue;
                }
                AICommandFactory.createCmdInvoker((String)actionName, (AICommandParameter)parameter, (IFormView)view).invoke();
                msgList.add(PushMessageBuilder.create().body((Object)SerializationUtils.toJsonString((Object)view.getActionResult())).to(rootPageId).range(PushMessageRange.RootPage).id(rootPageId).type(PushMessageType.FormCommand).build());
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u9875\u9762\uff1a" + rootPageId + "\u7684AI\u547d\u4ee4\u65f6\u51fa\u73b0\u5f02\u5e38\uff01\uff01\uff01", (Throwable)e);
            }
        }
        return msgList;
    }
}

