/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.ai;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.devportal.AppElement;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.aicommand.DefaultAICommand;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.OperatePageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class OpenMenuAICommand
extends DefaultAICommand {
    private static final Log log = LogFactory.getLog(OpenMenuAICommand.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String BOSFORMMETA = "bos_formmeta";
    private static final String SELECTKEYS = "number, inheritpath";
    private static final String KEYNUMBER = "number";
    private static final String APPNAME = "appname";
    private static final String APPMAINNUMBER = "appmainnumber";
    private static final String BIZAPPID = "bizappid";

    protected String findMenuPageId(IFormView targetView, String menuId) {
        return menuId + targetView.getPageId();
    }

    protected IFormView getMenuView(IFormView targetView, String menuId) {
        return targetView.getView(this.findMenuPageId(targetView, menuId));
    }

    private String getNoappsetMsg() {
        return ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5e94\u7528\u9996\u9875\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"OpenMenuAICommand_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getNoexistMsg() {
        return ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"OpenMenuAICommand_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getParamserrMsg() {
        return ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u9519\u8bef\uff0c\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u9875\u9762\u3002", (String)"OpenMenuAICommand_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    protected void execute() {
        if (this.params.getParameter("menuId") != null) {
            String menuId = (String)this.params.getParameter("menuId");
            this.openMenuByMenuId(menuId);
        } else if (this.params.getParameter("uiname") != null) {
            String uiName = (String)this.params.getParameter("uiname");
            this.openMenuByUIName(uiName);
        } else if (this.params.getParameter("formId") != null && this.params.getParameter("pkId") != null) {
            String formId = (String)this.params.getParameter("formId");
            Object pkId = this.params.getParameter("pkId");
            this.openBill(formId, pkId);
        } else if (this.params.getParameter("formId") != null) {
            String formId = (String)this.params.getParameter("formId");
            this.openMenuByFormId(formId);
        } else if (this.params.getParameter("bizappId") != null) {
            String appId = (String)this.params.getParameter("bizappId");
            this.openApp(appId);
        } else {
            log.error("\u53c2\u6570\uff1a\u65e0\u6cd5\u5339\u914d\u6253\u5f00\u884c\u4e3a--" + SerializationUtils.toJsonString((Object)this.getParams()));
        }
    }

    protected void openApp(String appId) {
        String appNumber = AppMetadataCache.getAppNumberById((String)appId);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        if (appInfo == null) {
            throw new KDException(String.format(ResManager.loadKDString((String)"appId: %s\uff0c\u5bf9\u5e94appInfo\u4e3a\u7a7a", (String)"OpenMenuAICommand_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appId));
        }
        String mainPageId = appInfo.getHomeId();
        String name = appInfo.getName().getLocaleValue();
        if (mainPageId == null || mainPageId.trim().length() == 0) {
            this.targetView.showTipNotification(this.getNoappsetMsg(), Integer.valueOf(3000));
            return;
        }
        DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)BOSFORMMETA, (String)SELECTKEYS);
        if (pageObject == null) {
            this.targetView.showTipNotification(this.getNoexistMsg(), Integer.valueOf(3000));
            return;
        }
        String mainPageNumber = pageObject.getString(KEYNUMBER);
        Map para = this.params.getPara();
        para.put("view", this.targetView);
        para.put(APPNAME, name);
        para.put(APPMAINNUMBER, mainPageNumber);
        OpenPageUtils.openAppTab(appId, null, this.params.getPara(), this.targetView);
    }

    private void openBill(String formId, Object pkId) {
        List<Map<String, Object>> formInfos = null;
        formInfos = OperatePageUtils.getFormInfoByFormId(formId, false);
        if (!formInfos.isEmpty()) {
            for (int i = 0; i < formInfos.size(); ++i) {
                Map<String, Object> formInfo = formInfos.get(i);
                String appId = (String)formInfo.get(BIZAPPID);
                HashMap<String, Object> tmpParams = new HashMap<String, Object>();
                tmpParams.putAll(this.params.getPara());
                tmpParams.put("view", this.targetView);
                AppMetadata appMetadata = BizAppServiceHelp.getAppMetaByID((String)appId);
                AppElement appElement = appMetadata.getAppElement();
                String mainPageId = appElement.getMainFormID();
                if (mainPageId == null || mainPageId.trim().length() == 0) {
                    this.targetView.showTipNotification(this.getNoappsetMsg(), Integer.valueOf(3000));
                    return;
                }
                DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)BOSFORMMETA, (String)SELECTKEYS);
                if (pageObject == null) {
                    this.targetView.showTipNotification(this.getNoexistMsg(), Integer.valueOf(3000));
                    return;
                }
                String mainPageNumber = pageObject.getString(KEYNUMBER);
                tmpParams.put(APPNAME, appMetadata.getName().getLocaleValue());
                tmpParams.put(APPMAINNUMBER, mainPageNumber);
                tmpParams.put("pkId", pkId.toString());
                OpenPageUtils.openAppTab(appId, null, tmpParams, this.targetView);
                tmpParams.remove("view");
                IFormView formIdPage = this.targetView.getView(this.findMenuPageId(this.targetView, formId));
                if (formIdPage != null) {
                    OperatePageUtils.reloadData(this.targetView, formIdPage, this.params);
                    continue;
                }
                OperatePageUtils.openBill(appId, formId, tmpParams, this.targetView);
            }
        } else {
            this.targetView.showErrorNotification(this.getParamserrMsg());
        }
    }

    private void openMenuByMenuId(String menuId) {
        String bizappId = (String)this.params.getParameter("bizappId");
        if (StringUtils.isBlank((CharSequence)menuId) || StringUtils.isBlank((CharSequence)bizappId)) {
            this.targetView.showErrorNotification(ResManager.loadKDString((String)"AI\u547d\u4ee4\u201c\u6253\u5f00\u83dc\u5355\u201d\uff0c\u83b7\u53d6\u4e0d\u5230menuId\u6216bizAppId\uff0c\u65e0\u6cd5\u6253\u5f00\u5bf9\u5e94\u83dc\u5355\u3002", (String)"OpenMenuAICommand_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            IFormView menuPage = this.targetView.getView(this.findMenuPageId(this.targetView, menuId));
            log.info(String.format("\u51c6\u5907\u6253\u5f00\u83dc\u5355-----menuId:%s  \u5e94\u7528Id:%s  \u53c2\u6570\uff1a%s", menuId, bizappId, this.params.toString()));
            OpenPageUtils.openMenu(this.targetView, menuId, bizappId, this.params.getPara());
            if (menuPage != null) {
                log.info(String.format("\u51c6\u5907\u91cd\u65b0\u52a0\u8f7d\u83dc\u5355-----menuId:%s  \u5e94\u7528Id:%s  \u53c2\u6570\uff1a%s", menuId, bizappId, this.params.toString()));
                OperatePageUtils.reloadData(this.targetView, menuPage, this.params);
            }
        }
    }

    private void openMenuByFormId(String formId) {
        List<Map<String, Object>> formInfos = null;
        formInfos = OperatePageUtils.getFormInfoByFormId(formId);
        if (!formInfos.isEmpty()) {
            for (int i = 0; i < formInfos.size(); ++i) {
                Map<String, Object> formInfo = formInfos.get(i);
                String appId = (String)formInfo.get(BIZAPPID);
                String menuId = (String)formInfo.get("menuid");
                if (StringUtils.isBlank((CharSequence)menuId)) {
                    HashMap<String, Object> tmpParams = new HashMap<String, Object>();
                    tmpParams.putAll(this.params.getPara());
                    tmpParams.put("view", this.targetView);
                    AppMetadata appMetadata = BizAppServiceHelp.getAppMetaByID((String)appId);
                    AppElement appElement = appMetadata.getAppElement();
                    String mainPageId = appElement.getMainFormID();
                    if (mainPageId == null || mainPageId.trim().length() == 0) {
                        this.targetView.showTipNotification(this.getNoappsetMsg(), Integer.valueOf(3000));
                        return;
                    }
                    DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)BOSFORMMETA, (String)SELECTKEYS);
                    if (pageObject == null) {
                        this.targetView.showTipNotification(this.getNoexistMsg(), Integer.valueOf(3000));
                        return;
                    }
                    String mainPageNumber = pageObject.getString(KEYNUMBER);
                    tmpParams.put(APPNAME, appMetadata.getName().getLocaleValue());
                    tmpParams.put(APPMAINNUMBER, mainPageNumber);
                    OpenPageUtils.openAppTab(appId, null, tmpParams, this.targetView);
                    tmpParams.remove("view");
                    IFormView formIdPage = this.targetView.getView(this.findMenuPageId(this.targetView, formId));
                    if (formIdPage != null) {
                        OperatePageUtils.reloadData(this.targetView, formIdPage, this.params);
                        continue;
                    }
                    OperatePageUtils.openBill(appId, formId, tmpParams, this.targetView);
                    continue;
                }
                IFormView menuPage = this.targetView.getView(this.findMenuPageId(this.targetView, menuId));
                if (menuPage != null) {
                    OpenPageUtils.openMenu(this.targetView, menuId, appId, this.params.getPara());
                    OperatePageUtils.reloadData(this.targetView, menuPage, this.params);
                    continue;
                }
                this.params.setParameter("menuId", (Object)menuId);
                OpenPageUtils.openMenu(this.targetView, menuId, appId, this.params.getPara());
            }
        } else {
            this.targetView.showErrorNotification(this.getParamserrMsg());
        }
    }

    private void openMenuByUIName(String uiName) {
        List<Map<String, Object>> formInfos = null;
        formInfos = OperatePageUtils.getFormInfoByName(uiName);
        if (!formInfos.isEmpty()) {
            for (int i = 0; i < formInfos.size(); ++i) {
                IFormView menuPage;
                Map<String, Object> formInfo = formInfos.get(i);
                String appId = (String)formInfo.get(BIZAPPID);
                String menuId = (String)formInfo.get("menuid");
                if (StringUtils.isBlank((CharSequence)menuId)) {
                    this.targetView.showErrorNotification(ResManager.loadKDString((String)" \u8be5\u8868\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355\u9879", (String)"OpenMenuAICommand_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                }
                if ((menuPage = this.targetView.getView(this.findMenuPageId(this.targetView, menuId))) != null) {
                    OpenPageUtils.openMenu(this.targetView, menuId, appId, this.params.getPara());
                    OperatePageUtils.reloadData(this.targetView, menuPage, this.params);
                    continue;
                }
                this.params.setParameter("menuId", (Object)menuId);
                OpenPageUtils.openMenu(this.targetView, menuId, appId, this.params.getPara());
            }
        } else {
            this.targetView.showErrorNotification(this.getParamserrMsg());
        }
    }
}

