/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.job;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.session.service.DBUtils;
import org.apache.commons.lang3.StringUtils;

public class SatisfactionCheckJob
extends AbstractTask {
    private static final String HAS_DONE_SATISFACTION = "hasDoneSatisfaction";
    private static Log logger = LogFactory.getLog(SatisfactionCheckJob.class);
    private String value;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            if (this.hasDoExecute()) {
                return;
            }
            boolean pubTenant = this.getBooleanPubTenantType();
            boolean pluginDo = this.getPluginTestCant(map);
            if (pubTenant || pluginDo) {
                Map params = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_publicparametertpl");
                String showcontent = (String)params.get("showcontent");
                if (StringUtils.isNotBlank((CharSequence)showcontent)) {
                    String[] split = showcontent.split(",");
                    TreeSet<String> contentSet = new TreeSet<String>(Arrays.asList(split));
                    contentSet.add("3");
                    StringBuilder sb = new StringBuilder();
                    for (String s : contentSet) {
                        sb.append(s).append(",");
                    }
                    params.put("showcontent", sb.toString());
                } else {
                    params.put("showcontent", ",3");
                }
                SystemParamServiceHelper.savePublicParameter((Map)params);
            }
            this.saveDoneDataToDb();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private boolean getPluginTestCant(Map<String, Object> map) {
        String pluginDo = (String)map.get("test_plugin_do");
        boolean aBoolean = Boolean.parseBoolean(pluginDo);
        if (aBoolean) {
            this.value = "test";
        }
        return aBoolean;
    }

    private boolean getBooleanPubTenantType() {
        if (Boolean.parseBoolean(LicenseServiceHelper.getPubTenantType())) {
            this.value = "pub";
            boolean initailVersion = InitailVersionServiceHelper.isInitailVersion((int)6);
            if (initailVersion) {
                this.value = "pub_new";
            }
            return initailVersion;
        }
        return false;
    }

    private boolean hasDoExecute() {
        try {
            String hasDoneSatisfaction = SatisfactionCheckJob.getDoneDataFromDb(this.getEncodeKey());
            return StringUtils.isNotBlank((CharSequence)hasDoneSatisfaction);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    private String getEncodeKey() {
        return Base64.getEncoder().encodeToString(HAS_DONE_SATISFACTION.getBytes(StandardCharsets.UTF_8));
    }

    private static String getDoneDataFromDb(String key) {
        String sql = "select fid, fparam_key,fparam_value from T_BAS_DEFAULT_PARAMS where fparam_key = ?";
        String query = (String)DBUtils.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{key}, res -> {
            String hasDone = "";
            while (res.next()) {
                if (!StringUtils.isNotEmpty((CharSequence)res.getString(3))) continue;
                hasDone = res.getString(3);
            }
            return hasDone;
        });
        return query;
    }

    private boolean saveDoneDataToDb() {
        String sql = "insert into T_BAS_DEFAULT_PARAMS (fid, fparam_key,fparam_value,fparam_type) values(?,?,?,?)";
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        return DBUtils.execute((Account)account, (DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{ID.genLongId(), this.getEncodeKey(), StringUtils.isBlank((CharSequence)this.value) ? "1" : this.value, "1"});
    }
}

