/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.model;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import kd.bos.base.parameter.ParameterService;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.portal.model.MultiLangEnumBridge;
import kd.bos.portal.util.LogoUtils;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public enum BrandUpEnum {
    EIP("iscb-iscx-dbc-iscr", "/images/pc/other/logo_qklpt_378_72.png", "/images/pc/other/logo_jcpt_en_442_72.png", "", new MultiLangEnumBridge("\u91d1\u8776\u4e91\u82cd\u7a79\u96c6\u6210\u5e73\u53f0", "BrandUpEnum_0", "bos-portal-plugin")),
    WFS("wf-bpm-bec", "/images/pc/other/logo_lcpt_378_72.png", "/images/pc/other/logo_lcpt_en_408_72.png", "", new MultiLangEnumBridge("\u91d1\u8776\u4e91\u82cd\u7a79\u6d41\u7a0b\u5e73\u53f0", "BrandUpEnum_1", "bos-portal-plugin")),
    BSC("bcc-bea", "/images/pc/other/logo_qklpt_350_72.png", "/images/pc/other/logo_qklpt_en_454_72.png", "", new MultiLangEnumBridge("\u91d1\u8776\u4e91\u82cd\u7a79\u533a\u5757\u94fe\u5e73\u53f0", "BrandUpEnum_2", "bos-portal-plugin"));

    private String apps;
    private String imgUrl;
    private String enImgurl;
    private String twImgurl;
    private MultiLangEnumBridge bridge;

    public String getTwImgurl() {
        return this.twImgurl;
    }

    public String getEnImgurl() {
        String logoUrl = this.getDefaultLogo(Lang.en_US);
        return logoUrl == null ? this.enImgurl : logoUrl;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public String getApps() {
        return this.apps;
    }

    public String getImgUrl() {
        String logoUrl = this.getDefaultLogo(Lang.zh_CN);
        return logoUrl == null ? this.imgUrl : logoUrl;
    }

    private String getDefaultLogo(Lang lang) {
        String logoUrl;
        if (BrandUpEnum.isUseTenantLoginConfig() && StringUtils.isNotEmpty((String)(logoUrl = LogoUtils.getLoginConfigLogo()))) {
            return UrlService.getImageFullUrl((String)logoUrl);
        }
        boolean enableNewPortal = ParameterService.isSupportNewPortal();
        if (enableNewPortal) {
            return LogoUtils.getDefaultLogo();
        }
        return null;
    }

    private BrandUpEnum(String apps, String imgUrl, String enImgurl, String twImgurl, MultiLangEnumBridge bridge) {
        this.apps = apps;
        this.imgUrl = imgUrl;
        this.enImgurl = enImgurl;
        this.twImgurl = twImgurl;
        this.bridge = bridge;
    }

    public static List<String> getAppNumbers(String appNumber) {
        if (BrandUpEnum.getIsDisableBrandUp()) {
            return null;
        }
        if (StringUtils.isEmpty((String)appNumber)) {
            return null;
        }
        LinkedList<String> appNumberS = null;
        for (BrandUpEnum brandUpEnum : BrandUpEnum.values()) {
            if (!BrandUpEnum.isExist(brandUpEnum, appNumber)) continue;
            appNumberS = new LinkedList<String>(Arrays.asList(brandUpEnum.getApps().split("-")));
        }
        return appNumberS;
    }

    public static List<String> getAllAppNumbers() {
        return BrandUpEnum.getAllAppNumbers(true);
    }

    public static List<String> getAllAppNumbers(boolean controlByMcParams) {
        if (controlByMcParams && BrandUpEnum.getIsDisableBrandUp()) {
            return null;
        }
        LinkedList<String> appNumberS = new LinkedList<String>();
        for (BrandUpEnum brandUpEnum : BrandUpEnum.values()) {
            appNumberS.addAll(new LinkedList<String>(Arrays.asList(brandUpEnum.getApps().split("-"))));
        }
        return appNumberS;
    }

    private static boolean getIsDisableBrandUp() {
        String isDisableBrandUp = SystemPropertyUtils.getProptyByTenant((String)"cosmic_brandupgrade_restore", (String)RequestContext.get().getTenantId());
        return isDisableBrandUp != null && Boolean.parseBoolean(isDisableBrandUp);
    }

    public static String getImgUrl(String appNumber) {
        if (StringUtils.isEmpty((String)appNumber)) {
            return null;
        }
        String imgUrl = null;
        block10: for (BrandUpEnum brandUpEnum : BrandUpEnum.values()) {
            if (!BrandUpEnum.isExist(brandUpEnum, appNumber)) continue;
            String lang = Lang.get().toString();
            if (StringUtils.isEmpty((String)lang)) {
                return brandUpEnum.getImgUrl();
            }
            switch (lang) {
                case "zh_CN": {
                    imgUrl = brandUpEnum.getImgUrl();
                    continue block10;
                }
                case "zh_TW": {
                    imgUrl = brandUpEnum.getImgUrl();
                    continue block10;
                }
                case "en_US": {
                    imgUrl = brandUpEnum.getEnImgurl();
                    continue block10;
                }
                default: {
                    imgUrl = brandUpEnum.getEnImgurl();
                }
            }
        }
        return imgUrl;
    }

    public static String getLoginSourceTypeValue(String appNumber) {
        for (BrandUpEnum brandUpEnum : BrandUpEnum.values()) {
            if (!BrandUpEnum.isExist(brandUpEnum, appNumber)) continue;
            return brandUpEnum.getLoginSourceTypeValue();
        }
        return null;
    }

    public static boolean isExist(BrandUpEnum brandUpEnum, String appNumber) {
        for (String app : brandUpEnum.getApps().split("-")) {
            if (!app.equals(appNumber)) continue;
            return true;
        }
        return false;
    }

    public String getLoginSourceTypeValue() {
        return this.bridge.loadKDString();
    }

    private static boolean isUseTenantLoginConfig() {
        String tenantId = RequestContext.get() == null ? null : RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)"tenant.login.config.share_to_cosmic", (String)tenantId);
        return Boolean.parseBoolean(value);
    }

    private static class Constants {
        public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

        private Constants() {
        }
    }
}

