/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Image;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class AboutPlugin
extends AbstractFormPlugin {
    private static final String COSMIC_BOS = "cosmic_bos";
    private static final String COSMIC_BIZ = "cosmic_biz";
    private static final String BOSFLEXPANELAP_1 = "bosflexpanelap1";
    private static final String BOSFLEXPANELAP_2 = "bosflexpanelap2";
    private static final String BOSFLEXPANELAP_3 = "bosflexpanelap3";
    private static final String BOSFLEXPANELAP_4 = "bosflexpanelap4";
    private static final String BIZFLEXPANELAP_1 = "bizflexpanelap1";
    private static final String BIZFLEXPANELAP_2 = "bizflexpanelap2";
    private static final String BIZFLEXPANELAP_3 = "bizflexpanelap3";
    private static final String BIZFLEXPANELAP_4 = "bizflexpanelap4";
    private static Log logger = LogFactory.getLog(AboutPlugin.class);
    private static final String SN = "sn";
    private static final String VALIDDATE = "validdate";
    private static final String COPYRIGHT = "copyright";
    private static final String EXPDATE = "expdate";
    private static final String LICVERSION = "licversion";
    private static final String VERSION = "version";
    private static final String BOS_VERSION_DATE = "bosversiondate";
    private static final String BIZ_VERSION = "bizversion";
    private static final String BIZ_VERSION_DATE = "bizversiondate";
    private static final String BIZ_LICVERSION = "bizlicversion";
    private static final String BIZ_EXPDATE = "bizexpdate";

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void afterBindData(EventObject evt) {
        Lang lang = RequestContext.get().getLang();
        Image logo = (Image)this.getControl("imageap");
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            logo.setUrl("/images/pc/other/logo_ccs_abbr_278_72.png");
        } else {
            logo.setUrl("/images/pc/other/logo_ccs_cn_242_72.png");
        }
    }

    private void initData() {
        IDataModel model = this.getModel();
        model.setValue(SN, (Object)"");
        model.setValue(VALIDDATE, (Object)"");
        model.setValue(COPYRIGHT, (Object)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u56fd\u9645\u8f6f\u4ef6\u96c6\u56e2\u6709\u9650\u516c\u53f8 \u7248\u6743\u6240\u6709\u00a91993-%s", (String)"AboutPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]), Calendar.getInstance().get(1)));
        this.setVersionInfo();
    }

    private void setVersionInfo() {
        List<Version> versions = this.getVersionInfos();
        IDataModel model = this.getModel();
        this.getView().setVisible(Boolean.FALSE, new String[]{BOSFLEXPANELAP_1, BOSFLEXPANELAP_2, BOSFLEXPANELAP_3, BOSFLEXPANELAP_4, BIZFLEXPANELAP_1, BIZFLEXPANELAP_2, BIZFLEXPANELAP_3, BIZFLEXPANELAP_4});
        ArrayList<String> products = new ArrayList<String>(versions.size());
        for (Version version : versions) {
            if (COSMIC_BOS.equals(version.getProductNumber())) {
                model.setValue(VERSION, (Object)("COSMICV" + version.getVersion()));
                model.setValue(BOS_VERSION_DATE, (Object)version.getUpgradeTime());
                this.getView().setVisible(Boolean.TRUE, new String[]{BOSFLEXPANELAP_1, BOSFLEXPANELAP_2});
                products.add(COSMIC_BOS);
                continue;
            }
            if (!COSMIC_BIZ.equals(version.getProductNumber())) continue;
            model.setValue(BIZ_VERSION, (Object)("CONSTELLATIONV" + version.getVersion()));
            model.setValue(BIZ_VERSION_DATE, (Object)version.getUpgradeTime());
            this.getView().setVisible(Boolean.TRUE, new String[]{BIZFLEXPANELAP_1, BIZFLEXPANELAP_2});
            products.add(COSMIC_BIZ);
        }
        Map prodMap = LicenseServiceHelper.getProductInfo();
        if (prodMap != null) {
            String licenseVersion = LicenseServiceHelper.getProductVersion();
            if (StringUtils.isNotBlank((CharSequence)licenseVersion)) {
                model.setValue(LICVERSION, (Object)("V" + licenseVersion));
                model.setValue(BIZ_LICVERSION, (Object)("V" + licenseVersion));
                if (products.contains(COSMIC_BOS)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BOSFLEXPANELAP_3, BOSFLEXPANELAP_4});
                }
                if (products.contains(COSMIC_BIZ)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{BIZFLEXPANELAP_3, BIZFLEXPANELAP_4});
                }
            }
            model.setValue(EXPDATE, prodMap.get(EXPDATE));
            model.setValue(BIZ_EXPDATE, prodMap.get(EXPDATE));
        }
    }

    private List<Version> getVersionInfos() {
        String sql = "select fid, fproductnumber, fversion, fupgradetime from t_bas_industry_version where fproductnumber in (?, ?);";
        Object[] params = new Object[]{COSMIC_BOS, COSMIC_BIZ};
        List versions = Collections.emptyList();
        try {
            versions = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, resultSet -> {
                ArrayList<Version> result = new ArrayList<Version>(resultSet.getRow());
                while (resultSet.next()) {
                    Version version = new Version();
                    version.setId(resultSet.getString("fid"));
                    version.setVersion(resultSet.getString("fversion"));
                    version.setProductNumber(resultSet.getString("fproductnumber"));
                    version.setUpgradeTime(resultSet.getDate("fupgradetime"));
                    result.add(version);
                }
                return result;
            });
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u53d1\u5e03\u7248\u672c\u4fe1\u606f\u5f02\u5e38...", (Object)e);
        }
        return versions;
    }

    static class Version {
        private String id;
        private String ownVersion;
        private String productNumber;
        private Date upgradeTime;

        Version() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getVersion() {
            return this.ownVersion;
        }

        public void setVersion(String ownVersion) {
            this.ownVersion = ownVersion;
        }

        String getProductNumber() {
            return this.productNumber;
        }

        void setProductNumber(String productNumber) {
            this.productNumber = productNumber;
        }

        Date getUpgradeTime() {
            return this.upgradeTime;
        }

        void setUpgradeTime(Date upgradeTime) {
            this.upgradeTime = upgradeTime;
        }
    }
}

