/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.EventObject;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;

public class BillSelectPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    public void initialize() {
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String entity = (String)param.getCustomParam("entity");
        if (StringUtils.isEmpty((String)entity)) {
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        String billSelectPageId = UUID.randomUUID().toString();
        this.getPageCache().put("billselectpageid", billSelectPageId);
        parameter.setPageId(billSelectPageId);
        parameter.setFormId("bos_list");
        parameter.setBillFormId(entity);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("billlist");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void itemClick(ItemClickEvent e) {
        Control control = (Control)e.getSource();
        if (control.getKey().equals("toolbarap")) {
            switch (e.getItemKey()) {
                case "confirm": {
                    this.confirm();
                    break;
                }
            }
        }
    }

    private void confirm() {
        String billSelectPageId = this.getPageCache().get("billselectpageid");
        IFormView billSelectPage = this.getView().getView(billSelectPageId);
        BillList list = (BillList)billSelectPage.getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        if (rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"BillSelectPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
        } else {
            ListSelectedRow row = rows.get(0);
            String billId = String.valueOf(row.getPrimaryKeyValue());
            this.getView().returnDataToParent((Object)billId);
            this.getView().close();
        }
    }
}

