/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.data.collect.model.DataCollect;
import kd.bos.data.collect.service.DataCollectServiceHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeMenuNode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeMenu;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.control.events.TabOperationEvent;
import kd.bos.form.control.events.TabOperationListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.plugin.MainPagePlugin;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.common.BizAppHomeAbstract;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.util.DateUtils;
import kd.bos.portal.util.DevportalUtil;
import kd.bos.portal.util.ImageUtil;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.portal.util.PortalMessageUtils;
import kd.bos.portal.util.ShortCutUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.license.LicenseGrayServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.sysint.cache.PortalAppFeaturesCache;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.DisCardUtil;
import org.apache.commons.lang.reflect.MethodUtils;

public class BizAppHomePlugin
extends BizAppHomeAbstract
implements TabSelectListener,
TreeMenuClickListener,
TabCloseListener,
TabOperationListener {
    public static final String SUBMAINTAB = "_submaintab_";
    public static final String VIEWFEATURE = "viewfeature";
    public static final String APPFEATUREFLEXPANEL = "appfeatureflexpanel";
    public static final String SHOW_TEAM_WORK = "showTeamWork";
    public static final String APPID = "appid";
    public static final String TITLE = "title";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String PICTUREFIELD = "picturefield";
    public static final String PAGE_ID = "pageId";
    public static final String QING = "&qing";
    public static final String QING_MENU_ID = "qingMenuId";
    public static final String QING_MENU_NAME = "qingMenuName";
    public static final String IMAGE_URL = "imageUrl";
    public static final String PARENT_ID = "parentId";
    public static final String SHOW_INSIGHT = "showInsight";
    public static final String IS_ENABLE_AI_INSIGHT = "is_enable_ai_insight";
    public static final String CONTROL_KEY = "controlKey";
    public static final String APPMIANTAB = "appmiantab";
    public static final String BILL_FORM_ID = "billFormId";
    public static final String BILL_NAME = "billName";
    public static final String USERNAME = "username";
    public static final String TYPE_NAME = "typeName";
    public static final String TO_SHARE_FORM = "toShareForm";
    public static final String SHARE_FORM_ID = "shareFormId";
    public static final String SHARE_PK_ID = "sharePkId";
    public static final String SHARE_BILL_NAME = "shareBillName";
    public static final String FLOATMENU = "floatmenu";
    private static final String CONS_NAVIGATIONBAR = "navigationbar";
    private PortalMenuService menuService;

    public void initialize() {
        this.menuService = new PortalMenuService(this.getPageCache());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeMenu navigationBar = (TreeMenu)this.getView().getControl(CONS_NAVIGATIONBAR);
        if (navigationBar != null) {
            navigationBar.addTreeMenuClickListener((TreeMenuClickListener)this);
        }
        this.addClickListeners(new String[]{CONS_NAVIGATIONBAR});
        Tab apptabs = (Tab)this.getView().getControl(SUBMAINTAB);
        if (apptabs != null) {
            apptabs.addTabSelectListener((TabSelectListener)this);
            apptabs.addClickListener((ClickListener)this);
            apptabs.addTabCloseListener((TabCloseListener)this);
            apptabs.addTabReOpenListener((TabOperationListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{VIEWFEATURE});
        this.addClickListeners(new String[]{"closeAppFeature"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().addClientCallBack("handleAppFeature");
        this.getView().setVisible(Boolean.FALSE, new String[]{APPFEATUREFLEXPANEL});
        JSONArray menus = this.getMenuArray();
        this.renderNavigation(menus, null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long userId = RequestContext.get().getCurrUserId();
        String appNum = this.getView().getFormShowParameter().getAppId();
        List<String> markedMenuList = this.loadUserMarkedMenus(userId, appNum);
        TreeMenu treeMenu = (TreeMenu)this.getControl(CONS_NAVIGATIONBAR);
        if (treeMenu != null) {
            treeMenu.setTreeMenusMarked(markedMenuList);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        Object isSearch = BaseAppParameterServiceHelper.getParameterFromCache((String)"knowledge_search");
        if (isSearch == null || Boolean.parseBoolean(isSearch.toString())) {
            map.put("showHelp", Boolean.TRUE);
        }
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        Map params = ParametersUtils.getCommonParameters((Account)currentCenter);
        map.put(SHOW_TEAM_WORK, false);
        map.put(SHOW_INSIGHT, false);
        if (params != null) {
            boolean oemEnv;
            if (params.get("is_enable_team_work") instanceof Boolean && ((Boolean)params.get("is_enable_team_work")).booleanValue()) {
                map.put(SHOW_TEAM_WORK, true);
            }
            if (!(oemEnv = DevVerifyServiceHelper.isOEMEnv()) && (params.get(IS_ENABLE_AI_INSIGHT) == null || params.get(IS_ENABLE_AI_INSIGHT) instanceof Boolean && ((Boolean)params.get(IS_ENABLE_AI_INSIGHT)).booleanValue())) {
                map.put(SHOW_INSIGHT, true);
            }
        }
        try {
            if (null != this.getView().getFormShowParameter() && kd.bos.util.StringUtils.isNotEmpty((String)this.getView().getFormShowParameter().getAppId()) && "ssc".equals(this.getView().getFormShowParameter().getAppId())) {
                map.put(SHOW_INSIGHT, false);
            }
        }
        catch (Exception e1) {
            logger.info("getAppId error", (Object)e1);
        }
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("home_page".equals(parentFormId)) {
            map.put("hideNav", Boolean.TRUE);
        }
        this.getView().updateControlMetadata(SUBMAINTAB, map);
        this.updateFloatMenuUi();
    }

    private void updateFloatMenuUi() {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("home_page".equals(parentFormId)) {
            HashMap<String, String> floatMap = new HashMap<String, String>();
            floatMap.put("top", "58");
            this.getView().updateControlMetadata(FLOATMENU, floatMap);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("helpInfo_article".equals(e.getName())) {
            this.getHelpInfo("article");
        } else if ("helpInfo_course".equals(e.getName())) {
            this.getHelpInfo("course");
        } else if ("handleAppFeature".equals(e.getName())) {
            this.handleAppFeature();
        }
    }

    private void handleAppFeature() {
        try {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String appId = (String)showParameter.getCustomParam(APPID);
            String formId = showParameter.getFormId();
            if (StringUtils.isEmpty((CharSequence)appId)) {
                String entityTypeId = showParameter.getFormConfig().getEntityTypeId();
                appId = BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId);
            }
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            String appNumber = app.getNumber();
            PortalAppFeaturesCache portalAppFeaturesCache = new PortalAppFeaturesCache();
            long userId = RequestContext.get().getCurrUserId();
            boolean flag = portalAppFeaturesCache.getUserAppFeatureFlag(userId, appNumber);
            if (flag) {
                Map<String, String> appFeature = portalAppFeaturesCache.getAppFeatrue(appNumber);
                String featureId = appFeature.get("id");
                String url = appFeature.get("url");
                String title = appFeature.get(TITLE);
                Label label = (Label)this.getView().getControl("featuretitle");
                label.setText(title);
                this.getPageCache().put(this.getView().getPageId() + VIEWFEATURE, url);
                this.getView().setVisible(Boolean.TRUE, new String[]{APPFEATUREFLEXPANEL});
                HashMap<String, String> cusMap = new HashMap<String, String>();
                cusMap.put("NewFeatures_id", featureId);
                ThreadPools.executeOnce((String)"newFeaturesDataCollect", () -> this.newFeaturesDataCollect("NewFeatures_view", appNumber, formId, cusMap));
            }
        }
        catch (Exception e) {
            logger.info("handleAppFeature error", (Object)e);
        }
    }

    private void newFeaturesDataCollect(String eventName, String appId, String formId, Map<String, String> cusMap) {
        DataCollect data = new DataCollect();
        data.setAppId(appId);
        data.setFormId(formId);
        data.setProjectId("cosmic");
        data.setStoreId("server_beacon");
        data.setEventName(eventName);
        data.setCreatTime(new Date());
        data.setCusData(cusMap);
        try {
            DataCollectServiceHelper.addData(data, this.getView());
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    public void click(EventObject evt) {
        if (!(evt instanceof ClickEvent)) {
            return;
        }
        ClickEvent clickEvent = (ClickEvent)evt;
        Map paramsMap = clickEvent.getParamsMap();
        Control c = (Control)evt.getSource();
        String clickKey = c.getKey();
        if (SUBMAINTAB.equals(clickKey) && null != paramsMap) {
            this.appTabClick(paramsMap);
        } else if (VIEWFEATURE.equals(clickKey)) {
            this.viewFeatureClick();
        } else if ("closeappfeature".equals(clickKey)) {
            this.closeAppFeature("closeappfeature");
        } else {
            this.menuMarkClick(paramsMap);
        }
    }

    private void appTabClick(Map<String, Object> paramsMap) {
        String key;
        Object controlKey = paramsMap.get(CONTROL_KEY);
        if (controlKey == null) {
            return;
        }
        switch (key = controlKey.toString()) {
            case "pageHelp": {
                this.getHelpInfo("knowledge");
                this.getPageHelpCustomMenu(SUBMAINTAB);
                break;
            }
            case "pageTeamWork": {
                this.showTeamWork();
                break;
            }
            case "pageInsight": {
                this.showInsight();
                break;
            }
            case "clickShare": {
                this.showShareForm();
                break;
            }
            case "newGuide": {
                this.newGuide();
                break;
            }
            case "shortcutsSetting": {
                ShortCutUtils.showAdvancesetting(this.getView());
                break;
            }
            case "helpArticle": {
                this.doCustomHelpClick((String)paramsMap.get("number"));
                break;
            }
            default: {
                this.pageHelpCustomMenuClick(controlKey.toString());
            }
        }
    }

    private void viewFeatureClick() {
        String viewFeatureUrl = this.getPageCache().get(this.getView().getPageId() + VIEWFEATURE);
        try {
            this.closeAppFeature(VIEWFEATURE);
            this.getView().openUrl(viewFeatureUrl);
        }
        catch (Exception e) {
            logger.info("\u65b0\u7279\u6027\u8df3\u8f6c\u94fe\u63a5\u5f02\u5e38:" + viewFeatureUrl, (Object)e);
        }
    }

    private void menuMarkClick(Map<String, Object> paramsMap) {
        if (null != paramsMap && null != paramsMap.get("isMark")) {
            String menuId;
            boolean isMark = (Boolean)paramsMap.get("isMark");
            String string = menuId = paramsMap.get("menuId") == null ? null : paramsMap.get("menuId").toString();
            if (menuId != null && menuId.endsWith("#hpce")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e2e\u52a9\u4e2d\u5fc3\u4e0d\u652f\u6301\u6536\u85cf\u3002", (String)"BizAppHomePlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            long userId = RequestContext.get().getCurrUserId();
            String appNum = this.getView().getFormShowParameter().getAppId();
            List<String> markedMenuList = this.loadUserMarkedMenus(userId, appNum);
            try {
                if (isMark) {
                    if (!markedMenuList.contains(menuId)) {
                        DynamicObject objForSave = BusinessDataServiceHelper.newDynamicObject((String)"portal_usermarkedmenu");
                        objForSave.set("user", (Object)userId);
                        objForSave.set("bizapp", (Object)appNum);
                        objForSave.set("menu", (Object)menuId);
                        objForSave.set("createtime", (Object)TimeServiceHelper.now());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objForSave});
                        markedMenuList.add(menuId);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002", (String)"BizAppHomePlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    }
                } else {
                    DeleteServiceHelper.delete((String)"portal_usermarkedmenu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("menu", "=", (Object)menuId)});
                    markedMenuList.remove(menuId);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf\u6210\u529f\u3002", (String)"BizAppHomePlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                logger.info("\u6536\u85cf/\u53d6\u6d88\u6536\u85cf\u6709\u8bef", (Object)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u85cf/\u53d6\u6d88\u6536\u85cf\u6709\u8bef", (String)"BizAppHomePlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            TreeMenu treeMenu = (TreeMenu)this.getControl(CONS_NAVIGATIONBAR);
            treeMenu.setTreeMenusMarked(markedMenuList);
        }
    }

    private void newGuide() {
        IFormView view = this.getView().getMainView();
        if (view != null) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            Map<String, Object> guideItems = MainPagePlugin.getHomepageGuideData(this.getView().getMainView());
            proxy.addAction("showGuide", guideItems);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u9884\u89c8\u65b0\u624b\u5f15\u5bfc\u3002", (String)"BizAppHomePlugin_18", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void showShareForm() {
        String shareFormStr = this.getPageCache().get(TO_SHARE_FORM);
        if (StringUtils.isBlank((CharSequence)shareFormStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5355\u636e", (String)"BizAppHomePlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map shareForm = (Map)SerializationUtils.fromJsonString((String)shareFormStr, Map.class);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bos_share_form");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParams(shareForm);
        this.getView().showForm(fsp);
    }

    private void showTeamWork() {
        Tab apptabs = (Tab)this.getView().getControl(SUBMAINTAB);
        HashMap<String, Object> parseResult = new HashMap<String, Object>(8);
        if (apptabs != null) {
            String billFormId;
            String currentTab = apptabs.getCurrentTab();
            String bizDataId = null;
            String appId = System.getProperty("YZJAppID");
            String domainUrl = UrlService.getDomainContextUrl();
            if (kd.bos.util.StringUtils.isNotEmpty((String)domainUrl) && domainUrl.endsWith("/")) {
                domainUrl = domainUrl.substring(0, domainUrl.length() - 1);
            }
            StringBuilder authCode = new StringBuilder();
            if (APPMIANTAB.equals(currentTab)) {
                billFormId = APPMIANTAB;
            } else {
                IFormView view = this.getView().getViewNoPlugin(currentTab);
                if (view == null) {
                    return;
                }
                if (view instanceof ListView) {
                    billFormId = ((ListView)view).getBillFormId();
                } else {
                    MainEntityType mainEntityType;
                    billFormId = (String)view.getFormShowParameter().getCustomParams().get(BILL_FORM_ID);
                    if (billFormId == null) {
                        billFormId = view.getFormShowParameter().getFormId();
                    }
                    if ((mainEntityType = MetadataServiceHelper.getDataEntityType((String)billFormId)) != null && mainEntityType.getDisplayName() != null && StringUtils.isNotEmpty((CharSequence)mainEntityType.getDisplayName().getLocaleValue())) {
                        parseResult.put(BILL_NAME, mainEntityType.getDisplayName().getLocaleValue());
                    }
                    Object pkId = null;
                    try {
                        pkId = view.getModel().getDataEntity().getPkValue();
                    }
                    catch (KDException e) {
                        logger.info("BizAppHomePlugin--showTeamWork getpkid error", (Object)e);
                    }
                    if (null != pkId && !"0".equals(pkId.toString())) {
                        bizDataId = pkId.toString();
                        authCode.append(bizDataId);
                        DynamicObject obj = null;
                        try {
                            obj = BusinessDataServiceHelper.loadSingle((Object)bizDataId, (String)billFormId);
                        }
                        catch (KDException e) {
                            logger.info(String.format("BizAppHomePlugin--showTeamWork loaddata error, pkid:%s, formId:%s", bizDataId, billFormId));
                            bizDataId = null;
                        }
                        if (obj != null) {
                            DynamicObject creator;
                            Date createTime;
                            String billno = null;
                            DynamicPropertyCollection property = (DynamicPropertyCollection)obj.getDataEntityType().getProperties();
                            if (property.containsKey((Object)"createtime") && (createTime = obj.getDate("createtime")) != null) {
                                authCode.append(createTime.getTime());
                                parseResult.put("createDate", DateUtils.formatDate(createTime, "yyyyMMdd"));
                                parseResult.put("createTime", DateUtils.formatDate(createTime, "HHmmss"));
                            }
                            if (property.containsKey((Object)"billno")) {
                                billno = obj.getString("billno");
                            }
                            if (property.containsKey((Object)"creator") && (creator = obj.getDynamicObject("creator")) != null) {
                                authCode.append(creator.get("masterid"));
                                parseResult.put("creatorId", creator.get("masterid"));
                                OrmLocaleValue nameLocalVal = (OrmLocaleValue)creator.get("name");
                                String name = nameLocalVal.get((Object)"zh_CN");
                                parseResult.put(USERNAME, name);
                                parseResult.put("creatorName", name);
                            }
                            if (kd.bos.util.StringUtils.isNotEmpty((String)billno)) {
                                parseResult.put(BILL_NAME, parseResult.get(BILL_NAME) + "-" + billno);
                            }
                            HashMap<String, String> data = new HashMap<String, String>(16);
                            data.put(SHARE_PK_ID, bizDataId);
                            data.put(SHARE_FORM_ID, billFormId);
                            data.put(SHARE_BILL_NAME, (String)parseResult.get(BILL_NAME));
                            this.getPageCache().put(TO_SHARE_FORM, SerializationUtils.toJsonString(data));
                        }
                        if (bizDataId != null) {
                            parseResult.put("billLink", domainUrl + "/index.html?pkId=" + bizDataId + "&formId=" + billFormId + "&appId=" + appId);
                        }
                    }
                }
                if (billFormId == null) {
                    billFormId = view.getFormShowParameter().getFormId();
                }
            }
            String dataCenterId = RequestContext.get().getAccountId();
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(Long.parseLong(RequestContext.get().getUserId()));
            List userInfoList = UserServiceHelper.get(userIds, (String[])new String[]{"id", "eid", USERNAME, PICTUREFIELD, "name"}, null);
            if (StringUtils.isEmpty((CharSequence)bizDataId) || "0".equals(bizDataId)) {
                bizDataId = billFormId;
                StringBuilder temp = new StringBuilder(bizDataId).append(dataCenterId);
                authCode.append((CharSequence)temp);
            }
            parseResult.put("bizDataId", bizDataId);
            parseResult.put("dataCenterId", dataCenterId);
            parseResult.put("oid", RequestContext.get().getUserOpenId());
            parseResult.put("appId", appId);
            if (null != userInfoList && userInfoList.size() > 0) {
                parseResult.put("userId", ((Map)userInfoList.get(0)).get("id"));
                parseResult.put("eid", ((Map)userInfoList.get(0)).get("eid"));
                OrmLocaleValue nameLocalVal = (OrmLocaleValue)((Map)userInfoList.get(0)).get("name");
                String name = nameLocalVal.get((Object)"zh_CN");
                parseResult.put(USERNAME, name);
                String imageUrl = ImageUtil.getCurrentUserAvatarPath(true);
                parseResult.put(PICTUREFIELD, imageUrl);
            }
            parseResult.put("authCode", authCode);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PAGE_ID, this.getView().getPageId());
        params.put("data", parseResult);
        proxy.addAction(SHOW_TEAM_WORK, params);
    }

    private void showInsight() {
        String currentTab;
        Tab apptabs = (Tab)this.getView().getControl(SUBMAINTAB);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        HashMap<String, String> result = new HashMap<String, String>(8);
        String entityNumber = null;
        String bizDataId = null;
        String bizPageId = null;
        if (apptabs != null && !APPMIANTAB.equals(currentTab = apptabs.getCurrentTab())) {
            IFormView view = this.getView().getViewNoPlugin(currentTab);
            if (view == null) {
                return;
            }
            bizPageId = view.getPageId();
            if (view instanceof ListView) {
                entityNumber = ((ListView)view).getBillFormId();
            } else {
                entityNumber = (String)view.getFormShowParameter().getCustomParams().get(BILL_FORM_ID);
                if (entityNumber == null) {
                    entityNumber = view.getFormShowParameter().getFormId();
                }
                Object pkId = null;
                try {
                    pkId = view.getModel().getDataEntity().getPkValue();
                }
                catch (KDException e) {
                    logger.info("BizAppHomePlugin--showInsight getpkid error", (Object)e);
                }
                if (null != pkId) {
                    bizDataId = pkId.toString();
                }
            }
        }
        result.put("entityNumber", entityNumber);
        result.put("bizDataId", bizDataId);
        result.put(PAGE_ID, bizPageId);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        params.put(PAGE_ID, this.getView().getPageId());
        params.put("data", result);
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        Map sysParams = ParametersUtils.getCommonParameters((Account)currentCenter);
        String aiInsightForm = "idi_float_layer";
        if (sysParams != null && sysParams.get("ai_insight_form") != null) {
            aiInsightForm = sysParams.get("ai_insight_form").toString();
        }
        params.put("formId", aiInsightForm);
        proxy.addAction(SHOW_INSIGHT, params);
    }

    private void closeAppFeature(String clickName) {
        this.getView().setVisible(Boolean.FALSE, new String[]{APPFEATUREFLEXPANEL});
        try {
            String appId = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            String appNumber = app.getNumber();
            long userId = RequestContext.get().getCurrUserId();
            PortalAppFeaturesCache portalAppFeaturesCache = new PortalAppFeaturesCache();
            Date updateTime = portalAppFeaturesCache.getAppFeatureLastUpdateTime(appNumber);
            portalAppFeaturesCache.updateUserAppFeatureFlag(userId, appNumber, Boolean.FALSE, updateTime);
            Map<String, String> appFeature = portalAppFeaturesCache.getAppFeatrue(appNumber);
            String featureId = appFeature.get("id");
            HashMap<String, String> cusMap = new HashMap<String, String>();
            cusMap.put("NewFeatures_id", featureId);
            cusMap.put("clicked_content", clickName);
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String formId = showParameter.getFormId();
            ThreadPools.executeOnce((String)"newFeaturesClickDataCollect", () -> this.newFeaturesDataCollect("NewFeatures_click", appNumber, formId, cusMap));
        }
        catch (Exception e) {
            logger.info("\u5173\u95ed\u65b0\u7279\u6027\u7279\u6027\u9762\u677f\u5f02\u5e38:", (Object)e);
        }
    }

    private List<String> loadUserMarkedMenus(long userId, String appNum) {
        ArrayList<String> markedMenuList = new ArrayList<String>();
        try {
            DynamicObject[] userMarkedMenus = BusinessDataServiceHelper.load((String)"portal_usermarkedmenu", (String)"menu", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("bizapp", "=", (Object)appNum)});
            if (userMarkedMenus != null && userMarkedMenus.length > 0) {
                for (DynamicObject userMarkedMenu : userMarkedMenus) {
                    markedMenuList.add(userMarkedMenu.getString("menu"));
                }
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u7528\u6237\u6536\u85cf\u83dc\u5355\u4fe1\u606f\u6709\u8bef", (Object)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u6536\u85cf\u83dc\u5355\u4fe1\u606f\u67e5\u8be2\u6709\u8bef\u3002", (String)"BizAppHomePlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        return markedMenuList;
    }

    public void treeMenuClick(TreeNodeEvent evt) {
        try {
            String url = this.getView().getParentView().getFormShowParameter().getFormId();
            String mainPageFormId = CardUtils.getMainViewFormId(this.getView());
            if (!mainPageFormId.equals(url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u9884\u89c8\u5e94\u7528\u83dc\u5355\u4fe1\u606f\u3002", (String)"BizAppHomePlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String appID = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
            String checkedNodeID = evt.getNodeId().toString();
            List<AppMenuInfo> qingMenus = this.menuService.getQingMenuArray(appID);
            List<String> qingMenuIds = this.getQingMenuIds(qingMenus);
            if (!CollectionUtils.isEmpty(qingMenus) && qingMenuIds.size() > 0 && qingMenuIds.contains(checkedNodeID)) {
                for (AppMenuInfo qingObj : qingMenus) {
                    String qingMenuId = qingObj.getId();
                    if (!checkedNodeID.equals(qingMenuId)) continue;
                    String formNumber = qingObj.getFormId();
                    String qingMenuName = qingObj.getName().getLocaleValue();
                    String formParams = qingObj.getParams();
                    FormConfig formConfig = FormMetadataCache.getFormConfig((String)formNumber);
                    if (formConfig == null) {
                        String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8f7b\u5206\u6790\u52a8\u6001\u7f16\u7801\u4e3a %s \u7684\u52a8\u6001\u8868\u5355\uff0c\u8bf7\u524d\u5f80\u8f7b\u5206\u6790\u52a8\u6001\u8868\u5355\u7ba1\u7406\u4e2d\u7ef4\u62a4\u3002", (String)"BizAppHomePlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), formNumber);
                        this.getView().showTipNotification(message);
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)formNumber)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u83dc\u5355\u672a\u7ed1\u5b9a\u9875\u9762\uff0c\u8bf7\u524d\u5f80\u201c\u8f7b\u5206\u6790\u201d\u914d\u7f6e\u3002", (String)"BizAppHomePlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("view", this.getView());
                    map.put("formnumber", formNumber);
                    map.put("parameter", formParams);
                    map.put("menuname", qingMenuName);
                    map.put("parametertype", null);
                    map.put("openType", null);
                    map.put("permItem", null);
                    OpenPageUtils.openApp(appID, checkedNodeID, map, this.getView());
                }
            } else {
                AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appID, (String)checkedNodeID);
                if (menu == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u83dc\u5355\u4fe1\u606f\u5931\u8d25", (String)"BizAppHomePlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                String formId = menu.getFormId();
                if ("page".equals(menu.getMenuType()) && StringUtils.isBlank((CharSequence)formId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83dc\u5355\u672a\u7ed1\u5b9a\u5bf9\u5e94\u7684\u9875\u9762\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u914d\u7f6e\u5e94\u7528\u83dc\u5355\u3002", (String)"BizAppHomePlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("view", this.getView());
                map.put("formnumber", formId);
                map.put("parametertype", menu.getParamType());
                map.put("parameter", JSONArray.parseObject((String)menu.getParams()));
                map.put("menuname", menu.getName());
                map.put("openType", menu.getOpenType());
                map.put("permItem", menu.getPermission());
                OpenPageUtils.openApp(appID, checkedNodeID, map, this.getView());
            }
        }
        catch (Exception e) {
            logger.info("treeMenuClick error", (Object)e);
            this.getView().showMessage(ResManager.loadKDString((String)"\u83dc\u5355\u5173\u8054\u7684\u8868\u5355\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizAppHomePlugin_17", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private List<String> getQingMenuIds(List<AppMenuInfo> qingMenus) {
        LinkedList<String> qingMenuIds = new LinkedList<String>();
        if (CollectionUtils.isEmpty(qingMenus)) {
            return qingMenuIds;
        }
        for (AppMenuInfo qingObj : qingMenus) {
            String qingMenuId = qingObj.getId();
            if (!StringUtils.isNotEmpty((CharSequence)qingMenuId)) continue;
            qingMenuIds.add(qingMenuId);
        }
        return qingMenuIds;
    }

    public JSONArray getMenuArray() {
        String appNumber = this.getAppNumber();
        if (appNumber == null || "".equals(appNumber.trim())) {
            return new JSONArray();
        }
        JSONArray menus = this.getAppItems(appNumber);
        return menus;
    }

    private String getAppNumber() {
        String appNumber = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
        if (appNumber == null || "".equals(appNumber.trim())) {
            appNumber = this.getView().getFormShowParameter().getAppId();
        }
        if (appNumber == null) {
            return null;
        }
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
            appNumber = appInfo.getAppId();
        }
        catch (Exception e) {
            logger.info("BizAppHomePlugin#getAppNumber, getAppInfo error", (Object)e);
            return null;
        }
        return appNumber;
    }

    @Deprecated
    public JSONArray getQingMenuArray() {
        String appNumber = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
        if (appNumber == null || "".equals(appNumber.trim())) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        if (appInfo == null || appInfo.getId() == null || "".equals(appInfo.getId())) {
            return null;
        }
        JSONArray qingMenus = null;
        try {
            String appId = appInfo.getId();
            Class<?> qingAppMenuUtil = Class.forName("kd.bos.qing.plugin.appmenu.QingAppMenuUtil");
            String result = (String)MethodUtils.invokeStaticMethod(qingAppMenuUtil, (String)"getAppQingMenu", (Object)appId);
            qingMenus = JSONArray.parseArray((String)result);
            logger.debug("qingmenus\uff1a" + result);
            this.getPageCache().put("qingmenus", qingMenus.toJSONString());
        }
        catch (Exception ex) {
            logger.info("getQingMenuArray error.", (Object)ex);
            return null;
        }
        return qingMenus;
    }

    public void renderNavigation(JSONArray menuArray, JSONArray qingArray) {
        String appNumber = this.getAppNumber();
        if (appNumber == null) {
            return;
        }
        List<TreeMenuNode> nodeList = null;
        nodeList = qingArray != null ? this.createTreeMenu(menuArray, qingArray, appNumber) : this.createTreeMenu(menuArray, null, appNumber);
        TreeMenu navigationBar = (TreeMenu)this.getView().getControl(CONS_NAVIGATIONBAR);
        if (navigationBar != null) {
            navigationBar.addNodes(nodeList);
        }
    }

    private JSONArray getAppItems(String appNumber) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        List<AppMenuInfo> menus = this.menuService.getHasPermMenuByAppId((Long)RequestContext.get().getCurrUserId(), appId, true);
        JSONArray appMenu = new JSONArray();
        if (menus == null) {
            return appMenu;
        }
        Map bizObjMap = null;
        try {
            ArrayList<String> appNumbers = new ArrayList<String>();
            appNumbers.add(appNumber);
            Map grayObjectInfoByAppNumbers = LicenseGrayServiceHelper.getGrayMenuIdByPublishAppNumbers(appNumbers);
            bizObjMap = (Map)grayObjectInfoByAppNumbers.get(appNumber);
        }
        catch (Exception e) {
            logger.info("getGrayObjectInfoByAppNumbers error", (Object)e);
        }
        for (AppMenuInfo menu : menus) {
            String valid;
            Map validMap;
            String formId = menu.getFormId();
            String menuId = menu.getId();
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)menuId);
            LocaleString localeName = menu.getName();
            if (localeName == null) continue;
            String menuName = localeName.getLocaleValue();
            if (StringUtils.isBlank((CharSequence)menuName) && StringUtils.isBlank((CharSequence)(menuName = (String)localeName.get((Object)this.getDefaultLang())))) {
                menuName = localeName.getLocaleValue_zh_CN();
            }
            obj.put("name", (Object)menuName);
            obj.put("formid", (Object)formId);
            obj.put(IMAGE_URL, (Object)menu.getNaviVector());
            obj.put(PARENT_ID, (Object)menu.getParentId());
            if (bizObjMap != null && (validMap = (Map)bizObjMap.get(menuId)) != null && (valid = (String)validMap.get("valid")) != null) {
                obj.put("grayValid", (Object)valid);
            }
            appMenu.add((Object)obj);
        }
        return appMenu;
    }

    private void getMenuTreeNode(JSONArray menus, JSONArray qingMenus, List<String> parentMenuIds, List<TreeMenuNode> parentMenuList, List<String> noPermMenuIds, boolean qingMenuExist) {
        ArrayList<String> menuIdsList = new ArrayList<String>();
        ArrayList<TreeMenuNode> menuNodesList = new ArrayList<TreeMenuNode>();
        ListIterator childrenMenu = menus.listIterator();
        while (childrenMenu.hasNext()) {
            JSONObject childMenu = (JSONObject)childrenMenu.next();
            String parentMenuId = childMenu.getString(PARENT_ID);
            String menuId = childMenu.getString("id");
            String menuName = childMenu.getString("name");
            String imageUrl = childMenu.getString(IMAGE_URL);
            if (!parentMenuIds.contains(parentMenuId)) continue;
            String grayValid = childMenu.getString("grayValid");
            TreeMenuNode menuNode = new TreeMenuNode(parentMenuId, menuId, menuName, imageUrl, imageUrl);
            menuNode.setGrayValid(grayValid);
            menuNodesList.add(menuNode);
            menuIdsList.add(menuId);
        }
        if (!menuIdsList.isEmpty()) {
            for (int i = 0; i < parentMenuList.size(); ++i) {
                TreeMenuNode pNode = parentMenuList.get(i);
                DevportalUtil.buildNode(pNode, menuNodesList);
            }
            this.getMenuTreeNode(menus, qingMenus, menuIdsList, menuNodesList, noPermMenuIds, true);
        }
    }

    private List<TreeMenuNode> createTreeMenu(JSONArray menus, JSONArray qingMenus, String appNumber) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        ArrayList<TreeMenuNode> firMenuNodes = new ArrayList<TreeMenuNode>();
        ArrayList<String> menuList = new ArrayList<String>(10);
        LinkedList<String> firMenuList = new LinkedList<String>();
        ListIterator menuListIterator = menus.listIterator();
        while (menuListIterator.hasNext()) {
            JSONObject menu = (JSONObject)menuListIterator.next();
            String parentMenuId = menu.getString(PARENT_ID);
            String menuId = menu.getString("id");
            String menuName = menu.getString("name");
            String imageUrl = menu.getString(IMAGE_URL);
            if (StringUtils.isBlank((CharSequence)parentMenuId) || parentMenuId.equals(appId)) {
                String grayValid = menu.getString("grayValid");
                TreeMenuNode firstMenuNode = new TreeMenuNode("root", menuId, menuName, imageUrl, imageUrl);
                firstMenuNode.setGrayValid(grayValid);
                firMenuNodes.add(firstMenuNode);
                firMenuList.add(menuId);
                menuListIterator.remove();
            }
            menuList.add(menuId);
        }
        this.getMenuTreeNode(menus, qingMenus, firMenuList, firMenuNodes, null, true);
        CardUtils.setCurShowableMenuList(this.getPageCache(), menuList);
        return firMenuNodes;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache mainPageCahce;
        String homepage_tabap_count;
        IFormView mainView = this.getView().getMainView();
        if (mainView != null && (homepage_tabap_count = (mainPageCahce = (IPageCache)mainView.getService(IPageCache.class)).get("homepage_tabap_count")) != null) {
            int count = Integer.parseInt(homepage_tabap_count);
            mainPageCahce.put("homepage_tabap_count", --count + "");
        }
    }

    public void treeMenuDoubleClick(TreeNodeEvent evt) {
    }

    public void tabSelected(TabSelectEvent event) {
        try {
            String appPageId = this.getView().getPageId();
            IFormView mainFormView = this.getView().getMainView();
            if (mainFormView == null) {
                return;
            }
            String pageId = mainFormView.getPageId();
            if (appPageId.contains(pageId)) {
                String appNum = appPageId.replace(pageId, "");
                PortalMessageUtils.showActivityMessageAsync(pageId, appNum);
            }
        }
        catch (Exception e) {
            logger.info("showActivityMessageAsync error", (Object)e);
        }
    }

    private void getHelpInfo(String title) {
        this.knowledgeSearch();
    }

    @Override
    protected IFormView getCurrentView() {
        return this.getView();
    }

    @Override
    protected String getBillFormId() {
        String billFormId = null;
        Tab apptabs = (Tab)this.getView().getControl(SUBMAINTAB);
        if (apptabs != null) {
            String currentTab = apptabs.getCurrentTab();
            if (APPMIANTAB.equals(currentTab)) {
                billFormId = "";
            } else {
                IFormView view = this.getView().getViewNoPlugin(currentTab);
                if (view == null) {
                    return billFormId;
                }
                billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : (String)view.getFormShowParameter().getCustomParams().get(BILL_FORM_ID);
                if (billFormId == null) {
                    billFormId = view.getFormShowParameter().getFormId();
                }
            }
        }
        return billFormId;
    }

    @Override
    protected void showHotQuestion(Object result, String entityUrl) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> o = new HashMap<String, Object>();
        o.put(PAGE_ID, this.getView().getPageId());
        o.put("data", result);
        o.put("entityUrl", entityUrl);
        o.put("key", SUBMAINTAB);
        proxy.addAction("showHotQuestion", o);
    }

    public void tabClose(TabCloseEvent evt) {
        List tabKeys = evt.getTabKeys();
        ArrayList tabListClose = new ArrayList(10);
        for (String tabKey : tabKeys) {
            IFormView formView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
            if (formView != null) {
                formView.close();
            }
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put(PAGE_ID, tabKey);
            tabListClose.add(arg);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    private String getDefaultLang() {
        List langs = InteServiceHelper.getEnabledLang();
        for (EnabledLang el : langs) {
            if (!el.getIsDefault().booleanValue()) continue;
            return el.getNumber();
        }
        return Lang.zh_CN.toString();
    }

    public void tabReOpen(TabOperationEvent tabReopenEvent) {
        String pageId = tabReopenEvent.getTabKey();
        IFormView formView = this.getView().getViewNoPlugin(pageId);
        if (formView != null) {
            String mainPageId = this.getView().getPageId();
            String menuPageId = pageId.contains(mainPageId) ? pageId.substring(0, pageId.indexOf("root")) + mainPageId : pageId;
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            formShowParameter.setPageId(menuPageId + kd.bos.login.utils.StringUtils.randomNumber((int)16));
            this.getView().showForm(formShowParameter);
        }
    }
}

