/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BizAppInfoEditPlugin
extends AbstractFormPlugin {
    public static final String APPNAME = "appname";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject appInfoObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("appinfo");
        String nameStr = appInfoObject.getString(APPNAME);
        String descriptionStr = appInfoObject.getString("description");
        if (StringUtils.isBlank((CharSequence)nameStr)) {
            return;
        }
        try {
            HashMap appNameMap = (HashMap)JSONUtils.cast((String)nameStr, HashMap.class);
            LocaleString appNameLocale = LocaleString.fromMap((Map)appNameMap);
            HashMap descriptionMap = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)descriptionStr)) {
                descriptionMap = (HashMap)JSONUtils.cast((String)descriptionStr, HashMap.class);
            }
            LocaleString descriptionLocale = LocaleString.fromMap(descriptionMap);
            this.getView().getModel().setValue(APPNAME, (Object)appNameLocale);
            this.getView().getModel().setValue("appdescription", (Object)descriptionLocale);
        }
        catch (IOException exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u540d\u79f0\u6216\u63cf\u8ff0\u8f6c\u6362\u51fa\u9519\u3002", (String)"BizAppInfoEditPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.editAppInfo();
                break;
            }
        }
    }

    private void editAppInfo() {
        OrmLocaleValue appName = (OrmLocaleValue)this.getModel().getValue(APPNAME);
        if (!this.validMuliTLangTextNotBlank(appName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5e94\u7528\u540d\u201d\u3002", (String)"BizAppInfoEditPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        JSONObject appInfoObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("appinfo");
        String bizAppid = appInfoObject.getString("appid");
        boolean isSetDefault = (Boolean)appInfoObject.get((Object)"issetdefault");
        String apps = appInfoObject.getString("apps");
        OrmLocaleValue description = (OrmLocaleValue)this.getModel().getValue("appdescription");
        HashMap<String, Object> appInfo = new HashMap<String, Object>();
        appInfo.put(APPNAME, appName);
        appInfo.put("description", description);
        appInfo.put("bizappid", bizAppid);
        appInfo.put("issetdefault", isSetDefault);
        appInfo.put("apps", apps);
        this.getView().returnDataToParent(appInfo);
        this.getView().close();
    }

    private boolean validMuliTLangTextNotBlank(OrmLocaleValue ormLocaleValue) {
        if (CollectionUtils.isEmpty((Map)ormLocaleValue)) {
            return false;
        }
        return ormLocaleValue.values().stream().anyMatch(StringUtils::isNotBlank);
    }
}

