/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.ICardConfig;
import kd.bos.portal.util.DevportalUtil;
import kd.bos.portal.util.MetaDataUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardNewPlugin
extends AbstractFormPlugin
implements ClickListener,
TabSelectListener {
    private static final String CARD_TEMPLATE = "/CardTemplate.xml";
    public static final String TITLEIMG = "titleimg";
    public static final String CARDTYPE = "cardtype";
    public static final String BOS_DEVP_ENTITY = "bos_devp_entity";
    public static final String APPID_ID = "appid.id";
    public static final String RADIOGROUPFIELD = "radiogroupfield";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String APPID = "appid";
    public static final String CARDPAGEID = "cardpageid";
    public static final String FLEXPANELAP_2 = "flexpanelap2";
    public static final String PAGE_ID = "pageId";
    public static final String CARDID = "cardid";
    public static final String FORMID = "formid";
    public static final String PREVIEWPAGEID = "previewpageid";
    public static final String NUMBER = "number";
    public static final String TITLE = "title";
    public static final String LABEL = "label";
    public static final String ISSHOWTITLEAREA = "isshowtitlearea";
    public static final String TITLEIMGURL = "titleimgurl";
    public static final String FLEXPANELAP_3 = "flexpanelap3";
    public static final String CONFIGPAGEID = "configpageid";
    public static final String CARDKEY = "cardkey";
    public static final String CARDCONFIG = "cardconfig";
    public static final String ISNEWPERSONALCARD = "isnewpersonalcard";
    public static final String ENTITYID = "entityid";
    public static final String CARDSIZE = "cardsize";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btncancel", "btnnext1", "btnlast2", "btnnext2", "btnlast3", "btnnext3", "btnfinish", "btnlast4", "btnnext4", TITLEIMG, "btnpublish", "imageap", "imageap1", "imageap2", "imageap3", "imageap4", "imageap5"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("type", CARDTYPE);
        DynamicObject[] bizApps = BusinessDataServiceHelper.load((String)BOS_DEVP_ENTITY, (String)"id,appid", null);
        JSONArray bizAppIds = new JSONArray();
        for (DynamicObject dynamicObject : bizApps) {
            bizAppIds.add((Object)dynamicObject.getString(APPID_ID));
        }
        QFilter qFilter = new QFilter("id", "in", (Object)bizAppIds);
        ListShowParameter parameter = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        fParameter.setFilter(qFilter);
        parameter.setMultiSelect(false);
        parameter.setListFilterParameter(fParameter);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap8");
        parameter.setBillFormId("bos_devportal_app_layout");
        String appPageId = UUID.randomUUID().toString();
        this.getPageCache().put("apppageid", appPageId);
        parameter.setPageId(appPageId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btncancel": {
                this.cancel();
                break;
            }
            case "btnnext1": {
                this.step1next();
                break;
            }
            case "btnlast2": {
                this.step2last();
                break;
            }
            case "btnnext2": {
                this.step2next();
                break;
            }
            case "btnlast3": {
                this.step3last();
                break;
            }
            case "btnnext3": {
                this.step3next();
                break;
            }
            case "btnfinish": {
                this.finish();
                break;
            }
            case "btnlast4": {
                this.step4last();
                break;
            }
            case "btnpublish": {
                this.publish();
                break;
            }
            case "titleimg": {
                this.selectImg();
                break;
            }
            case "imageap": {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"LinkCard");
                break;
            }
            case "imageap1": {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"StatementCard");
                break;
            }
            case "imageap2": {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"ListStatisticsCard");
                break;
            }
            case "imageap3": {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"YunZhiJiaCard");
                break;
            }
            case "imageap4": {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"BillDigestCard");
                break;
            }
            case "imageap5": {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"CustomCard");
                break;
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void step1next() {
        QFilter qFilter = null;
        String type = this.getPageCache().get("type");
        if (CARDTYPE.equals(type)) {
            String cardType = (String)this.getModel().getValue(RADIOGROUPFIELD);
            if (StringUtils.isBlank((CharSequence)cardType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5361\u7247\u7c7b\u578b\u3002", (String)"CardNewPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            qFilter = new QFilter("type", "=", (Object)cardType);
        } else {
            IFormView view = this.getView().getView(this.getPageCache().get("apppageid"));
            ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
            if (selectedRows == null || selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"CardNewPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            String bizAppId = (String)selectedRow.getPrimaryKeyValue();
            qFilter = new QFilter(APPID, "=", (Object)bizAppId);
        }
        ListShowParameter parameter = new ListShowParameter();
        ListFilterParameter fParameter = new ListFilterParameter();
        fParameter.setFilter(qFilter);
        parameter.setMultiSelect(false);
        parameter.setListFilterParameter(fParameter);
        StyleCss sc = new StyleCss();
        sc.setHeight("360px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap15");
        parameter.setBillFormId(BOS_DEVP_ENTITY);
        String cardPageId = UUID.randomUUID().toString();
        this.getPageCache().put(CARDPAGEID, cardPageId);
        parameter.setPageId(cardPageId);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP_2});
    }

    private void step2last() {
        String pageId = this.getPageCache().get(CARDPAGEID);
        this.getPageCache().remove(CARDPAGEID);
        if (pageId != null) {
            HashMap<String, String> pageIds = new HashMap<String, String>();
            pageIds.put(PAGE_ID, pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", pageIds);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP_2});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap1"});
    }

    private void step2next() {
        IFormView view = this.getView().getView(this.getPageCache().get(CARDPAGEID));
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5361\u7247\u3002", (String)"CardNewPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ListSelectedRow selectedRow = selectedRows.get(0);
        String cardId = (String)selectedRow.getPrimaryKeyValue();
        this.getPageCache().put(CARDID, cardId);
        DynamicObject card = BusinessDataServiceHelper.loadSingle((Object)cardId, (String)BOS_DEVP_ENTITY);
        FormShowParameter param = new FormShowParameter();
        param.setFormId(card.getString(FORMID));
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("flexpanelap12");
        String pageId = UUID.randomUUID().toString();
        this.getPageCache().put(PREVIEWPAGEID, pageId);
        param.setPageId(pageId);
        param.setCustomParam(CARDID, (Object)cardId);
        param.setCustomParam("scene", (Object)"cardmanage");
        this.getView().showForm(param);
        IDataModel model = this.getModel();
        model.setValue(NUMBER, (Object)card.getString(NUMBER));
        model.setValue(TITLE, (Object)card.getLocaleString("name").getLocaleValue());
        model.setValue(LABEL, (Object)card.getString(LABEL));
        model.setValue(ISSHOWTITLEAREA, (Object)card.getString(ISSHOWTITLEAREA));
        if (StringUtils.isNotBlank((CharSequence)card.getString(TITLEIMG))) {
            model.setValue(TITLEIMGURL, (Object)card.getString(TITLEIMG));
            Image image = (Image)this.getControl(TITLEIMG);
            image.setUrl(card.getString(TITLEIMG));
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP_2});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP_3});
    }

    private void step3last() {
        String pageId = this.getPageCache().get(PREVIEWPAGEID);
        this.getPageCache().remove(PREVIEWPAGEID);
        if (pageId != null) {
            HashMap<String, String> pageIds = new HashMap<String, String>();
            pageIds.put(PAGE_ID, pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", pageIds);
        }
        Image image = (Image)this.getControl(TITLEIMG);
        image.setUrl("20170628/89ed/0f/0c/e6d513d8886b4c42b2628fa31a936806.png");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP_3});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP_2});
    }

    private void step3next() {
        IDataModel model = this.getModel();
        String title = model.getValue(TITLE).toString();
        String titleImg = model.getValue(TITLEIMGURL).toString();
        String cardId = this.getPageCache().get(CARDID);
        DynamicObject card = BusinessDataServiceHelper.loadSingle((Object)cardId, (String)BOS_DEVP_ENTITY);
        String cardTemplateFormId = card.getString(FORMID);
        FormShowParameter parameter = new FormShowParameter();
        if (StringUtils.isNotBlank((CharSequence)card.getString("widgetnumber"))) {
            cardTemplateFormId = card.getString("widgetnumber");
        }
        if (StringUtils.isNotBlank((CharSequence)card.getString("configpagenumber"))) {
            String configPageFormId = card.getString("configpagenumber");
            parameter.setFormId(configPageFormId);
        } else {
            JSONArray cardTemplateList = DevportalUtil.readXML(CARD_TEMPLATE);
            for (int i = 0; i < cardTemplateList.size(); ++i) {
                JSONObject map = (JSONObject)cardTemplateList.get(i);
                if (cardTemplateFormId == null || !cardTemplateFormId.equals(map.getString("Id"))) continue;
                String configPageFormId = map.getString("ConfigPage");
                parameter.setFormId(configPageFormId);
                break;
            }
        }
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (!metaDataUtil.checkNumber(parameter.getFormId())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6b64\u5361\u7247\u65e0\u53c2\u6570\u914d\u7f6e\u9875\u9762\u3002", (String)"CardNewPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        StyleCss sc = new StyleCss();
        sc.setHeight("360px");
        String pageId = UUID.randomUUID().toString();
        this.getPageCache().put(CONFIGPAGEID, pageId);
        parameter.setPageId(pageId);
        parameter.getOpenStyle().setInlineStyleCss(sc);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap111");
        parameter.setCustomParam(APPID, (Object)card.getString(APPID_ID));
        String cardKey = Uuid8.generateShortUuid();
        this.getPageCache().put(CARDKEY, cardKey);
        parameter.setCustomParam(CARDID, (Object)(cardId + "&" + cardKey));
        parameter.setCustomParam(CARDCONFIG, (Object)card.getString(CARDCONFIG));
        parameter.setCustomParam("cardtemplateformid", (Object)cardTemplateFormId);
        parameter.setCustomParam("cardname", (Object)title);
        parameter.setCustomParam(TITLEIMG, (Object)titleImg);
        parameter.setCustomParam(ISSHOWTITLEAREA, model.getValue(ISSHOWTITLEAREA));
        parameter.setCustomParam("type", (Object)"addcard");
        this.getView().showForm(parameter);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXPANELAP_3});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4"});
    }

    private void finish() {
        IDataModel model = this.getView().getModel();
        String cardId = this.getPageCache().get(CARDID);
        String cardKey = Uuid8.generateShortUuid();
        String title = (String)model.getValue(TITLE);
        String label = (String)model.getValue(LABEL);
        String isShowTitleArea = (String)model.getValue(ISSHOWTITLEAREA);
        String titleImgUrl = (String)model.getValue(TITLEIMGURL);
        DynamicObject card = BusinessDataServiceHelper.loadSingle((Object)cardId, (String)BOS_DEVP_ENTITY);
        String cardTemplate = card.getString(FORMID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (title.equals(card.getLocaleString("name").getLocaleValue_zh_CN()) && label.equals(card.getString(LABEL)) && isShowTitleArea.equals(card.get(ISSHOWTITLEAREA)) && titleImgUrl.equals(card.getString(TITLEIMG))) {
            map.put(ISNEWPERSONALCARD, false);
        } else {
            DynamicObject personalCard = BusinessDataServiceHelper.newDynamicObject((String)"bos_card_personalcard");
            personalCard.set("userid", (Object)Long.parseLong(RequestContext.get().getUserId()));
            personalCard.set(NUMBER, model.getValue(NUMBER));
            personalCard.set("name", (Object)title);
            personalCard.set(FORMID, (Object)cardTemplate);
            personalCard.set("type", (Object)card.getString("type"));
            personalCard.set(CARDCONFIG, (Object)card.getString(CARDCONFIG));
            personalCard.set(ENTITYID, (Object)card.getString(ENTITYID));
            personalCard.set(LABEL, (Object)label);
            personalCard.set(APPID, (Object)card.getString(APPID_ID));
            personalCard.set(TITLEIMG, (Object)titleImgUrl);
            personalCard.set(ISSHOWTITLEAREA, (Object)isShowTitleArea);
            personalCard.set(CARDKEY, (Object)cardKey);
            DynamicObject[] personalCards = new DynamicObject[]{personalCard};
            SaveServiceHelper.save((DynamicObject[])personalCards);
            map.put(ISNEWPERSONALCARD, true);
        }
        map.put("cardtemplate", cardTemplate);
        map.put(CARDSIZE, model.getValue(CARDSIZE));
        map.put(CARDID, cardId + "&" + cardKey);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private void step4last() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u521a\u914d\u7f6e\u7684\u5361\u7247\u914d\u7f6e\u4fe1\u606f\u5c06\u6e05\u7a7a\uff01", (String)"CardNewPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        String pageId = this.getPageCache().get(CONFIGPAGEID);
        this.getPageCache().remove(CONFIGPAGEID);
        if (pageId != null) {
            HashMap<String, String> pageIds = new HashMap<String, String>();
            pageIds.put(PAGE_ID, pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", pageIds);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEXPANELAP_3});
    }

    private void publish() {
        IDataModel model = this.getView().getModel();
        String cardId = this.getPageCache().get(CARDID);
        String cardKey = this.getPageCache().get(CARDKEY);
        DynamicObject card = BusinessDataServiceHelper.loadSingle((Object)cardId, (String)BOS_DEVP_ENTITY);
        DynamicObject personalCard = BusinessDataServiceHelper.newDynamicObject((String)"bos_card_personalcard");
        String cardTemplate = card.getString(FORMID);
        IFormView view = this.getView().getView(this.getPageCache().get(CONFIGPAGEID));
        List list = ((FormViewPluginProxy)view.getService(FormViewPluginProxy.class)).getPlugIns();
        if (!(list.get(0) instanceof ICardConfig)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5361\u7247\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u8bfb\u53d6\u5931\u8d25\u3002", (String)"CardNewPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ICardConfig iCardConfig = (ICardConfig)list.get(0);
        JSONObject configInfo = iCardConfig.getCardConfigInfo();
        personalCard.set(CARDCONFIG, (Object)configInfo.toJSONString());
        personalCard.set("userid", (Object)Long.parseLong(RequestContext.get().getUserId()));
        personalCard.set(NUMBER, model.getValue(NUMBER));
        personalCard.set("name", model.getValue(TITLE));
        personalCard.set(FORMID, (Object)cardTemplate);
        personalCard.set("type", (Object)card.getString("type"));
        personalCard.set(ENTITYID, (Object)card.getString(ENTITYID));
        personalCard.set(LABEL, model.getValue(LABEL));
        personalCard.set(APPID, (Object)card.getString(APPID_ID));
        personalCard.set(TITLEIMG, model.getValue(TITLEIMGURL));
        personalCard.set(ISSHOWTITLEAREA, model.getValue(ISSHOWTITLEAREA));
        personalCard.set(CARDKEY, (Object)cardKey);
        DynamicObject[] personalCards = new DynamicObject[]{personalCard};
        SaveServiceHelper.save((DynamicObject[])personalCards);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ISNEWPERSONALCARD, true);
        map.put(CARDSIZE, model.getValue(CARDSIZE));
        map.put("cardtemplate", cardTemplate);
        map.put(CARDID, cardId + "&" + cardKey);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private void selectImg() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "selectImgCloseCallBack");
        parameter.setCloseCallBack(ccb);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map ret;
        super.closedCallBack(e);
        if ("selectImgCloseCallBack".equals(e.getActionId()) && (ret = (Map)e.getReturnData()) != null) {
            String titleImg = (String)ret.get("value");
            Image image = (Image)this.getControl(TITLEIMG);
            image.setUrl(titleImg);
            this.getModel().setValue(TITLEIMGURL, (Object)titleImg);
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        if ("tabpageap".equals(tabKey)) {
            this.getPageCache().put("type", CARDTYPE);
        } else if ("tabpageap1".equals(tabKey)) {
            this.getPageCache().put("type", "bizapp");
        }
    }
}

