/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;

public class GalaxyAccountInitialPlugin
extends AbstractFormPlugin {
    private static final String INITIAL_ACOUNT = "initalacounts";
    private static final long ROOT_ORG_ID = 100000L;

    public void initialize() {
        int isInitailAcount;
        if (RunModeServiceHelper.isGalaxyMode() && (isInitailAcount = this.getInitalAcount()) == 0) {
            this.initialAcount();
        }
    }

    private int getInitalAcount() {
        int initial = 0;
        String initialAcount = this.getPageCache().get(INITIAL_ACOUNT);
        if (StringUtils.isEmpty((String)initialAcount)) {
            DynamicObject paramObj = ParameterReader.getSystemParameter(null, (String)"83bfebc8000037ac", (long)100000L, (long)0L);
            if (paramObj == null) {
                return 0;
            }
            return paramObj.getInt(INITIAL_ACOUNT);
        }
        initial = Integer.parseInt(initialAcount);
        return initial;
    }

    private void initialAcount() {
        this.saveOrgManageMode(1);
        this.getPageCache().put("orgmanagemode", Integer.toString(1));
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
        paramMap.put(INITIAL_ACOUNT, 1);
        SystemParamServiceHelper.saveAppParameter((String)"15", (Long)100000L, (Long)0L, (String)"83bfebc8000037ac", paramMap);
        this.getPageCache().put(INITIAL_ACOUNT, String.valueOf(1));
        this.updateOrg();
    }

    public void updateOrg() {
        String selectFields = "id,number,name";
        QFilter orgIdFilter = new QFilter("id", "=", (Object)100000L);
        DynamicObject orgObjArr = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)selectFields, (QFilter[])new QFilter[]{orgIdFilter});
        if (orgObjArr == null) {
            return;
        }
        String orgName = this.getAccountName();
        orgObjArr.set("name", (Object)orgName);
        orgObjArr.set("number", (Object)"100");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orgObjArr});
        selectFields = "id,fullname,longnumber";
        DynamicObject[] orgStcObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)100000L)});
        if (orgStcObjArr == null || orgStcObjArr.length == 0) {
            return;
        }
        for (DynamicObject orgStrc : orgStcObjArr) {
            orgStrc.set("fullname", (Object)orgName);
            orgStrc.set("longnumber", (Object)100);
        }
        SaveServiceHelper.save((DynamicObject[])orgStcObjArr);
    }

    private String getAccountName() {
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        if (account != null) {
            return account.getAccountName();
        }
        return "";
    }

    private void saveOrgManageMode(int orgManageMode) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("orgmanagemode", Integer.toString(orgManageMode));
        paramMap.put("showcontent", "1,2,3,4");
        SystemParamServiceHelper.saveAppParameter((String)"15", (Long)ParameterOrgUtils.getParamRootOrgId(), (Long)0L, null, paramMap);
    }
}

