/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.TimeZoneLocationEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.IInteService;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class MobilMultipleTimeZonePlugin
extends AbstractMobFormPlugin {
    public static final String INT_USERTIMEZONE = "int_usertimezone";
    public static final String INTE_TIMEZONE = "inte_timezone";
    public static final String NUMBER = "number";
    public static final String ID_NUMBER = "id, number";
    private static Log logger;
    private static final String timeZoneGroupSetStr = "UTC%Atlantic/Reykjavik%Africa/Abidjan%UCT%Africa/Monrovia%Atlantic/St_Helena%Zulu%Iceland%Etc/Greenwich%Africa/Ouagadougou%Etc/Universal%Etc/GMT0%Africa/Bamako%Etc/GMT%Africa/Dakar%Africa/Timbuktu%Africa/Accra%Africa/Conakry%Etc/UTC%Universal%Etc/UCT%Africa/Lome%GMT0%Africa/Freetown%Etc/Zulu%GMT%Africa/Sao_Tome%Greenwich%Africa/Nouakchott%Etc/GMT-0%Etc/GMT+0%Africa/Banjul%America/Danmarkshavn%Africa/Bissau&Atlantic/Bermuda%America/Halifax%America/Thule%America/Moncton%Canada/Atlantic%America/Goose_Bay%America/Glace_Bay&Cuba%America/Havana&America/St_Johns%CNT%Canada/Newfoundland&America/Mazatlan%Mexico/BajaSur%America/Chihuahua&SystemV/MST7MDT&Asia/Vientiane%Asia/Ho_Chi_Minh%Asia/Tomsk%Asia/Phnom_Penh%Asia/Jakarta%Asia/Hovd%Asia/Barnaul%Asia/Krasnoyarsk%Asia/Pontianak%Asia/Bangkok%Asia/Saigon%Asia/Novosibirsk%VST%Asia/Novokuznetsk%Indian/Christmas%Etc/GMT-7%Antarctica/Davis&America/Indianapolis%Canada/Eastern%America/Iqaluit%America/Port-au-Prince%America/Nipigon%America/Indiana/Vevay%America/Indiana/Winamac%America/Fort_Wayne%EST5EDT%America/Kentucky/Monticello%US/East-Indiana%America/Thunder_Bay%America/Grand_Turk%America/Kentucky/Louisville%America/Pangnirtung%America/New_York%America/Indiana/Petersburg%America/Toronto%America/Indiana/Marengo%US/Michigan%America/Indiana/Vincennes%America/Nassau%America/Indiana/Indianapolis%America/Louisville%IET%US/Eastern%America/Montreal%America/Detroit&Chile/EasterIsland%Pacific/Easter&Pacific/Marquesas&Africa/Lubumbashi%ART%Egypt%Africa/Lusaka%Africa/Harare%Europe/Kaliningrad%Africa/Gaborone%Africa/Maputo%Libya%Africa/Kigali%Africa/Cairo%Africa/Windhoek%Africa/Mbabane%Africa/Khartoum%Africa/Johannesburg%CAT%Africa/Bujumbura%Etc/GMT-2%Africa/Tripoli%Africa/Blantyre%Africa/Maseru&Europe/Kiev%Europe/Bucharest%Europe/Uzhgorod%Europe/Zaporozhye%Europe/Helsinki%Asia/Nicosia%Europe/Sofia%Europe/Mariehamn%Europe/Tallinn%Europe/Vilnius%EET%Europe/Nicosia%Europe/Athens%Asia/Famagusta%Europe/Riga&Australia/LHI%Australia/Lord_Howe&PRC%CTT%Singapore%Hongkong%Asia/Taipei%Asia/Hong_Kong%Asia/Ulan_Bator%Asia/Manila%Asia/Ujung_Pandang%Asia/Irkutsk%Asia/Harbin%Asia/Kuching%Asia/Chongqing%Australia/Perth%Asia/Ulaanbaatar%Asia/Kuala_Lumpur%Asia/Chungking%Asia/Macao%Asia/Shanghai%Antarctica/Casey%Asia/Brunei%Asia/Macau%Asia/Choibalsan%Australia/West%Asia/Singapore%Etc/GMT-8%Asia/Makassar&Pacific/Tongatapu%Pacific/Enderbury%Pacific/Fakaofo%Etc/GMT-13&SystemV/CST6CDT&Australia/Eucla&Europe/Belfast%WET%Europe/Dublin%Portugal%Europe/Isle_of_Man%Europe/Lisbon%Europe/Jersey%Eire%Europe/London%Europe/Guernsey%Atlantic/Faeroe%Atlantic/Madeira%GB%GB-Eire%Atlantic/Canary%Atlantic/Faroe&Asia/Kabul&Pacific/Norfolk&Pacific/Galapagos%America/Costa_Rica%America/Guatemala%America/Managua%America/Tegucigalpa%Canada/Saskatchewan%America/Belize%America/Regina%Etc/GMT+6%America/El_Salvador%America/Swift_Current%SystemV/CST6&Asia/Beirut&Australia/Adelaide%Australia/South%Australia/Broken_Hill%Australia/Yancowinna&Etc/GMT+12&SystemV/YST9YDT&ACT%Australia/North%Australia/Darwin&Asia/Hebron%Asia/Gaza&Asia/Tehran%Iran&Asia/Calcutta%IST%Asia/Kolkata%Asia/Colombo&Pacific/Apia%MIT&America/Godthab&Asia/Damascus&Asia/Anadyr%Pacific/Wake%Pacific/Majuro%Pacific/Funafuti%Pacific/Nauru%Etc/GMT-12%Pacific/Tarawa%Asia/Kamchatka%Kwajalein%Pacific/Wallis%Pacific/Kwajalein&Pacific/Honolulu%Pacific/Rarotonga%Etc/GMT+10%Pacific/Tahiti%HST%US/Hawaii%Pacific/Johnston%SystemV/HST10&Pacific/Fiji&America/Miquelon&America/Inuvik%America/Yellowknife%America/Shiprock%America/Denver%US/Mountain%America/Edmonton%Canada/Mountain%America/Cambridge_Bay%Navajo%America/Ojinaga%America/Boise%MST7MDT&Etc/GMT+9%SystemV/YST9%Pacific/Gambier&US/Aleutian%America/Adak%America/Atka&Europe/Ljubljana%Europe/Rome%Atlantic/Jan_Mayen%Europe/Berlin%Africa/Ceuta%Europe/Zurich%Europe/Oslo%Europe/Amsterdam%Poland%Europe/Stockholm%Europe/Vatican%Europe/Budapest%Europe/Gibraltar%Europe/Bratislava%Europe/San_Marino%Europe/Madrid%Europe/Zagreb%Europe/Copenhagen%Europe/Malta%Europe/Brussels%Europe/Vienna%Europe/Busingen%Europe/Vaduz%Europe/Warsaw%Europe/Prague%CET%Europe/Skopje%Europe/Podgorica%Europe/Paris%ECT%Europe/Sarajevo%Europe/Tirane%Europe/Luxembourg%Europe/Andorra%Europe/Belgrade%MET%Arctic/Longyearbyen%Europe/Monaco&Indian/Mahe%Indian/Mauritius%Indian/Reunion%Europe/Astrakhan%Asia/Yerevan%Europe/Ulyanovsk%Asia/Dubai%Asia/Muscat%Asia/Tbilisi%Europe/Saratov%Europe/Samara%Europe/Volgograd%Etc/GMT-4%NET%Asia/Baku&Pacific/Efate%Asia/Magadan%Antarctica/Macquarie%Etc/GMT-11%Pacific/Bougainville%Asia/Srednekolymsk%Pacific/Pohnpei%Pacific/Noumea%SST%Pacific/Ponape%Pacific/Guadalcanal%Pacific/Kosrae%Asia/Sakhalin&SystemV/PST8PDT&Chile/Continental%America/Santiago&Pacific/Pago_Pago%Pacific/Midway%Pacific/Niue%Pacific/Samoa%Etc/GMT+11%US/Samoa&America/Caracas%America/Cuiaba%America/Dominica%America/Guadeloupe%America/St_Barthelemy%America/Curacao%America/La_Paz%America/Marigot%America/Blanc-Sablon%America/Guyana%America/Martinique%America/Campo_Grande%Brazil/West%America/St_Thomas%PRT%America/Boa_Vista%America/St_Vincent%America/Aruba%America/Anguilla%America/Puerto_Rico%America/Grenada%America/Tortola%America/Virgin%America/Porto_Velho%America/Manaus%America/St_Lucia%America/Port_of_Spain%America/Montserrat%America/Barbados%America/Kralendijk%America/Antigua%America/Santo_Domingo%America/Lower_Princes%America/St_Kitts%Etc/GMT+4%SystemV/AST4&Asia/Aden%Asia/Qatar%Africa/Nairobi%Antarctica/Syowa%Asia/Riyadh%Africa/Juba%Europe/Moscow%Asia/Bahrain%Africa/Mogadishu%Africa/Dar_es_Salaam%Asia/Baghdad%Asia/Kuwait%Africa/Addis_Ababa%Asia/Istanbul%Africa/Djibouti%Europe/Kirov%Africa/Asmara%Africa/Asmera%Europe/Simferopol%Indian/Antananarivo%Africa/Kampala%Indian/Mayotte%W-SU%Turkey%Europe/Istanbul%EAT%Etc/GMT-3%Indian/Comoro%Europe/Minsk&Antarctica/McMurdo%NZ%Antarctica/South_Pole%Pacific/Auckland%NST&Africa/El_Aaiun%Africa/Casablanca&America/Asuncion&America/Scoresbysund%Atlantic/Azores&Asia/Aqtobe%Asia/Samarkand%Indian/Kerguelen%Asia/Oral%Asia/Ashgabat%Asia/Dushanbe%Asia/Aqtau%Asia/Ashkhabad%Asia/Tashkent%Antarctica/Mawson%Asia/Karachi%Etc/GMT-5%Asia/Yekaterinburg%Asia/Atyrau%PLT%Indian/Maldives%Asia/Qyzylorda&America/Argentina/San_Juan%America/Cordoba%America/Sao_Paulo%America/Argentina/Ushuaia%America/Mendoza%America/Santarem%America/Belem%America/Montevideo%America/Argentina/ComodRivadavia%America/Jujuy%America/Fortaleza%Brazil/East%America/Argentina/La_Rioja%America/Recife%America/Buenos_Aires%Antarctica/Palmer%America/Bahia%America/Argentina/Jujuy%America/Maceio%America/Argentina/Tucuman%America/Argentina/Cordoba%America/Paramaribo%America/Argentina/Mendoza%AGT%America/Punta_Arenas%BET%America/Argentina/Rio_Gallegos%America/Cayenne%America/Araguaina%Antarctica/Rothera%America/Argentina/Buenos_Aires%America/Catamarca%America/Argentina/Salta%Etc/GMT+3%Atlantic/Stanley%America/Argentina/San_Luis%America/Rosario%America/Argentina/Catamarca&US/Pacific-New%America/Tijuana%America/Santa_Isabel%Canada/Yukon%Canada/Pacific%PST%America/Los_Angeles%America/Whitehorse%America/Ensenada%America/Dawson%PST8PDT%America/Vancouver%US/Pacific%Mexico/BajaNorte&Atlantic/South_Georgia%Brazil/DeNoronha%Etc/GMT+2%America/Noronha&Asia/Katmandu%Asia/Kathmandu&AET%Australia/Sydney%Australia/Melbourne%Australia/Hobart%Australia/Victoria%Australia/Canberra%Australia/NSW%Australia/ACT%Australia/Tasmania%Australia/Currie&Africa/Lagos%Africa/Brazzaville%Africa/Libreville%Africa/Porto-Novo%Africa/Luanda%Africa/Douala%Africa/Niamey%Africa/Algiers%Etc/GMT-1%Africa/Malabo%Africa/Ndjamena%Africa/Tunis%Africa/Bangui%Africa/Kinshasa&Etc/GMT+8%Pacific/Pitcairn%SystemV/PST8&Asia/Jerusalem%Asia/Tel_Aviv%Israel&America/Monterrey%America/Merida%America/Mexico_City%America/Bahia_Banderas%Mexico/General&America/Indiana/Tell_City%America/Menominee%CST%America/Matamoros%America/Resolute%US/Central%America/North_Dakota/New_Salem%US/Indiana-Starke%America/Chicago%America/North_Dakota/Center%America/Winnipeg%Canada/Central%America/Rankin_Inlet%America/Indiana/Knox%America/Rainy_River%America/North_Dakota/Beulah%CST6CDT%America/Knox_IN&Asia/Amman&Europe/Tiraspol%Europe/Chisinau&SystemV/AST4ADT&BST%Asia/Dacca%Asia/Thimbu%Asia/Omsk%Asia/Qostanay%Asia/Almaty%Asia/Dhaka%Indian/Chagos%Asia/Kashgar%Asia/Urumqi%Antarctica/Vostok%Asia/Bishkek%Asia/Thimphu%Etc/GMT-6&Pacific/Chatham%NZ-CHAT&Asia/Tokyo%Asia/Jayapura%Japan%JST%Pacific/Palau%ROK%Asia/Pyongyang%Asia/Yakutsk%Asia/Dili%Asia/Khandyga%Etc/GMT-9%Asia/Chita%Asia/Seoul&Pacific/Kiritimati%Etc/GMT-14&America/Anchorage%America/Yakutat%AST%America/Sitka%America/Metlakatla%America/Juneau%US/Alaska%America/Nome&Asia/Yangon%Indian/Cocos%Asia/Rangoon&America/Dawson_Creek%US/Arizona%PNT%America/Hermosillo%SystemV/MST7%Etc/GMT+7%America/Fort_Nelson%America/Phoenix%MST%America/Creston&SystemV/EST5EDT&Pacific/Port_Moresby%Asia/Vladivostok%Pacific/Saipan%Asia/Ust-Nera%Antarctica/DumontDUrville%Etc/GMT-10%Pacific/Truk%Australia/Lindeman%Pacific/Chuuk%Australia/Brisbane%Pacific/Guam%Pacific/Yap%Australia/Queensland&Atlantic/Cape_Verde%Etc/GMT+1&Antarctica/Troll&America/Lima%America/Bogota%EST%America/Porto_Acre%America/Guayaquil%Brazil/Acre%America/Coral_Harbour%SystemV/EST5%America/Jamaica%America/Eirunepe%America/Cayman%America/Cancun%America/Panama%America/Atikokan%America/Rio_Branco%Jamaica%Etc/GMT+5";
    private static final List<Set<String>> timeZoneGroupSet;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((IMobileView)this.getView()).timeZoneLocate();
    }

    public void timeZoneLocate(TimeZoneLocationEvent e) {
        String num = e.getTimeZoneNum();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String clientType = RequestContext.get().getClient();
        if (!"mobile".equals(clientType)) {
            return;
        }
        long nowTimestamp = System.currentTimeMillis();
        String equalNum = this.getOneselfOrEqualTimeZoneNum(num, nowTimestamp);
        if (StringUtils.isBlank((String)equalNum)) {
            String message = String.format(ResManager.loadKDString((String)"\u65f6\u533a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0:%s", (String)"MobilMultipleTimeZonePlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]), num);
            this.getView().showConfirm(message, MessageBoxOptions.None);
            return;
        }
        boolean isSame = this.isSameMobileTimeZone(equalNum, userId, nowTimestamp);
        logger.info(String.format("MobilMultipleTimeZonePlugin timeZoneLocate method: userId: %s , num: %s,, equalNum: %s, clientType:%s, isSame:%s", userId, num, equalNum, clientType, isSame));
        StringBuilder sb = new StringBuilder("clickOk|");
        sb.append(equalNum).append('|').append(userId);
        if (!isSame) {
            String message = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u65f6\u533a\u4e3a%s\uff0c\u662f\u5426\u5207\u6362\u4e3a\u8be5\u65f6\u533a\uff1f", (String)"MobilMultipleTimeZonePlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]), MobilMultipleTimeZonePlugin.getGMTInfoFromNum(num));
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(sb.toString(), (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key = e.getCallBackId();
        String resultKey = e.getResultValue();
        if (key != null) {
            if ("Cancel".equals(resultKey)) {
                return;
            }
            String callBackId = e.getCallBackId();
            if (StringUtils.isBlank((String)callBackId)) {
                return;
            }
            String[] param = callBackId.split("\\|");
            if (param.length < 3) {
                return;
            }
            String num = param[1];
            String userIdStr = param[2];
            Long userId = Long.parseLong(userIdStr);
            this.saveMobileTimeZone(num, userId);
        }
    }

    public boolean isSameMobileTimeZone(String equalNum, Long userId, long nowTimestamp) {
        if (StringUtils.isBlank((String)equalNum)) {
            return true;
        }
        if (Objects.isNull(userId)) {
            return true;
        }
        boolean isSameMobileTimeZone = false;
        logger.info(String.format("isSameMobileTimeZone userId:%s , equalNum:%s", userId, equalNum));
        String selectFields = "id, user, timezone, mobiletimezone";
        QFilter userIdFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userIdFilter};
        DynamicObject userTimeZoneObject = BusinessDataServiceHelper.loadSingleFromCache((String)"inte_usertimezone", (String)selectFields, (QFilter[])filters);
        if (Objects.isNull(userTimeZoneObject)) {
            this.saveMobileTimeZone(equalNum, userId);
            return true;
        }
        DynamicObject mobileTimeZone = userTimeZoneObject.getDynamicObject("mobiletimezone");
        if (Objects.isNull(mobileTimeZone)) {
            this.saveMobileTimeZone(equalNum, userId);
            return true;
        }
        String userMobileTimeZoneId = mobileTimeZone.getString("id");
        String userNum = this.getTimeZoneNum(userMobileTimeZoneId);
        if (this.judeTimeZoneIsEquals(equalNum, userNum, nowTimestamp)) {
            return true;
        }
        return isSameMobileTimeZone;
    }

    public static String getGMTInfoFromNum(String num) {
        StringBuilder sb = new StringBuilder("GMT");
        TimeZone timeZone = TimeZone.getTimeZone(num);
        int rawOffset = timeZone.getRawOffset();
        int absOffset = Math.abs(rawOffset);
        int hour = absOffset / 3600000;
        int minute = absOffset % 3600000 / 60000;
        if (rawOffset >= 0) {
            sb.append('+');
        } else {
            sb.append('-');
        }
        sb.append(MobilMultipleTimeZonePlugin.clipTime(hour)).append(':').append(MobilMultipleTimeZonePlugin.clipTime(minute));
        return sb.toString();
    }

    public static String clipTime(int val) {
        String strVal = String.valueOf(val);
        if (strVal.length() == 0) {
            return "00";
        }
        if (strVal.length() == 1) {
            return "0" + strVal;
        }
        if (strVal.length() >= 2) {
            return strVal.substring(strVal.length() - 2, strVal.length());
        }
        return strVal;
    }

    private String getOneselfOrEqualTimeZoneNum(String num, long nowTimestamp) {
        String timeZoneId = this.getTimeZone(num);
        if (StringUtils.isBlank((String)timeZoneId)) {
            String targetNum = this.getEqualTimeZoneNum(num, nowTimestamp);
            if (StringUtils.isBlank((String)targetNum)) {
                return "";
            }
            return targetNum;
        }
        return num;
    }

    private String getEqualTimeZoneNum(String sourceNum, long nowTimestamp) {
        TimeZone targetTz;
        int targetTzOffset;
        TimeZone sourceTz = TimeZone.getTimeZone(sourceNum);
        if (sourceTz.getID().equals("GMT") && !"GMT".equals(sourceNum)) {
            return "";
        }
        int sourceTzRawOffset = sourceTz.getRawOffset();
        int sourceTzOffset = sourceTz.getOffset(nowTimestamp);
        QFilter enableTimezone = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter[] filterIntTimeZone = new QFilter[]{enableTimezone};
        Map map = BusinessDataServiceHelper.loadFromCache((String)INTE_TIMEZONE, (QFilter[])filterIntTimeZone);
        HashSet rawOffsetEqualIdSet = new HashSet(16);
        HashSet rawOffsetNotEqualIdSet = new HashSet(128);
        HashSet enableTimeZoneNumSet = new HashSet(128);
        map.forEach((key, val) -> {
            String id = val.getString(NUMBER);
            TimeZone timeZone = TimeZone.getTimeZone(id);
            if (sourceTzRawOffset == timeZone.getRawOffset()) {
                rawOffsetEqualIdSet.add(id);
            } else {
                rawOffsetNotEqualIdSet.add(id);
            }
            enableTimeZoneNumSet.add(id);
        });
        Set<String> equalGroup = null;
        for (Set<String> set : timeZoneGroupSet) {
            if (!set.contains(sourceNum)) continue;
            equalGroup = set;
        }
        if (equalGroup != null) {
            for (String id : equalGroup) {
                if (!enableTimeZoneNumSet.contains(id) || (targetTzOffset = (targetTz = TimeZone.getTimeZone(id)).getOffset(nowTimestamp)) != sourceTzOffset) continue;
                return id;
            }
        }
        for (String id : rawOffsetEqualIdSet) {
            targetTz = TimeZone.getTimeZone(id);
            targetTzOffset = targetTz.getOffset(nowTimestamp);
            if (targetTzOffset != sourceTzOffset) continue;
            return id;
        }
        for (String id : rawOffsetNotEqualIdSet) {
            targetTz = TimeZone.getTimeZone(id);
            targetTzOffset = targetTz.getOffset(nowTimestamp);
            if (targetTzOffset != sourceTzOffset) continue;
            return id;
        }
        return "";
    }

    private boolean judeTimeZoneIsEquals(String frontNum, String userTimeNum, long nowTimestamp) {
        Integer userTimeNumTZOffset;
        TimeZone frontTZ = TimeZone.getTimeZone(frontNum);
        TimeZone userTimeNumTZ = TimeZone.getTimeZone(userTimeNum);
        if (Objects.isNull(frontTZ) || Objects.isNull(userTimeNumTZ)) {
            return false;
        }
        Integer frontTZOffset = frontTZ.getOffset(nowTimestamp);
        return Objects.equals(frontTZOffset, userTimeNumTZOffset = Integer.valueOf(userTimeNumTZ.getOffset(nowTimestamp)));
    }

    private String getTimeZoneNum(String timeZoneId) {
        String selectFieldIntTimeZone = ID_NUMBER;
        QFilter userIdFilterIntTimeZone = new QFilter("id", "=", (Object)Long.parseLong(timeZoneId));
        QFilter[] filterIntTimeZone = new QFilter[]{userIdFilterIntTimeZone};
        DynamicObject mobileTimeZoneObject = BusinessDataServiceHelper.loadSingle((String)INTE_TIMEZONE, (String)selectFieldIntTimeZone, (QFilter[])filterIntTimeZone);
        if (Objects.isNull(mobileTimeZoneObject)) {
            return "";
        }
        return mobileTimeZoneObject.getString(NUMBER);
    }

    private String getTimeZone(String num) {
        String selectFieldIntTimeZone = ID_NUMBER;
        QFilter userIdFilterIntTimeZone = new QFilter(NUMBER, "=", (Object)num);
        QFilter enableFilterIntTimezone = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter[] filterIntTimeZone = new QFilter[]{userIdFilterIntTimeZone, enableFilterIntTimezone};
        DynamicObject mobileTimeZoneObject = BusinessDataServiceHelper.loadSingle((String)INTE_TIMEZONE, (String)selectFieldIntTimeZone, (QFilter[])filterIntTimeZone);
        if (Objects.isNull(mobileTimeZoneObject)) {
            return "";
        }
        return mobileTimeZoneObject.getString("id");
    }

    private DynamicObject getTimeZoneDynamicObject(String num) {
        String selectFieldIntTimeZone = ID_NUMBER;
        QFilter userIdFilterIntTimeZone = new QFilter(NUMBER, "=", (Object)num);
        QFilter[] filterIntTimeZone = new QFilter[]{userIdFilterIntTimeZone};
        DynamicObject mobileTimeZoneObject = BusinessDataServiceHelper.loadSingle((String)INTE_TIMEZONE, (String)selectFieldIntTimeZone, (QFilter[])filterIntTimeZone);
        return mobileTimeZoneObject;
    }

    public void saveMobileTimeZone(String num, Long userId) {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        DynamicObject timeZone = this.getTimeZoneDynamicObject(num);
        inteService.saveUserTimezone(userId, timeZone);
    }

    public String getTimeZone(String pcOrMobile, Long userId) {
        String timeZoneId = "";
        String selectFields = "id, user, timezone, mobiletimezone";
        QFilter userIdFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userIdFilter};
        DynamicObject userTimeZoneObject = BusinessDataServiceHelper.loadSingleFromCache((String)"inte_usertimezone", (String)selectFields, (QFilter[])filters);
        DynamicObject object = new DynamicObject();
        if (StringUtil.equals((String)pcOrMobile, (String)"PC")) {
            object = userTimeZoneObject.getDynamicObject("timezone");
        } else if (StringUtil.equals((String)pcOrMobile, (String)"mobile")) {
            object = userTimeZoneObject.getDynamicObject("mobiletimezone");
        }
        timeZoneId = object.getString("id");
        String selectFieldIntTimeZone = ID_NUMBER;
        QFilter userIdFilterIntTimeZone = new QFilter("id", "=", (Object)Long.parseLong(timeZoneId));
        QFilter[] filterIntTimeZone = new QFilter[]{userIdFilterIntTimeZone};
        DynamicObject mobileTimeZoneObject = BusinessDataServiceHelper.loadSingleFromCache((String)INTE_TIMEZONE, (String)selectFieldIntTimeZone, (QFilter[])filterIntTimeZone);
        String number = mobileTimeZoneObject.getString(NUMBER);
        return number;
    }

    static {
        String[] groupStrArray;
        logger = LogFactory.getLog(MobilMultipleTimeZonePlugin.class);
        timeZoneGroupSet = new ArrayList<Set<String>>(100);
        for (String groupStr : groupStrArray = timeZoneGroupSetStr.split("&")) {
            String[] ids = groupStr.split("%");
            HashSet<String> equalSet = new HashSet<String>(16);
            for (String id : ids) {
                equalSet.add(id);
            }
            timeZoneGroupSet.add(equalSet);
        }
    }

    static class TimeZoneGroupTest {
        private static Map<String, TimeZone> timeZoneMap;
        private static final List<Date> dateList;

        TimeZoneGroupTest() {
        }

        public static void getEqualSet() {
            String[] ids;
            ArrayList<Set<String>> timeZoneGroupSet = new ArrayList<Set<String>>(100);
            for (String string : ids = TimeZone.getAvailableIDs()) {
                if (string.equals("Pacific/Norfolk")) {
                    boolean bl = false;
                }
                if (TimeZoneGroupTest.hasAddEqualSet(string, timeZoneGroupSet)) continue;
                Set<String> equalSet = TimeZoneGroupTest.getAllReplace(string);
                equalSet.add(string);
                timeZoneGroupSet.add(equalSet);
            }
            StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u5408\u6210\u5b57\u7b26\u4e32\u4e3a(timeZoneGroupSetStr):", (String)"MobilMultipleTimeZonePlugin_3", (String)"bos-portal-plugin", (Object[])new Object[0]));
            int i = 0;
            for (Set set : timeZoneGroupSet) {
                for (String s : set) {
                    ++i;
                    sb.append(s).append('%');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append('&');
            }
            sb.deleteCharAt(sb.length() - 1);
        }

        public static boolean hasAddEqualSet(String id, List<Set<String>> set) {
            for (Set<String> equalSet : set) {
                if (!equalSet.contains(id)) continue;
                return true;
            }
            return false;
        }

        public static Set<String> getAllReplace(String id) {
            HashSet<String> replaceSet = new HashSet<String>();
            timeZoneMap.forEach((key, val) -> {
                if (!key.equals(id) && TimeZoneGroupTest.isCanReplace(id, val)) {
                    replaceSet.add((String)key);
                }
            });
            return replaceSet;
        }

        public static boolean isCanReplace(String id, TimeZone targetTz) {
            TimeZone sourceTz = timeZoneMap.get(id);
            for (Date date : dateList) {
                int targetOffset;
                int sourceOffset = sourceTz.getOffset(date.getTime());
                if (sourceOffset == (targetOffset = targetTz.getOffset(date.getTime()))) continue;
                return false;
            }
            return true;
        }

        public static void main(String[] args) {
            TimeZoneGroupTest.getEqualSet();
        }

        static {
            String[] ids;
            timeZoneMap = new HashMap<String, TimeZone>();
            dateList = new ArrayList<Date>();
            for (String id : ids = TimeZone.getAvailableIDs()) {
                timeZoneMap.put(id, TimeZone.getTimeZone(id));
            }
            int max = 1051200;
            long sec = System.currentTimeMillis() / 1000L;
            for (int i = 0; i < max; ++i) {
                dateList.add(new Date(1000L * (sec + (long)(i * 60))));
            }
        }
    }
}

