/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.dbversion.VersionCaptionInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ModeTypeUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class NewAboutPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(NewAboutPlugin.class);
    private static final String COSMIC_BOS = "cosmic_bos";
    private static final String CCS_PREFIX = "constellation_";
    private static final String COSMIC_PANEL = "cosmic_panel";
    private static final String SPLIT_PANEL = "split_panel";
    private static final String CONSTELLATION_PANEL = "constellation_panel";
    private static final String C0SMIC_PRODID = "1I6COPY94UBO";
    private static final String CCS_PRODID = "1I6CUBKTC4GY";

    public void afterCreateNewData(EventObject e) {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        if (modelType == 2 || modelType == 4) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONSTELLATION_PANEL, SPLIT_PANEL, "cs_lic_v_panel"});
            this.initGalaxyData();
        } else {
            boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
            if (oemEnv || ModeTypeUtils.isEducation()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONSTELLATION_PANEL, SPLIT_PANEL});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"galaxy_panel", "galaxy_split_panel"});
            this.initData();
        }
        this.getModel().setValue("copyright", (Object)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u56fd\u9645\u8f6f\u4ef6\u96c6\u56e2\u6709\u9650\u516c\u53f8 \u7248\u6743\u6240\u6709\u00a91993-%s", (String)"AboutPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]), Calendar.getInstance().get(1)));
    }

    private void initGalaxyData() {
        Map prodMap;
        List galaxyVersions;
        IDataModel model = this.getModel();
        IndustryVersionInfo csVersion = IndustryVersionServiceHelper.getVersion((String)COSMIC_BOS, (String)"kingdee");
        if (csVersion != null) {
            model.setValue("cs_version_num", (Object)("V" + this.removeLastVersion(csVersion.getVersion())));
            model.setValue("cs_version_date", (Object)csVersion.getUpgradeTime());
        }
        if (!CollectionUtils.isEmpty((Collection)(galaxyVersions = IndustryVersionServiceHelper.getCaption((String)"kingdee", (String)"starry")))) {
            IndustryVersionInfo galaxyVersion = galaxyVersions.stream().max(NewAboutPlugin.versionComparator()).get();
            List verCaption = galaxyVersion.getVerCaption();
            if (!CollectionUtils.isEmpty((Collection)verCaption)) {
                String version = this.getStarryVersion(galaxyVersion.getVersion(), ((VersionCaptionInfo)verCaption.get(0)).getCaption());
                model.setValue("galaxy_version_num", (Object)version);
            }
            model.setValue("galaxy_version_date", (Object)galaxyVersion.getUpgradeTime());
        }
        if ((prodMap = LicenseServiceHelper.getProductInfo()) != null) {
            logger.info("license info:" + JSONObject.toJSONString((Object)prodMap));
            String data = (String)prodMap.get("expdate");
            if (this.isValidDate(data)) {
                model.setValue("cs_expdate", (Object)data);
                model.setValue("galaxy_expdate", (Object)data);
            }
        }
    }

    private static Comparator<IndustryVersionInfo> versionComparator() {
        return (o1, o2) -> {
            String ver2;
            String ver1 = o1.getVersion();
            if (ver1.equals(ver2 = o2.getVersion())) {
                return 0;
            }
            String[] verArr1 = ver1.split("\\.");
            String[] verArr2 = ver2.split("\\.");
            int maxflag = 1;
            int minLen = 0;
            if (verArr1.length > verArr2.length) {
                minLen = verArr2.length;
            } else {
                minLen = verArr1.length;
                maxflag = 2;
            }
            try {
                for (int i = 0; i < minLen; ++i) {
                    if (Integer.parseInt(verArr1[i]) - Integer.parseInt(verArr2[i]) > 0) {
                        return 1;
                    }
                    if (Integer.parseInt(verArr1[i]) - Integer.parseInt(verArr2[i]) >= 0) continue;
                    return -1;
                }
                if (maxflag == 1) {
                    for (int j = minLen; j < verArr1.length; ++j) {
                        if (Integer.parseInt(verArr1[j]) <= 0) continue;
                        return 1;
                    }
                } else {
                    for (int k = minLen; k < verArr2.length; ++k) {
                        if (Integer.parseInt(verArr2[k]) <= 0) continue;
                        return -1;
                    }
                }
            }
            catch (Exception e) {
                logger.info("versionComparator error", (Object)e);
            }
            return 0;
        };
    }

    public void afterBindData(EventObject evt) {
        Lang lang = RequestContext.get().getLang();
        Image logo = (Image)this.getControl("logo");
        if (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang)) {
            logo.setUrl("/images/pc/other/gycp_logo_112_40.png");
        } else {
            logo.setUrl("/images/pc/other/gycp_logo_85_40.png");
        }
    }

    private void initData() {
        IDataModel model = this.getModel();
        List<Version> versions = VersionService.getVersionInfos();
        ArrayList<String> products = new ArrayList<String>(versions.size());
        for (Version version : versions) {
            if (COSMIC_BOS.equals(version.getProductNumber())) {
                model.setValue("cs_version_num", (Object)("V" + this.removeLastVersion(version.getVersion())));
                model.setValue("cs_version_date", (Object)version.getUpgradeTime());
                products.add(COSMIC_BOS);
                continue;
            }
            if (!version.getProductNumber().startsWith(CCS_PREFIX)) continue;
            model.setValue("ccs_version_num", (Object)("V" + this.removeLastVersion(version.getVersion())));
            model.setValue("ccs_version_date", (Object)version.getUpgradeTime());
            products.add(CCS_PREFIX);
        }
        if (!products.contains(COSMIC_BOS) && products.contains(CCS_PREFIX)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{COSMIC_PANEL, SPLIT_PANEL});
        }
        if (!products.contains(CCS_PREFIX)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONSTELLATION_PANEL, SPLIT_PANEL});
        }
        boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
        String cosmicProdid = C0SMIC_PRODID;
        if (oemEnv) {
            cosmicProdid = "20240529000191801";
            Label label = (Label)this.getControl("cs_version_labelap");
            label.setText(ResManager.loadKDString((String)"OEM\u7248\u672c\u53f7", (String)"NewAboutPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
        }
        List prodMaps = LicenseServiceHelper.getProductInfos();
        logger.info("license info:" + JSONObject.toJSONString((Object)prodMaps));
        this.setLicenseVersionAndExpdate(prodMaps, cosmicProdid, "cs_lic_version_num", "cs_expdate", "cs_unlimited");
        this.setLicenseVersionAndExpdate(prodMaps, CCS_PRODID, "ccs_lic_version_num", "ccs_expdate", "ccs_unlimited");
    }

    private void setLicenseVersionAndExpdate(List<Map<String, String>> prodMaps, String prodId, String versionKey, String dateKey, String unlimitedKey) {
        if (CollectionUtils.isEmpty(prodMaps)) {
            return;
        }
        IDataModel model = this.getModel();
        Optional<Map> cosmicOptional = prodMaps.stream().filter(map -> prodId.equals(map.get("prodid"))).findFirst();
        if (cosmicOptional.isPresent()) {
            Map prodMap = cosmicOptional.get();
            String licVersion = (String)prodMap.get("productversion");
            model.setValue(versionKey, (Object)("V" + licVersion));
            String expdate = (String)prodMap.get("expdateDes");
            if (this.isValidDate(expdate)) {
                model.setValue(dateKey, (Object)expdate);
            } else {
                model.setValue(unlimitedKey, (Object)expdate);
            }
        }
    }

    private String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }

    private boolean isValidDate(String value) {
        if (value == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sdf.parse(value);
        }
        catch (Exception e) {
            logger.info("dataformate error, value:" + value, (Object)e);
            return false;
        }
        return true;
    }

    private String getStarryVersion(String ccsVersion, String starryVersion) {
        String[] split = ccsVersion.split("\\.");
        if (split.length >= 3) {
            return starryVersion + "." + split[2];
        }
        return starryVersion;
    }
}

