/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.ICardCustomFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.StringUtils;

public class NumberStatisticsCardPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final String STATISTICNUM = "statisticnum";
    public static final String SEARCHSCHEMA = "searchschema";
    public static final String SCENE = "scene";
    public static final String PERVIEWINTIME = "perviewintime";
    public static final String BIZAPP = "bizapp";
    private static Log logger = LogFactory.getLog(NumberStatisticsCardPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{STATISTICNUM, "cardtitle", SEARCHSCHEMA, "content"});
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String scene = (String)formShowParameter.getCustomParam(SCENE);
        if (PERVIEWINTIME.equals(scene)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{STATISTICNUM, SEARCHSCHEMA});
        }
        JSONObject cardInfo = JSONObject.parseObject((String)this.getPageCache().get("cardinfo"));
        this.initialCard(cardInfo);
    }

    public void click(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String scene = (String)formShowParameter.getCustomParam(SCENE);
        Control control = (Control)e.getSource();
        if ("cardmanage".equals(scene)) {
            return;
        }
        switch (control.getKey()) {
            case "statisticnum": 
            case "searchschema": 
            case "content": {
                this.openBillListPage();
                break;
            }
        }
    }

    public void openBillListPage() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"statisticnumnew"});
        FormShowParameter param = this.getView().getFormShowParameter();
        if ("cardmanage".equals(param.getCustomParam(SCENE)) || PERVIEWINTIME.equals(param.getCustomParam(SCENE))) {
            return;
        }
        JSONObject cardInfo = JSONObject.parseObject((String)this.getPageCache().get("cardinfo"));
        JSONObject cardConfig = cardInfo.getJSONObject("cardconfig");
        String searchSchema = cardConfig.getString(SEARCHSCHEMA);
        FilterScheme schema = this.getFilterSchemeById(searchSchema);
        if (schema != null) {
            String appID = cardInfo.getString(BIZAPP);
            AppMetadata metadata = BizAppServiceHelp.getAppMetaByID((String)appID);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", this.getView());
            map.put("appname", metadata.getName().getLocaleValue());
            map.put("appmainnumber", "bos_devportal_apphome");
            map.put("formnumber", cardConfig.getString("entity"));
            map.put("parametertype", "ListShowParameter");
            JSONObject parameter = new JSONObject();
            parameter.put("filterSchemeId", (Object)searchSchema);
            map.put("parameter", parameter);
            OpenPageUtils.openAppTab(appID, searchSchema, map, this.getView());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"NumberStatisticsCardPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
        }
    }

    public void initialCard(JSONObject cardInfo) {
        this.initialItems(cardInfo);
    }

    private void initialItems(JSONObject cardInfo) {
        String appId = cardInfo.getString(BIZAPP) != null ? cardInfo.getString(BIZAPP) : cardInfo.getString("appid");
        JSONObject cardConfig = cardInfo.getJSONObject("cardconfig");
        if (cardConfig != null && !cardConfig.equals((Object)new JSONObject())) {
            Label searchSchemaLabel;
            String entity = cardConfig.getString("entity");
            String searchSchema = cardConfig.getString(SEARCHSCHEMA);
            String schemaName = cardConfig.getString("schemaname");
            String filterclass = cardConfig.getString("filterclass");
            Label statisticsNum = (Label)this.getControl(STATISTICNUM);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String scene = (String)formShowParameter.getCustomParam(SCENE);
            if (PERVIEWINTIME.equals(scene)) {
                if (!"".equals(schemaName) && !" ".equals(schemaName)) {
                    searchSchemaLabel = (Label)this.getControl(SEARCHSCHEMA);
                    searchSchemaLabel.setText(schemaName);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SEARCHSCHEMA});
                }
            } else {
                searchSchemaLabel = (Label)this.getControl(SEARCHSCHEMA);
                searchSchemaLabel.setText(schemaName);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SEARCHSCHEMA});
            }
            int num = 0;
            QFilter preFilter = null;
            QFilter specialDataPermFilter = PermissionFilterUtil.getSpecialDataPermissionFilter((String)appId, (String)entity, (String)"view", (ITimeService)new TimeService(), (IUserService)new UserService());
            if (specialDataPermFilter != null) {
                preFilter = preFilter == null ? specialDataPermFilter : preFilter.and(specialDataPermFilter);
            }
            QFilter customFilter = null;
            if (StringUtils.isNotEmpty((String)filterclass)) {
                try {
                    Class<?> cls = Class.forName(filterclass);
                    Method mtd = cls.getMethod("getCustomFilter", new Class[0]);
                    ICardCustomFilter cardCustomFilter = (ICardCustomFilter)cls.newInstance();
                    cardCustomFilter.setPageCache(this.getPageCache());
                    cardCustomFilter.setFormView(this.getView());
                    cardCustomFilter.setDataModel(this.getModel());
                    customFilter = (QFilter)mtd.invoke((Object)cardCustomFilter, new Object[0]);
                }
                catch (Exception e) {
                    logger.info("\u5361\u7247\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u7c7b\u53cd\u5c04\u8c03\u7528\u5931\u8d25\uff1a" + e.getLocalizedMessage(), (Object)e);
                }
            }
            preFilter = preFilter == null ? customFilter : preFilter.and(customFilter);
            try {
                if (StringUtils.isEmpty((String)searchSchema)) {
                    QFilter[] arrFilters = null;
                    arrFilters = preFilter != null ? new QFilter[]{preFilter} : new QFilter[]{};
                    num = ORM.create().count(((Object)((Object)this)).getClass().getName(), entity, arrFilters);
                } else {
                    num = FilterServiceHelper.getQFilterCount((String)searchSchema, (String)entity, (QFilter)preFilter);
                }
                statisticsNum.setText(String.valueOf(num));
                this.getPageCache().put(STATISTICNUM, String.valueOf(num));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{STATISTICNUM});
            }
            catch (Exception e) {
                statisticsNum.setText("ERR");
                this.getPageCache().put(STATISTICNUM, "ERR");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{STATISTICNUM});
            }
        }
    }

    public FilterScheme getFilterSchemeById(String schemeId) {
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme filterScheme = schemeQuery.getScheme(schemeId);
        return filterScheme;
    }
}

