/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.portal.pluginnew.common.PersonalSettingAbstract;
import kd.bos.servicehelper.user.UserServiceHelper;

public class PersonalSettingPlugin
extends PersonalSettingAbstract {
    @Override
    public boolean isNewPortal() {
        return false;
    }

    @Override
    public void initTheme(DynamicObject[] theme) {
        if (theme == null || theme.length == 0) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Map themeMap = UserServiceHelper.getUserThemeNumAndVerNew((Long)currUserId);
        String selectedNum = (String)themeMap.get("number");
        CustomControl customControl = (CustomControl)this.getControl("themecustomcontrol");
        ArrayList list = new ArrayList(theme.length);
        for (DynamicObject dynamicObject : theme) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            String number = dynamicObject.getString("number");
            LocaleString name = new LocaleString(dynamicObject.get("name").toString());
            String color = dynamicObject.getString("color");
            map.put("id", number);
            map.put("description", name);
            map.put("colorValue", color);
            boolean isSelect = false;
            if (selectedNum.equals(number)) {
                isSelect = true;
            }
            map.put("isSelected", isSelect);
            list.add(map);
        }
        customControl.setData(list);
        this.setHeadPanelColor(themeMap);
    }

    @Override
    public void userCenterDisplay() {
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        Object isEnableUserCenter = paramMap.get("isenableusercenter");
        if (StringUtils.isBlank(isEnableUserCenter) || !Boolean.parseBoolean(isEnableUserCenter.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"servicepanel"});
        }
    }

    @Override
    public void switchTheme(String args) {
        if (StringUtils.isEmpty((CharSequence)args)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        if (map.get("key") == null) {
            return;
        }
        String themeValue = map.get("key").toString();
        DynamicObject[] theme = this.getEnableThemeListSort();
        long userId = RequestContext.get().getCurrUserId();
        UserServiceHelper.setUserTheme((Long)userId, (String)themeValue);
        CustomControl customControl = (CustomControl)this.getControl("themecustomcontrol");
        ArrayList list = new ArrayList(theme.length);
        for (DynamicObject dynamicObject : theme) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            String number = dynamicObject.getString("number");
            LocaleString name = new LocaleString(dynamicObject.get("name").toString());
            String color = dynamicObject.getString("color");
            dataMap.put("id", number);
            dataMap.put("description", name);
            dataMap.put("colorValue", color);
            boolean isSelect = false;
            if (themeValue.equals(number)) {
                isSelect = true;
            }
            dataMap.put("isSelected", isSelect);
            list.add(dataMap);
        }
        customControl.setData(list);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map defaultThemeMap = UserServiceHelper.getUserThemeNumAndVerNew((Long)userId);
        proxy.addAction("modifyTheme", (Object)defaultThemeMap);
        this.setHeadPanelColor(defaultThemeMap);
    }

    private void setHeadPanelColor(Map<String, Object> themeMap) {
        String defaultColor = String.valueOf(themeMap.get("color"));
        Container headpanel = (Container)this.getControl("headpanel");
        if (Boolean.parseBoolean(themeMap.get("themetype").toString())) {
            HashMap<String, String> headpanelMap = new HashMap<String, String>();
            headpanelMap.put("bc", "transparent");
            this.getView().updateControlMetadata("headpanel", headpanelMap);
            headpanel.setBackgroundImg(String.valueOf(themeMap.get("background")));
        } else {
            headpanel.setBackgroundImg("");
            HashMap<String, String> headpanelMap = new HashMap<String, String>();
            headpanelMap.put("bc", defaultColor);
            this.getView().updateControlMetadata("headpanel", headpanelMap);
        }
    }

    private VectorAp createVectorAp(String number, String key, LocaleString name, String color, Map<String, Object> defaultThemeMap) {
        VectorAp radioAp = new VectorAp();
        radioAp.setId(key);
        radioAp.setKey(key);
        radioAp.setName(name);
        Tips tip = new Tips();
        tip.setType("text");
        tip.setContent(name);
        tip.setLink(false);
        tip.setShowIcon(false);
        tip.setIsConfirm(false);
        radioAp.setCtlTips(tip);
        radioAp.setWidth(new LocaleString("40px"));
        radioAp.setHeight(new LocaleString("40px"));
        radioAp.setFontSize(40);
        if (number.equals(defaultThemeMap.get("number"))) {
            radioAp.setfontClass("kdfont kdfont-fuxuankuangxuanzhong_fang");
        } else {
            radioAp.setBackColor(color);
            radioAp.setfontClass("kdfont kdfont-fuxuankuangweixuanzhong_fang");
        }
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("10px");
        margin.setLeft("10px");
        style.setMargin(margin);
        radioAp.setStyle(style);
        return radioAp;
    }

    @Override
    public String[] getSwitchPortalBtn() {
        String[] btnKeys = new String[]{"btn_newportal", "labelap321"};
        return btnKeys;
    }
}

