/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin.PswStrategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.PswStrategy.AssignUserPlugin;
import kd.bos.portal.util.PortalLogUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AssignUserTreeService {
    private static final String TBLNEW_ASSIGN = "tblnew_assign";
    private static final String TBLREFRESH_ASSIGN = "tblrefresh_assign";
    private static boolean emptyOrg = false;
    private String NODE_NAME_UNKNOWN = ResManager.loadKDString((String)"\u672a\u5206\u914d\u90e8\u95e8", (String)"UserTreeListPlugin_0", (String)"bos-sec-user", (Object[])new Object[0]);
    private static Log logger = LogFactory.getLog(AssignUserTreeService.class);
    private static final String USER_FORM_ID = "bos_user";
    protected static final String ACTION_ID_SHOW_UserF7 = "showUserF7TreeList";
    private IFormView formView;
    private IDataModel dataModel;
    private IPageCache pageCache;
    private ITreeModel iTreeModel;
    private ITreeListView treeListView;

    public AssignUserTreeService(IFormView formView, IDataModel dataModel, IPageCache pageCache, ITreeModel iTreeModel, ITreeListView treeListView) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.pageCache = pageCache;
        this.iTreeModel = iTreeModel;
        this.treeListView = treeListView;
    }

    public void itemClick(ItemClickEvent evt, AbstractTreeListPlugin plugin) {
        String itemKey = evt.getItemKey();
        if (TBLNEW_ASSIGN.equals(itemKey)) {
            this.showUserF7((AbstractFormPlugin)plugin);
        }
        if (TBLREFRESH_ASSIGN.equals(itemKey)) {
            BaseMessageUtils.showLoading((IFormView)this.formView, () -> {
                this.initTree();
                this.refreshTree();
            });
        }
    }

    public void initTree() {
        DynamicObjectCollection users = this.getPswstrategyUser(null);
        if (users.size() < 1) {
            emptyOrg = true;
            return;
        }
        try {
            List org = users.stream().map(v -> v.getLong("entryentity.dpt")).distinct().collect(Collectors.toList());
            TreeNode root = this.initRootNode();
            if (root == null) {
                return;
            }
            OrgTreeParam orgTreeParam = new OrgTreeParam();
            orgTreeParam.setOrgViewNumber("01");
            orgTreeParam.setOrgRangeList(org);
            orgTreeParam.setId(Long.parseLong(root.getId()));
            List<TreeNode> treeChildren = this.getTreeChildren(orgTreeParam);
            TreeNode noOrgNode = new TreeNode(root.getId(), "noOrg", this.NODE_NAME_UNKNOWN, false);
            treeChildren.add(noOrgNode);
            root.addChildren(treeChildren);
            this.iTreeModel.setRoot(root);
            this.iTreeModel.setCurrentNodeId((Object)root.getId());
            this.treeListView.getTreeView().addNode(root);
            this.treeListView.getTreeView().focusNode(root);
            this.pageCache.putBigObject("user_org_ids", SerializationUtils.toJsonString(org));
            emptyOrg = false;
        }
        catch (Exception e) {
            logger.info("initTree", (Object)e);
        }
    }

    public void showPswStrategy() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"perm_pswstrategy", (String)"number,name,description", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getShowParameter("selectedPsw"))});
        if (query.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)query.get(0);
            this.dataModel.setValue("pwdrnumber", dynamicObject.get(0));
            this.dataModel.setValue("pwdrname", dynamicObject.get(1));
            this.dataModel.setValue("pwdrdes", dynamicObject.get(2));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (ACTION_ID_SHOW_UserF7.equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.batchBindPswToUser(returnData);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        if ("noOrg".equalsIgnoreCase(nodeId)) {
            return;
        }
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setOrgViewNumber("01");
        orgTreeParam.setId(Long.parseLong(nodeId));
        orgTreeParam.setOrgRangeList(this.getUserOrgIds());
        List<TreeNode> treeChildren = this.getTreeChildren(orgTreeParam);
        if (nodeId.equals(this.iTreeModel.getRoot().getId())) {
            TreeNode noOrgNode = new TreeNode(nodeId, "noOrg", this.NODE_NAME_UNKNOWN, false);
            treeChildren.add(noOrgNode);
        }
        e.setChildNodes(treeChildren);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter treeListFilter = null;
        if ("noOrg".equals(nodeId)) {
            treeListFilter = QFilter.isNull((String)"entryentity.dpt");
        } else {
            long orgId = Long.parseLong(nodeId);
            treeListFilter = Boolean.parseBoolean(this.dataModel.getValue("chkincludechild").toString()) ? this.getNotRootNodeFilter(orgId) : new QFilter("entryentity.dpt", "=", (Object)orgId);
        }
        e.addQFilter(treeListFilter);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Object pswStrategyId = this.getShowParameter("selectedPsw");
        if (!ObjectUtils.isEmpty((Object)pswStrategyId)) {
            QFilter filter = new QFilter("pswstrategy_id", "=", (Object)((Long)pswStrategyId));
            qFilters.add(filter);
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        long count = qFilters.stream().filter(Objects::nonNull).filter(v -> "entryentity.dpt".equals(v.getProperty())).count();
        Object currentNodeIdObj = this.iTreeModel.getCurrentNodeId();
        if (null == currentNodeIdObj) {
            return;
        }
        if (count < 1L) {
            String currentNodeId = currentNodeIdObj.toString();
            QFilter qFilter = new QFilter("entryentity.dpt", "=", (Object)Long.valueOf(currentNodeId));
            qFilters.add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        BaseMessageUtils.showLoading((IFormView)this.formView, () -> {
            TreeView tv;
            Map focusMap;
            if ("chkincludechild".equals(proName) && (focusMap = (tv = this.treeListView.getTreeView()).getTreeState().getFocusNode()) != null) {
                tv.treeNodeClick(String.valueOf(focusMap.get("parentid")), String.valueOf(focusMap.get("id")));
            }
        });
    }

    public void search(SearchEnterEvent evt) {
        if (StringUtils.isBlank((CharSequence)evt.getText())) {
            return;
        }
        List<Long> userOrgIds = this.getUserOrgIds();
        if (userOrgIds.isEmpty()) {
            return;
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(evt.getText(), (ListView)this.formView, "01");
        searchParam.setOrgRangeList(userOrgIds);
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    private QFilter getNotRootNodeFilter(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        List orgIncludeSubs = OrgViewUtils.getSubOrgIdIncludeGrand((String)"01", orgIds, (boolean)true, (QFilter)null);
        if (Objects.isNull(orgIncludeSubs)) {
            orgIncludeSubs = Collections.emptyList();
        }
        QFilter treeListFilter = new QFilter("entryentity.dpt", "in", orgIncludeSubs);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (rootOrgId == orgId) {
            treeListFilter.or("entryentity.dpt", "is null", null);
        }
        return treeListFilter;
    }

    private void batchBindPswToUser(ListSelectedRowCollection listSelectedUserRows) {
        Object[] users;
        MainEntityType userDataEntityType = EntityMetadataCache.getDataEntityType((String)USER_FORM_ID);
        for (DynamicObject dynamicObject : users = BusinessDataServiceHelper.load((Object[])listSelectedUserRows.getPrimaryKeyValues(), (DynamicObjectType)userDataEntityType)) {
            dynamicObject.set("pswstrategy_id", this.getShowParameter("selectedPsw"));
        }
        SaveServiceHelper.save((IDataEntityType)userDataEntityType, (Object[])users);
        this.formView.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"AssignUserTreePlugin_2", (String)"bos-portal-plugin", (Object[])new Object[0]), AssignUserPlugin.SHOW_TIME);
        PortalLogUtils.addLog(USER_FORM_ID, "83bfebc8000037ac", "sharePswStrategy", new MultiLangEnumBridge("\u5bc6\u7801\u7b56\u7565\u5206\u914d", "AssignUserTreePlugin_1", "bos-portal-plugin"), new MultiLangEnumBridge("\u5206\u914d\u6210\u529f\u3002", "AssignUserTreePlugin_2", "bos-portal-plugin"), new String[0]);
        this.initTree();
        this.refreshTree();
    }

    private DynamicObjectCollection getPswstrategyUser(String orgId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        QFilter qFilter = new QFilter("pswstrategy_id", "=", this.getShowParameter("selectedPsw")).and("enable", "=", (Object)Boolean.TRUE).and("id", ">", (Object)10L);
        qFilters.add(qFilter);
        if (orgId != null) {
            if (!"noOrg".equalsIgnoreCase(orgId)) {
                QFilter qFilter1 = new QFilter("entryentity.dpt", "=", (Object)Long.valueOf(orgId));
                qFilters.add(qFilter1);
            } else {
                QFilter qFilter1 = new QFilter("entryentity.dpt", "is null", null);
                qFilters.add(qFilter1);
            }
        }
        return QueryServiceHelper.query((String)USER_FORM_ID, (String)"id,name,entryentity.dpt", (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    private Object getShowParameter(String key) {
        Map customParams = this.formView.getFormShowParameter().getCustomParams();
        return customParams.get(key);
    }

    private List<TreeNode> getTreeChildren(OrgTreeParam orgTreeParam) {
        return OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)orgTreeParam);
    }

    private TreeNode initRootNode() {
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setOrgViewNumber("01");
        Map treeRoot = OrgUnitServiceHelper.getTreeRootNodeMapById((OrgTreeParam)orgTreeParam);
        DynamicObjectCollection orgObjects = QueryServiceHelper.query((String)"bos_org", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", treeRoot.get("id"))}, null);
        if (orgObjects != null && orgObjects.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)orgObjects.get(0);
            TreeNode treeNode = new TreeNode(null, String.valueOf(treeRoot.get("id")), dynamicObject.getString("name") + "(" + dynamicObject.getString("number") + ")");
            treeNode.setLongNumber(treeRoot.get("longnumber").toString());
            treeNode.setExpend(true);
            treeNode.setIsOpened(true);
            return treeNode;
        }
        return null;
    }

    private void refreshTree() {
        TreeNode root = this.iTreeModel.getRoot();
        TreeView tv = this.treeListView.getTreeView();
        tv.treeNodeClick(root.getParentid(), root.getId());
        if (emptyOrg) {
            tv.deleteAllNodes();
        }
    }

    private void showUserF7(AbstractFormPlugin plugin) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)USER_FORM_ID, (boolean)true);
        lsp.setCaption(ResManager.loadKDString((String)"\u5206\u914d\u6210\u5458", (String)"AssignUserPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        lsp.setCustomParam("externalUserType", (Object)"all");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, ACTION_ID_SHOW_UserF7));
        this.formView.showForm((FormShowParameter)lsp);
    }

    private List<Long> getUserOrgIds() {
        String orgIds = this.pageCache.getBigObject("user_org_ids");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgIds)) {
            return Collections.emptyList();
        }
        return (List)SerializationUtils.fromJsonString((String)orgIds, List.class);
    }
}

