/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.permission.cache.util.PermCommonUtil;

public class PswStrategyEditPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(PswStrategyEditPlugin.class);
    private static final String VERCODECTRL = "vercodectrl";
    private static final String ENABLE_GRAPHIC_CODE = "enable_graphic_code";
    private static final String SMS_COUNT = "sms_count";
    private static final String ENABLE_LOCK = "enable_lock";
    private static final String LOGIN_OPTIONS_COMBOFIELD = "login_options_combofield";
    private static final String ENABLE_SMS_CODE = "enable_sms_code";
    private static final String HCODE_CHANGEFOREWARNDAY = "changeforewarnday";
    private static final String HCODE_CHANGECYCLE = "changecycle";
    private static final String FOREWARNDAY = "forewarnday";
    private static final String PROP_CHANGE = "propChange";
    private static final String HCODE_VALIDITY = "validity";
    private static final String BOS_PERMISSION_FORMPLUGIN = "bos-permission-formplugin";
    private static final String LOCKTERM = "lockterm";
    private static final String LOCK_COUNT = "lockcount";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void afterCreateNewData(EventObject e) {
        Object vercodeCtrlObj;
        Object smsCountObj;
        super.afterCreateNewData(e);
        Object lockCount = this.getModel().getValue(LOCK_COUNT);
        if (lockCount != null && Integer.parseInt(lockCount.toString()) <= 0) {
            this.getModel().setValue(ENABLE_LOCK, (Object)"0");
        }
        if ((smsCountObj = this.getModel().getValue(SMS_COUNT)) != null && Integer.parseInt(smsCountObj.toString()) <= 0) {
            this.getModel().setValue(ENABLE_SMS_CODE, (Object)"0");
        }
        if ((vercodeCtrlObj = this.getModel().getValue(VERCODECTRL)) != null && Integer.parseInt(vercodeCtrlObj.toString()) <= 0) {
            this.getModel().setValue(ENABLE_GRAPHIC_CODE, (Object)"0");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object validityObj = this.getModel().getValue(LOGIN_OPTIONS_COMBOFIELD);
        if (validityObj.equals("1")) {
            this.updateFieldVisible(true);
        } else if (validityObj.equals("2")) {
            this.updateFieldVisible(false);
        } else if (validityObj.equals("3")) {
            this.updateFieldVisible(false);
        } else if (validityObj.equals("4")) {
            this.updateFieldVisible(false);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        if (this.getPageCache().get(LOCKTERM) != null) {
            return;
        }
        String name = e.getProperty().getName();
        if (LOCKTERM.equals(name)) {
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            long newValue = 0L;
            if (newValueObj != null) {
                newValue = newValueObj.toString().contains(".") ? (long)Float.parseFloat(newValueObj.toString()) : Long.parseLong(newValueObj.toString());
            }
            if (newValue == 0L) {
                this.getPageCache().put(LOCKTERM, "true");
                this.getModel().setValue(LOCKTERM, null);
                this.getPageCache().remove(LOCKTERM);
                this.showFieldTips(LOCKTERM, ResManager.loadKDString((String)"\u8bf7\u586b\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"PswStrategyEditPlugin_11", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]), false);
            }
        }
        this.showFieldTips(LOCKTERM, "", true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object isletterObj;
        int validity;
        Object validityObj;
        String name = e.getProperty().getName();
        if (HCODE_VALIDITY.equals(name)) {
            validityObj = this.getModel().getValue(HCODE_VALIDITY);
            int n = validity = validityObj == null ? 0 : Integer.parseInt(validityObj.toString());
            if (validity == 0) {
                this.getPageCache().put(PROP_CHANGE, "true");
                this.getModel().setValue(FOREWARNDAY, (Object)0);
                this.getPageCache().remove(PROP_CHANGE);
                return;
            }
        }
        if (this.getPageCache().get(PROP_CHANGE) != null) {
            return;
        }
        if (HCODE_CHANGECYCLE.equals(name)) {
            int changecycle;
            validityObj = this.getModel().getValue(HCODE_VALIDITY);
            validity = validityObj == null ? 0 : Integer.parseInt(validityObj.toString());
            Object changecycleObj = this.getModel().getValue(HCODE_CHANGECYCLE);
            int n = changecycle = changecycleObj == null ? 0 : Integer.parseInt(changecycleObj.toString());
            if (changecycle > validity) {
                this.getModel().setValue(HCODE_CHANGECYCLE, (Object)0);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4fee\u6539\u5468\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5bc6\u7801\u6709\u6548\u671f\u3002", (String)"PswStrategyEditPlugin_12", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (HCODE_CHANGEFOREWARNDAY.equals(name)) {
            int changeforewarnday;
            Object changecycleObj = this.getModel().getValue(HCODE_CHANGECYCLE);
            int changecycle = changecycleObj == null ? 0 : Integer.parseInt(changecycleObj.toString());
            Object cfwdObj = this.getModel().getValue(HCODE_CHANGEFOREWARNDAY);
            int n = changeforewarnday = cfwdObj == null ? 0 : Integer.parseInt(cfwdObj.toString());
            if (changeforewarnday >= changecycle) {
                this.getModel().setValue(HCODE_CHANGEFOREWARNDAY, (Object)0);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4fee\u6539\u63d0\u524d\u9884\u8b66\u671f\u9700\u5c0f\u4e8e\u5bc6\u7801\u6709\u6548\u671f\u3002", (String)"PswStrategyEditPlugin_13", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (FOREWARNDAY.equals(name)) {
            validityObj = this.getModel().getValue(HCODE_VALIDITY);
            int n = validity = validityObj == null ? 0 : Integer.parseInt(validityObj.toString());
            if (validity == 0) {
                this.getPageCache().put(PROP_CHANGE, "true");
                this.getModel().setValue(FOREWARNDAY, (Object)0);
                this.getPageCache().remove(PROP_CHANGE);
            }
        } else if (LOGIN_OPTIONS_COMBOFIELD.equals(name)) {
            validityObj = this.getModel().getValue(LOGIN_OPTIONS_COMBOFIELD);
            String msg = "";
            if (validityObj.equals("1")) {
                msg = this.checkMcParam("1");
                this.updateFieldVisible(true);
            } else if (validityObj.equals("2")) {
                this.updateFieldVisible(false);
            } else if (validityObj.equals("3")) {
                this.updateFieldVisible(false);
                msg = this.checkMcParam("3");
            } else if (validityObj.equals("4")) {
                this.updateFieldVisible(false);
                msg = this.checkMcParam("4");
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
            }
        } else if (ENABLE_LOCK.equals(name)) {
            Object lockcountObj = this.getModel().getValue(LOCK_COUNT);
            Object enableLock = this.getModel().getValue(ENABLE_LOCK);
            int lockcount = lockcountObj == null ? 0 : Integer.parseInt(lockcountObj.toString());
            Object locktermObj = this.getModel().getValue(LOCKTERM);
            int lockterm = 0;
            if (locktermObj != null) {
                lockterm = locktermObj.toString().contains(".") ? (int)Float.parseFloat(locktermObj.toString()) : Integer.parseInt(locktermObj.toString());
            }
            if ((lockcount <= 0 || lockterm <= 0) && ((Boolean)enableLock).booleanValue()) {
                this.getModel().setValue(ENABLE_LOCK, (Object)"0");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u8d26\u53f7\u9501\u5b9a\uff0c\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u548c\u9501\u5b9a\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_28", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (ENABLE_SMS_CODE.equals(name)) {
            int smsCount;
            Object smsCountObj = this.getModel().getValue(SMS_COUNT);
            Object enableSmsCode = this.getModel().getValue(ENABLE_SMS_CODE);
            int n = smsCount = smsCountObj == null ? 0 : Integer.parseInt(smsCountObj.toString());
            if (smsCount == 0 && ((Boolean)enableSmsCode).booleanValue()) {
                this.getModel().setValue(ENABLE_SMS_CODE, (Object)"0");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_29", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (ENABLE_GRAPHIC_CODE.equals(name)) {
            int vercodeCtrl;
            Object vercodeCtrlObj = this.getModel().getValue(VERCODECTRL);
            Object enableGraphicCode = this.getModel().getValue(ENABLE_GRAPHIC_CODE);
            int n = vercodeCtrl = vercodeCtrlObj == null ? 0 : Integer.parseInt(vercodeCtrlObj.toString());
            if (vercodeCtrl == 0 && ((Boolean)enableGraphicCode).booleanValue()) {
                this.getModel().setValue(ENABLE_GRAPHIC_CODE, (Object)"0");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u56fe\u5f62\u9a8c\u8bc1\u7801\uff0c\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_30", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if ("hascaseletter".equals(name)) {
            Object hascaseletterObj = this.getModel().getValue("hascaseletter");
            if (hascaseletterObj != null && Boolean.parseBoolean(hascaseletterObj.toString())) {
                this.getModel().setValue("isletter", (Object)"1");
            }
        } else if ("isletter".equals(name) && (isletterObj = this.getModel().getValue("isletter")) != null && !Boolean.parseBoolean(isletterObj.toString())) {
            this.getModel().setValue("hascaseletter", (Object)"0");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            int lockcountNum;
            int vercodeCtrl;
            int smsCount;
            String name;
            String number;
            Object minlengthObj;
            int minlength;
            int forewarnday;
            Object validityObj = this.getModel().getValue(HCODE_VALIDITY);
            int validity = validityObj == null ? 0 : Integer.parseInt(validityObj.toString());
            Object forewarndayObj = this.getModel().getValue(FOREWARNDAY);
            int n = forewarnday = forewarndayObj == null ? 0 : Integer.parseInt(forewarndayObj.toString());
            if (forewarnday >= validity && forewarnday > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5bc6\u7801\u6709\u6548\u671f\uff08\u5929\uff09\u201d\u5e94\u5927\u4e8e\u201c\u5931\u6548\u9884\u8b66\u671f\uff08\u5929\uff09\u201d\u3002", (String)"PswStrategyEditPlugin_19", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
            int n2 = minlength = (minlengthObj = this.getModel().getValue("minlength")) == null ? 0 : Integer.parseInt(minlengthObj.toString());
            if (minlength < 6 || minlength > 20) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5bc6\u7801\u6700\u5c0f\u957f\u5ea6\u201d\u5b57\u6bb5\u9700\u8f93\u51656-20\u7684\u6570\u5b57\u3002", (String)"PswStrategyEditPlugin_15", (String)"bos-portal-plugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (StringUtils.isBlank((CharSequence)(number = this.getModel().getValue("number").toString()))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_16", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (StringUtils.isBlank((CharSequence)(name = this.getModel().getValue("name").toString()))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_17", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
            Object enableLock = this.getModel().getValue(ENABLE_LOCK);
            Object lockcountObj = this.getModel().getValue(LOCK_COUNT);
            int lockcount = lockcountObj == null ? 0 : Integer.parseInt(lockcountObj.toString());
            Object locktermObj = this.getModel().getValue(LOCKTERM);
            int lockterm = 0;
            if (locktermObj != null) {
                lockterm = locktermObj.toString().contains(".") ? (int)Float.parseFloat(locktermObj.toString()) : Integer.parseInt(locktermObj.toString());
            }
            if ((lockcount <= 0 || lockterm <= 0) && ((Boolean)enableLock).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u8d26\u53f7\u9501\u5b9a\uff0c\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u548c\u9501\u5b9a\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_28", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
            Object smsCountObj = this.getModel().getValue(SMS_COUNT);
            Object enableSmsCode = this.getModel().getValue(ENABLE_SMS_CODE);
            int n3 = smsCount = smsCountObj == null ? 0 : Integer.parseInt(smsCountObj.toString());
            if (smsCount == 0 && ((Boolean)enableSmsCode).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_29", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
            Object vercodeCtrlObj = this.getModel().getValue(VERCODECTRL);
            Object enableGraphicCode = this.getModel().getValue(ENABLE_GRAPHIC_CODE);
            int n4 = vercodeCtrl = vercodeCtrlObj == null ? 0 : Integer.parseInt(vercodeCtrlObj.toString());
            if (vercodeCtrl == 0 && ((Boolean)enableGraphicCode).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u56fe\u5f62\u9a8c\u8bc1\u7801\uff0c\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_30", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (enableLock != null && Boolean.parseBoolean(enableLock.toString()) && (lockcountNum = lockcount) > 0) {
                if (locktermObj != null) {
                    lockterm = locktermObj.toString().contains(".") ? (int)Float.parseFloat(locktermObj.toString()) : Integer.parseInt(locktermObj.toString());
                }
                if (lockterm <= 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u8d26\u53f7\u9501\u5b9a\uff0c\u5bc6\u7801\u8f93\u9519\u6b21\u6570\u548c\u9501\u5b9a\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PswStrategyEditPlugin_28", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
        if (this.getView().getModel() != null && this.getView().getModel().getDataEntity() != null) {
            CacheLoginData.remove((String)"psw", (String)(this.getView().getModel().getDataEntity().getPkValue() + RequestContext.get().getAccountId()));
        }
    }

    public boolean checkPwdLength() {
        boolean flag = false;
        int pwdLength = String.valueOf(this.getModel().getValue("default")).length();
        if (pwdLength < 6 || pwdLength > 20) {
            flag = true;
        }
        return flag;
    }

    private void showFieldTips(String field, String tips, boolean isHidden) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(field);
        LocaleString ls = new LocaleString(tips);
        fieldTip.setTip(ls.getLocaleValue());
        fieldTip.setSuccess(isHidden);
        this.getView().showFieldTip(fieldTip);
    }

    private void updateFieldVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{VERCODECTRL});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"graphic_code_flexpanelap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"graphic_code_duration"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"code_enable_flexpanelap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{SMS_COUNT});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"sms_code_flexpanelap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"sms_code_duration"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"sms_code_enable"});
    }

    private String checkMcParam(String loginOptions) {
        String msg = null;
        boolean isNeed = false;
        String isNeedFactor = System.getProperty(RequestContext.get().getTenantId() + ".need.new.factor");
        if (kd.bos.util.StringUtils.isNotEmpty((String)isNeedFactor)) {
            if ("true".equals(isNeedFactor.toLowerCase().trim())) {
                isNeed = true;
            } else if ("alluser".equals(isNeedFactor.toLowerCase().trim())) {
                isNeed = true;
            }
        }
        boolean isForced = false;
        String isForceString = System.getProperty(RequestContext.get().getTenantId() + "_" + "IsVerifycodeDisplay");
        if (StringUtils.isEmpty((CharSequence)isForceString)) {
            isForceString = System.getProperty("IsVerifycodeDisplay");
        }
        if ("true".equalsIgnoreCase(isForceString)) {
            isForced = true;
        }
        if (isNeed && isForced) {
            msg = ResManager.loadKDString((String)"\u60a8\u5df2\u5728\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5f00\u542f\u4e86\u767b\u5f55\u9009\u9879\u201c\u8d26\u53f7+\u5bc6\u7801+\u77ed\u4fe1\u9a8c\u8bc1\u7801\u201d\uff0c\u82e5\u9700\u4f7f\u7528\u82cd\u7a79\u767b\u5f55\u9009\u9879\uff0c\u8bf7\u5173\u95ed\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u914d\u7f6e\u9879\u3002", (String)"PswStrategyEditPlugin_31", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]);
        } else if (isNeed) {
            msg = ResManager.loadKDString((String)"\u60a8\u5df2\u5728\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5f00\u542f\u4e86\u767b\u5f55\u9009\u9879\u201c\u8d26\u53f7+\u5bc6\u7801+\u77ed\u4fe1\u9a8c\u8bc1\u7801\u201d\uff0c\u82e5\u9700\u4f7f\u7528\u82cd\u7a79\u767b\u5f55\u9009\u9879\uff0c\u8bf7\u5173\u95ed\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u914d\u7f6e\u9879\u3002", (String)"PswStrategyEditPlugin_31", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]);
        } else if (isForced && !"3".equals(loginOptions)) {
            msg = ResManager.loadKDString((String)"\u60a8\u5df2\u5728\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5f00\u542f\u4e86\u767b\u5f55\u9009\u9879\u201c\u8d26\u53f7+\u5bc6\u7801+\u56fe\u5f62\u9a8c\u8bc1\u7801\u201d\uff0c\u82e5\u9700\u4f7f\u7528\u82cd\u7a79\u767b\u5f55\u9009\u9879\uff0c\u8bf7\u5173\u95ed\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u914d\u7f6e\u9879\u3002", (String)"PswStrategyEditPlugin_32", (String)BOS_PERMISSION_FORMPLUGIN, (Object[])new Object[0]);
        }
        logger.info("checkMcParam:isNeedFactor" + isNeedFactor + ",isForceString:" + isForceString);
        return msg;
    }
}

