/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.util.CollectionUtils;

public class SwitchBusPartnerPlugin
extends AbstractFormPlugin
implements ListRowClickListener {
    private static final String BUTTON_KEY = "buttonKey";
    private static final String BUTTON_SET_DEFAULT = "btnsetdefault";
    private static final String BUTTON_SET_OK = "btnok";
    private static final String CONFIRMCALLBACKID_SET_DEFAULT = "confirm_btnsetdefault";
    private static final String CONFIRMCALLBACKID_SET_OK = "confirm_btnok";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String KEY_ENTRYENTITY = "billlistap";
    private static final String DOUBLE_CLICK = "doubleClick";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_SET_OK, BUTTON_SET_DEFAULT});
        BillList billList = (BillList)this.getView().getControl(KEY_ENTRYENTITY);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.getPageCache().put(BUTTON_KEY, DOUBLE_CLICK);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button btn = (Button)source;
            String btnKey = btn.getKey();
            if ("btnclose".equals(btnKey)) {
                this.getPageCache().remove(BUTTON_KEY);
            } else {
                this.getPageCache().put(BUTTON_KEY, btnKey);
            }
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            Control c = (Control)evt.getSource();
            switch (key = c.getKey()) {
                case "btnok": {
                    if (!this.isSelected(evt)) break;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9875\u9762\u5373\u5c06\u5237\u65b0\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SwitchBusPartnerPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACKID_SET_OK, (IFormPlugin)this));
                    break;
                }
                case "btnsetdefault": {
                    if (!this.isSelected(evt)) break;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u9875\u9762\u5373\u5c06\u5237\u65b0\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SwitchBusPartnerPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACKID_SET_DEFAULT, (IFormPlugin)this));
                    break;
                }
            }
        }
    }

    private boolean isSelected(EventObject evt) {
        BillList billList = (BillList)this.getView().getControl(KEY_ENTRYENTITY);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SwitchBusPartnerPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (CONFIRMCALLBACKID_SET_OK.equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.returnDataToParent(e);
            }
        } else if (CONFIRMCALLBACKID_SET_DEFAULT.equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.returnDataToParent(e);
            } else {
                return;
            }
        }
    }

    private void returnDataToParent(MessageBoxClosedEvent e) {
        String btnKey = this.getPageCache().get(BUTTON_KEY);
        if (btnKey == null) {
            this.getView().returnDataToParent(null);
            return;
        }
        ListSelectedRowCollection selectedRows = ((AbstractListView)e.getSource()).getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SwitchBusPartnerPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Long id = Long.valueOf(String.valueOf(selectedRows.get(0).getPrimaryKeyValue()));
        if (id == null) {
            return;
        }
        HashMap<String, Object> returnDataMap = null;
        boolean setDefault = BUTTON_SET_DEFAULT.equals(btnKey);
        returnDataMap = new HashMap<String, Object>(8);
        returnDataMap.put("busPartnerId", id);
        returnDataMap.put("setDefault", setDefault);
        returnDataMap.put("busPartnerName", selectedRows.get(0).getName());
        this.getView().returnDataToParent(returnDataMap);
        this.getView().close();
    }
}

