/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.portal.util.PortalFormUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.SchemeServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class SwitchSchemePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String MAINUSERCONFIGKEY = "mainPersonalScheme";
    private static final String APPHOMEUSERCONFIGKEY = "appHomePersonalScheme";
    public static final String APPID = "appid";
    public static final String NUMBER = "number";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancle"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String scene = (String)fsp.getCustomParam("scene");
        String appId = (String)fsp.getCustomParam(APPID);
        JSONArray schemes = this.getSchemes(scene, appId);
        this.renderSchemeList(schemes);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            AbstractGrid grid = (AbstractGrid)this.getControl("schemelist");
            int rowIndex = grid.getEntryState().getFocusRow();
            String schemeId = this.getModel().getValue("schemeid", rowIndex).toString();
            this.getView().returnDataToParent((Object)schemeId);
        }
        this.getView().close();
    }

    private JSONArray getSchemes(String scene, String appId) {
        JSONObject managerOrAllUserScheme;
        JSONArray standardSchemes;
        JSONArray schemeObjects = new JSONArray();
        JSONObject personalScheme = this.getPersonScheme(scene, appId);
        if (personalScheme != null && !personalScheme.isEmpty()) {
            schemeObjects.add((Object)personalScheme);
        }
        if ((standardSchemes = this.getStandardScheme(appId)) != null && standardSchemes.size() != 0) {
            schemeObjects.addAll((Collection)standardSchemes);
        }
        if ((managerOrAllUserScheme = this.getManagerOrAllUserScheme(scene, appId)) != null && !managerOrAllUserScheme.isEmpty()) {
            schemeObjects.add((Object)managerOrAllUserScheme);
        }
        return schemeObjects;
    }

    private void renderSchemeList(JSONArray schemes) {
        IDataModel model = this.getModel();
        if (schemes != null && schemes.size() != 0) {
            model.batchCreateNewEntryRow("schemelist", schemes.size());
            for (int i = 0; i < schemes.size(); ++i) {
                JSONObject scheme = schemes.getJSONObject(i);
                model.setValue("schemename", (Object)scheme.getString("name"), i);
                model.setValue("schemenumber", (Object)scheme.getString(NUMBER), i);
                model.setValue("schemetype", (Object)this.modifyType(scheme.getString("type")), i);
                model.setValue("schemeid", (Object)scheme.getString("id"), i);
            }
        }
    }

    private String modifyType(String type) {
        String typeName = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u65b9\u6848", (String)"SwitchSchemePlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        switch (type) {
            case "0": {
                typeName = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u65b9\u6848", (String)"SwitchSchemePlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "1": {
                typeName = ResManager.loadKDString((String)"\u5168\u5458\u65b9\u6848", (String)"SwitchSchemePlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "2": {
                typeName = ResManager.loadKDString((String)"\u89d2\u8272\u65b9\u6848", (String)"SwitchSchemePlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "3": {
                typeName = ResManager.loadKDString((String)"\u4eba\u5458\u65b9\u6848", (String)"SwitchSchemePlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "4": {
                typeName = ResManager.loadKDString((String)"\u7ec4\u7ec7\u65b9\u6848", (String)"SwitchSchemePlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "6": {
                typeName = ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u65b9\u6848", (String)"SwitchSchemePlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                break;
            }
        }
        return typeName;
    }

    private JSONObject getPersonScheme(String scene, String appId) {
        JSONObject scheme = new JSONObject();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        JSONObject schemeInfo = new JSONObject();
        if (scene != null) {
            schemeInfo = scene.trim().equals("0") ? JSONObject.parseObject((String)UserConfigServiceHelper.getSetting((long)userId, (String)MAINUSERCONFIGKEY)) : JSONObject.parseObject((String)UserConfigServiceHelper.getSetting((long)userId, (String)("appHomePersonalScheme&" + appId)));
        }
        if (schemeInfo != null && !schemeInfo.isEmpty() && scene != null) {
            scheme.put("name", (Object)ResManager.loadKDString((String)"\u6211\u7684\u65b9\u6848", (String)"SwitchSchemePlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            scheme.put(NUMBER, (Object)(scene.equals("0") ? MAINUSERCONFIGKEY : "appHomePersonalScheme&" + appId));
            scheme.put("type", (Object)"6");
            scheme.put("id", (Object)schemeInfo.getString("id"));
        }
        return scheme;
    }

    private JSONArray getStandardScheme(String appId) {
        JSONArray schemeOfRole;
        JSONArray schemes = new JSONArray();
        List<String> roleIds = PortalFormUtil.getRoleIds();
        if (roleIds.size() != 0 && (schemeOfRole = this.getSchemeByAssignFilter("2", roleIds, appId)) != null && schemeOfRole.size() != 0) {
            this.mergeScheme(schemes, schemeOfRole);
        }
        String userId = RequestContext.get().getUserId();
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId);
        JSONArray schemeOfUser = this.getSchemeByAssignFilter("3", userIds, appId);
        if (schemeOfUser != null && schemeOfUser.size() != 0) {
            this.mergeScheme(schemes, schemeOfUser);
        }
        List userOrgs = UserServiceHelper.getOrgsUserJoin((long)Long.parseLong(userId));
        ArrayList<String> orgIds = new ArrayList<String>(userOrgs.size());
        List permOrgs = PermissionServiceHelper.getUserOrgs((long)Long.parseLong(userId));
        userOrgs.addAll(permOrgs);
        for (Long org : userOrgs) {
            orgIds.add(String.valueOf(org));
        }
        JSONArray schemeOfOrg = this.getSchemeByAssignFilter("4", orgIds, appId);
        if (schemeOfOrg != null && schemeOfOrg.size() != 0) {
            this.mergeScheme(schemes, schemeOfOrg);
        }
        return schemes;
    }

    private void mergeScheme(JSONArray schemes, JSONArray schemeObjects) {
        for (int i = 0; i < schemeObjects.size(); ++i) {
            JSONObject scheme = schemeObjects.getJSONObject(i);
            schemes.add((Object)scheme);
        }
    }

    private JSONArray getSchemeByAssignFilter(String rangeType, List<String> objectIds, String appId) {
        String scene = (String)this.getView().getFormShowParameter().getCustomParam("scene");
        JSONArray schemes = new JSONArray();
        DynamicObject[] schemeObjects = SchemeServiceHelper.getSchemeByAssignFilters((String)scene, (String)rangeType, objectIds);
        if (schemeObjects != null) {
            for (int i = 0; i < schemeObjects.length; ++i) {
                DynamicObject schemeObject = schemeObjects[i];
                if (!scene.equals("0") && (!scene.equals("1") || !schemeObject.getString(APPID).equals(appId))) continue;
                JSONObject scheme = new JSONObject();
                scheme.put("id", (Object)schemeObject.getString("id"));
                scheme.put("name", (Object)schemeObject.getString("name"));
                scheme.put(NUMBER, (Object)schemeObject.getString(NUMBER));
                scheme.put("type", (Object)rangeType);
                schemes.add((Object)scheme);
            }
        }
        return schemes;
    }

    private JSONObject getManagerOrAllUserScheme(String scene, String appId) {
        JSONObject scheme = new JSONObject();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String schemeType = null;
        schemeType = "0".equals(scene) ? (PermissionServiceHelper.isAdminUser((long)userId) ? "0" : "1") : "1";
        DynamicObjectCollection schemeObjects = SchemeServiceHelper.getSchemeByTypeAndScene((String)schemeType, (String)scene);
        if (schemeObjects != null && schemeObjects.size() != 0) {
            DynamicObject schemeObject = null;
            if (scene.equals("0")) {
                schemeObject = (DynamicObject)schemeObjects.get(0);
            } else {
                for (DynamicObject obj : schemeObjects) {
                    if (!obj.getString(APPID).equals(appId)) continue;
                    schemeObject = obj;
                    break;
                }
            }
            if (schemeObject != null) {
                scheme.put("name", (Object)schemeObject.getString("name"));
                scheme.put(NUMBER, (Object)schemeObject.getString(NUMBER));
                scheme.put("id", (Object)schemeObject.getString("id"));
                scheme.put("type", (Object)schemeType);
            }
        }
        return scheme;
    }
}

