/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.KSqlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ConfigServiceHelper;

public class SwitchTenantsPlugin
extends AbstractFormPlugin
implements ClickListener,
TabSelectListener {
    private static Log logger = LogFactory.getLog(SwitchTenantsPlugin.class);
    private static final String IMG_SERVER_URL = ConfigServiceHelper.getGlobalConfiguration((String)"fileserver").toString();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "btnok": {
                this.switchTenant();
                this.getView().close();
                break;
            }
        }
    }

    private void switchTenant() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int index = grid.getEntryState().getFocusRow();
        DynamicObject tenantInfo = this.getModel().getEntryRowEntity("entryentity", index);
        if (tenantInfo == null) {
            return;
        }
        String tenantid = (String)tenantInfo.get("tenantid");
        RequestContext requestContext = RequestContext.get();
        String tenant_userid = requestContext.getUserId();
        String userUid = "0";
        ORM orgORM = ORM.create();
        QFilter f1 = new QFilter("id", "=", (Object)tenant_userid);
        try (DataSet ds = orgORM.queryDataSet(SwitchTenantsPlugin.class.getName(), "bos_user", "fuid", new QFilter[]{f1});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                userUid = row.getString("fuid");
            }
        }
        String sRedirectURL = String.format("auth/yzjSwitchTenant.do?tenantId=%s&userid=%s", tenantid, userUid);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>();
        mpURL.put("url", sRedirectURL);
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
        HashMap<String, Object> reData = new HashMap<String, Object>();
        reData.put("name", tenantInfo.get("tenantname"));
        this.getView().returnDataToParent(reData);
    }

    private String[] getMCMainDBInfo() {
        String driver = System.getProperty("mcdbdriver_ksql");
        String url = System.getProperty("mcdburl_ksql");
        url = KSqlUtil.decodeUrl((String)url);
        String[] mcDBInfo = new String[]{driver, url};
        return mcDBInfo;
    }

    public void tabSelected(TabSelectEvent evt) {
    }
}

