/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.mc.webclient.WebClientFiles;
import kd.bos.metadata.form.control.HyperlinkAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.portal.dto.MCUploadFileDto;
import kd.bos.portal.model.BasLoginConfigParam;
import kd.bos.portal.model.UserSourceTypeEnum;
import kd.bos.portal.service.impl.BasLoginConfigServiceImpl;
import kd.bos.portal.util.LoginConfigUtils;
import kd.bos.portal.util.LoginMCServiceUtil;
import kd.bos.portal.util.MCUploadFileUtil;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.DisCardUtil;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FilenameUtils;

public class TenantLoginConfigPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String _MC_ICONFONT_DATA = "_mcIconfontData_";
    private static final String _TENANT_LOGIN_CONFIG = "_tenant_login_config_";
    private static final String IMAGE_MCDATA = "image_mcdata";
    private static final String MC = "mc";
    private static final String IS_COMMON = "is_common";
    public static final String DEFAULT_SOURCE_TYPE_COSMIC = "2";
    public static final String ADVLABEL = "advlabel";
    public static final String ADVCLOSE = "advclose";
    public static final String ADVOPEN = "advopen";
    public static final String LINK_DATA1 = "linkData";
    private static final String URL = "url";
    private static final String FILE_SERVER_URL = "fileServerUrl";
    private static final String FILECHANGE = "filechange";
    private static Log logger = LogFactory.getLog(TenantLoginConfigPlugin.class);
    private static final String FILE_KEY = "_tenant_login_config_files_";
    private static final String CONFIG_KEY = "_tenant_login_config_values_";
    private static final String TAB_WORD = "tabword";
    private static final String BG_IMG = "bgimg";
    private static final String LOGO_IMG = "logoimg";
    private static final String TAB_IMG = "tabimg";
    private static final String LEFT_TOP_LOGO_IMG = "lefttoplogoimg";
    private static final String ACCOUNT_TYPE_DESC = "accounttypedesc";
    private static final String WELCOME_MSG = "welcomemsg";
    private static final String ACCOUNT_PLACEHOLDER = "accountplaceholder";
    private static final String RESET_PD = "resetpwd";
    private static final String HIDDEN_RESET_PD = "hiddenresetpwd";
    private static final String LINK_DATA = "linkdata";
    private static final String ATTACH_FILES = "attachfiles";
    private static final String GLOBAL_PATH = "globalfiles";
    private static final String FILE_PANEL_KEY = "filepanel";
    private static final String USER_NAME_PSW = "usernamepsw";
    private static final String LOGIN_SOURCE_TYPE_VALUE = "defaultusersourcetype";
    private static final String SHOWVIEWPWDBTN = "showviewpwdbtn";
    private static final String[] wordTypeArray = new String[]{"tabword", "bgimg", "logoimg", "tabimg", "lefttoplogoimg", "accounttypedesc", "welcomemsg", "accountplaceholder", "hiddenresetpwd", "usernamepsw", "defaultusersourcetype", "showviewpwdbtn"};
    private static final String VALIDATE = "validate";
    private static final String VALIEDATA_TIPS = "validate_tips";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String ADV_SETTING_PANEL_KEY = "advsetting";
    private static final String ADV_SETTING_PANEL_STATUS = "__advsetting_status__";
    private static final String LINK_KEY = "_tenantlogin_linksetting_";
    private static final String LINK_ZOON_KEY = "linkzoon";
    private static final String URL_CACHE_KEY = "_custom_logo_url_";
    private static final String ICONFONT_KEY = "_tenant_iconfont_config_files_";
    private static final String ICONFONT_FILES = "iconfontfiles";
    private static final String ICONFONT_PANEL_KEY = "iconfontpanel";
    private static final String ICONFONT_VALIDATE = "iconfont_validate";
    private static final String ICONFONT_VALIEDATA_TIPS = "iconfont_validate_tips";
    private static final String LOGINPAGE_FILE_KEY = "_tenant_loginpage_config_files_";
    private static final String LOGINPAGE_ATTACH_FILES = "loginpageattachfiles";
    private static final String LOGINPAGE_FILE_PANEL_KEY = "loginpagefilepanel";
    private static final String LOGINPAGE_VALIDATE = "loginpage_validate";
    private static final String LOGINPAGE_VALIEDATA_TIPS = "loginpage_validate_tips";
    private static final String LOGINPAGE_PATH = "logincustomjs";
    private static final String[] imageArray = new String[]{"bgimg", "logoimg", "tabimg"};
    private static final String IMAGE_FLAG = "image_flag";
    private static final String IMAGE_PATH = "loginImage";
    private static final String IMAGE_FILE_KEY = "imagefile";
    private static final List<String> MULTI_LANG_FIELD = Arrays.asList("accounttypedesc", "accountplaceholder", "tabword", "welcomemsg");
    private static final List<String> IMAGE_FIELD = Arrays.asList("bgimg", "logoimg", "tabimg", "lefttoplogoimg");
    private static DistributeSessionlessCache iconfontcache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ICONFONT", new DistributeCacheHAPolicy(true, true));
    private static final Set<String> ICONFONT_FILE_WHITE_LIST = Stream.of(".css", ".html", ".eot", ".js", ".json", ".svg", ".ttf", ".woff", ".woff2").collect(Collectors.toCollection(HashSet::new));
    private static final Set<String> FILE_WHITE_LIST = Stream.of(".js", ".css", ".html", ".tpl", ".png", ".jpg", ".jpeg", ".svg", ".gif", ".ico").collect(Collectors.toCollection(HashSet::new));

    private String getFileServer() {
        String fileServer = System.getProperty("attachmentServer.url");
        if (fileServer.endsWith("/")) {
            fileServer = fileServer.substring(0, fileServer.lastIndexOf(47));
        }
        return fileServer;
    }

    private boolean isAttachmentSecondDev(String tenantId) {
        return Boolean.parseBoolean(this.attachmentSecondDev(tenantId));
    }

    private String attachmentSecondDev(String tenantId) {
        return SystemPropertyUtils.getProptyByTenant((String)"attachment.second.dev", (String)tenantId);
    }

    private String getDescription() {
        return ResManager.loadKDString((String)"\u9690\u85cf\u9ad8\u7ea7\u8bbe\u7f6e", (String)"TenantLoginConfigPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getZipNullMsg() {
        return ResManager.loadKDString((String)"\u4e0a\u4f20\u4e86\u4e00\u4e2a\u7a7a\u7684\u538b\u7f29\u5305\u3002", (String)"TenantLoginConfigPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getEntryFileNotExistMsg() {
        return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u538b\u7f29\u5305\u6839\u76ee\u5f55\u6ca1\u6709index.js\u6216index_m.js\u5165\u53e3\u6587\u4ef6\uff0c\u8bf7\u5904\u7406\u3002", (String)"TenantLoginConfigPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getIllegalFileSuffixMsg() {
        return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u538b\u7f29\u5305\u5b58\u5728\u975e\u6cd5\u6587\u4ef6\u7c7b\u578b\uff08%1$s\uff09\uff0c\u8bf7\u4f7f\u7528%2$s\u683c\u5f0f\u6587\u4ef6\u3002", (String)"TenantLoginConfigPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private String getLoginpageFileNotExistMsg() {
        return ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u538b\u7f29\u5305\u6839\u76ee\u5f55\u6ca1\u6709login_index.js\u6216login_index_m.js\u5165\u53e3\u6587\u4ef6\uff0c\u8bf7\u5904\u7406\u3002", (String)"TenantLoginConfigPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"save", "cancel", "get_common_config", ADVLABEL, ADVCLOSE, ADVOPEN, LINK_ZOON_KEY, "linksettinglabel"});
        AttachmentPanel filePanel = (AttachmentPanel)this.getControl(FILE_PANEL_KEY);
        filePanel.addUploadListener((UploadListener)this);
        AttachmentPanel filePanel1 = (AttachmentPanel)this.getControl(ICONFONT_PANEL_KEY);
        filePanel1.addUploadListener((UploadListener)this);
        AttachmentPanel loginpagefilePanel = (AttachmentPanel)this.getControl(LOGINPAGE_FILE_PANEL_KEY);
        loginpagefilePanel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject event) {
        try {
            this.bindFile2Panel(ATTACH_FILES, FILE_KEY, FILE_PANEL_KEY);
            this.bindFile2Panel(ICONFONT_FILES, ICONFONT_KEY, ICONFONT_PANEL_KEY);
            this.bindFile2Panel(LOGINPAGE_ATTACH_FILES, LOGINPAGE_FILE_KEY, LOGINPAGE_FILE_PANEL_KEY);
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6587\u4ef6\u6570\u636e\u5f02\u5e38", (Object)e);
        }
    }

    private void bindFile2Panel(String fileInfoPageCacheKey, String mcKey, String panelKey) throws Exception {
        List<Map<String, Object>> files;
        String iconfontFileStrs = this.getPageCache().get(fileInfoPageCacheKey);
        if (StringUtils.isEmpty((String)iconfontFileStrs) || "null".equals(iconfontFileStrs)) {
            iconfontFileStrs = LoginMCServiceUtil.getMcData(mcKey);
        }
        if (StringUtils.isNotEmpty((String)iconfontFileStrs) && !"null".equals(iconfontFileStrs) && !CollectionUtils.isEmpty(files = this.getAttachmentFullUrl((List)SerializationUtils.fromJsonString((String)iconfontFileStrs, List.class)))) {
            AttachmentPanel filePanel = (AttachmentPanel)this.getControl(panelKey);
            filePanel.bindData(files);
            this.getPageCache().put(fileInfoPageCacheKey, iconfontFileStrs);
        }
    }

    private List<Map<String, Object>> getAttachmentFullUrl(List<Map<String, Object>> data) {
        String path = "/attachment/download.do?path=/";
        if (data != null && data.size() > 0) {
            data.forEach(map -> {
                String url = (String)map.get(URL);
                if (url.contains(path)) {
                    url = url.substring(url.indexOf(path)).replace(path, "");
                }
                map.put(URL, UrlService.getAttachmentFullUrl((String)url));
            });
        }
        return data;
    }

    public void afterCreateNewData(EventObject event) {
        try {
            List selectList = this.defaultUserSourceTypeSelect();
            boolean isEnableLoginConfig = LoginConfigUtils.isEnableLoginConfig();
            String configData = null;
            if (isEnableLoginConfig) {
                BasLoginConfigServiceImpl basLoginConfigService = new BasLoginConfigServiceImpl();
                BasLoginConfigParam basLoginConfigParam = this.wrapperData(CONFIG_KEY, null);
                BasLoginConfigParam loginConfigParam = basLoginConfigService.get(basLoginConfigParam);
                configData = loginConfigParam.getValue();
                this.getPageCache().put(IS_COMMON, "0");
            }
            if (StringUtils.isEmpty(configData)) {
                configData = LoginMCServiceUtil.getMcData(CONFIG_KEY);
                this.getPageCache().put(IS_COMMON, "1");
            }
            if (StringUtils.isNotEmpty(configData)) {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)configData, Map.class);
                dataMap.forEach((k, v) -> {
                    if (LINK_DATA.equals(k)) {
                        this.getPageCache().put(LINK_KEY, v);
                    } else if (MULTI_LANG_FIELD.contains(k)) {
                        if (v.contains("[") && v.contains("]")) {
                            String multiValue = v.substring(1, v.length() - 1);
                            String[] multivalueArr = multiValue.split(",");
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (String value : multivalueArr) {
                                String[] valueArr = value.split("=");
                                if (valueArr.length == 2) {
                                    map.put(StringUtils.trim((String)valueArr[0]), valueArr[1]);
                                    continue;
                                }
                                map.put(StringUtils.trim((String)valueArr[0]), "");
                            }
                            this.getModel().setValue(k, map);
                        } else {
                            this.getModel().setValue(k, v);
                        }
                    } else {
                        if (k.equals(LOGIN_SOURCE_TYPE_VALUE)) {
                            if (Objects.isNull(v) || StringUtils.isEmpty((String)v)) {
                                v = DEFAULT_SOURCE_TYPE_COSMIC;
                            } else if (!this.isContainSelect(selectList, (String)v)) {
                                v = DEFAULT_SOURCE_TYPE_COSMIC;
                            }
                        } else if (HIDDEN_RESET_PD.equals(k)) {
                            boolean newValue = Boolean.parseBoolean(v);
                            this.getView().setVisible(Boolean.valueOf(!newValue), new String[]{RESET_PD});
                        } else if (SHOWVIEWPWDBTN.equals(k)) {
                            boolean newValue = Boolean.parseBoolean(v);
                            this.getView().setVisible(Boolean.valueOf(newValue), new String[]{"showviewpwdicon"});
                        }
                        this.getModel().setValue(k, v);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u767b\u5f55\u914d\u7f6e\u5f02\u5e38", (Object)e);
        }
        boolean isAdvopen = false;
        if (this.setAdvopen(ATTACH_FILES, FILE_KEY)) {
            isAdvopen = true;
        }
        if (this.setAdvopen(ICONFONT_FILES, ICONFONT_KEY)) {
            isAdvopen = true;
        }
        if (this.setAdvopen(LOGINPAGE_ATTACH_FILES, LOGINPAGE_FILE_KEY)) {
            isAdvopen = true;
        }
        if (!isAdvopen) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADVOPEN, ADV_SETTING_PANEL_KEY});
            this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "false");
        }
    }

    private BasLoginConfigParam wrapperData(String key, String value) {
        BasLoginConfigParam basLoginConfigParam = new BasLoginConfigParam();
        basLoginConfigParam.setIsSynCommon("0");
        basLoginConfigParam.setLocaleid("zh_CN");
        basLoginConfigParam.setKey(key);
        if (StringUtils.isNotEmpty((String)value)) {
            basLoginConfigParam.setValue(value);
        }
        return basLoginConfigParam;
    }

    private boolean setAdvopen(String fileInfoPageCacheKey, String mcKey) {
        String attachFileStrs = "";
        try {
            this.getPageCache().remove(fileInfoPageCacheKey);
            attachFileStrs = LoginMCServiceUtil.getMcData(mcKey);
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6587\u4ef6\u6570\u636e\u5f02\u5e38:" + mcKey, (Object)e);
        }
        if (StringUtils.isNotEmpty((String)attachFileStrs) && !"null".equals(attachFileStrs)) {
            this.getPageCache().put(fileInfoPageCacheKey, attachFileStrs);
            this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "true");
            Label advSettingSwitch = (Label)this.getControl(ADVLABEL);
            advSettingSwitch.setText(this.getDescription());
            this.getView().setVisible(Boolean.FALSE, new String[]{ADVCLOSE});
            this.getView().setVisible(Boolean.TRUE, new String[]{ADVOPEN});
            return true;
        }
        return false;
    }

    private List defaultUserSourceTypeSelect() {
        String tenantAlias = RequestContext.get().getTenantCode();
        List<Account> centerList = new ArrayList(8);
        if (LoginConfigUtils.isEnableLoginConfig()) {
            Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
            centerList.add(account);
        } else {
            centerList = AccountUtils.getAllAccounts((String)tenantAlias);
        }
        if (centerList == null) {
            return null;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(LOGIN_SOURCE_TYPE_VALUE);
        List<ComboItem> list = this.getCaptionMethod(centerList);
        comboEdit.setComboItems(list);
        if (list.isEmpty()) {
            this.getModel().setValue(LOGIN_SOURCE_TYPE_VALUE, (Object)DEFAULT_SOURCE_TYPE_COSMIC);
        }
        return list;
    }

    private List<ComboItem> getCaptionMethod(List<Account> centerList) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(centerList.size());
        for (Account center : centerList) {
            String[] userSourceTypeArr;
            String userSourceTypeOutput = center.getUserSourceTypeOutput();
            if (!userSourceTypeOutput.contains("[") || !userSourceTypeOutput.contains("]")) continue;
            String userSourceTypeStr = userSourceTypeOutput.substring(1, userSourceTypeOutput.length() - 1);
            for (String value : userSourceTypeArr = userSourceTypeStr.split(",")) {
                int type = Integer.parseInt(value);
                String loginSourceTypeValue = UserSourceTypeEnum.getLoginSourceTypeValue(type);
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(loginSourceTypeValue));
                item.setValue(value);
                list.add(item);
            }
        }
        AppParam appParam = new AppParam("83bfebc8000037ac", "15", Long.valueOf(ParameterOrgUtils.getParamRootOrgId()), Long.valueOf(0L));
        Map parameters = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (parameters != null && parameters.containsKey("open_sms_login") && Boolean.parseBoolean(String.valueOf(parameters.get("open_sms_login")))) {
            int type = UserSourceTypeEnum.SMS.getType();
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(UserSourceTypeEnum.getLoginSourceTypeValue(type)));
            item.setValue(String.valueOf(type));
            list.add(item);
        }
        TreeSet<ComboItem> personSet = new TreeSet<ComboItem>((o1, o2) -> o1.getValue().compareTo(o2.getValue()));
        personSet.addAll(list);
        return new ArrayList<ComboItem>(personSet);
    }

    private boolean isContainSelect(List<ComboItem> listSelect, String defaultSourceType) {
        for (ComboItem item : listSelect) {
            if (!defaultSourceType.equals(item.getValue())) continue;
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("save".equals(key)) {
            if (!this.checkSavePermission()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u767b\u5f55\u9875\u914d\u7f6e\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TenantLoginConfigPlugin_17", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            boolean result = this.save2MC();
            String opDesc = result ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TenantLoginConfigPlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TenantLoginConfigPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.writeLog("18XSXYEL8//U", "sys_login_config", ResManager.loadKDString((String)"\u4fee\u6539\u4fdd\u5b58", (String)"TenantLoginConfigPlugin_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u4fee\u6539\u767b\u5f55\u9875\u914d\u7f6e%s", (String)"TenantLoginConfigPlugin_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), opDesc));
        } else if (ADVLABEL.equals(key) || ADVOPEN.equals(key) || ADVCLOSE.equals(key)) {
            Label advSettingSwitch = (Label)this.getControl(ADVLABEL);
            String advPanelStatus = this.getPageCache().get(ADV_SETTING_PANEL_STATUS);
            if (Boolean.parseBoolean(advPanelStatus)) {
                this.hideAdvSettingPanel();
                this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "false");
                advSettingSwitch.setText(ResManager.loadKDString((String)"\u9ad8\u7ea7\u8bbe\u7f6e", (String)"TenantLoginConfigPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{ADVCLOSE});
                this.getView().setVisible(Boolean.FALSE, new String[]{ADVOPEN});
            } else {
                this.showAdvSettingPanel();
                this.getPageCache().put(ADV_SETTING_PANEL_STATUS, "true");
                advSettingSwitch.setText(this.getDescription());
                this.getView().setVisible(Boolean.FALSE, new String[]{ADVCLOSE});
                this.getView().setVisible(Boolean.TRUE, new String[]{ADVOPEN});
            }
        } else if (LINK_ZOON_KEY.equals(key) || "linksettinglabel".equals(key)) {
            this.showSettingForm();
        }
    }

    private boolean checkSavePermission() {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String formId = this.getView().getFormShowParameter().getFormId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)formId, (String)"0=KX5+QVF5+R");
    }

    private void showSettingForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("sys_linksetting");
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "linksetting");
        parameter.setCloseCallBack(closeCallBack);
        try {
            BasLoginConfigServiceImpl basLoginConfigService;
            String configData;
            String linkDataStr = this.getPageCache().get(LINK_KEY);
            if (StringUtils.isEmpty((String)linkDataStr) && StringUtils.isNotEmpty((String)(configData = LoginConfigUtils.getLoginConfigValue(basLoginConfigService = new BasLoginConfigServiceImpl(), CONFIG_KEY)))) {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)configData, Map.class);
                linkDataStr = (String)dataMap.get(LINK_DATA);
            }
            if (StringUtils.isNotEmpty((String)linkDataStr)) {
                List collection = (List)SerializationUtils.fromJsonString((String)linkDataStr, List.class);
                parameter.setCustomParam(LINK_DATA1, (Object)collection);
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u94fe\u63a5\u6570\u636e\u5f02\u5e38", (Object)e);
        }
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map data;
        DynamicObjectCollection collection;
        Map returnData;
        if ("linksetting".equals(evt.getActionId()) && (returnData = (Map)evt.getReturnData()) != null && (collection = (DynamicObjectCollection)(data = (Map)returnData.get("value")).get(LINK_DATA1)) != null) {
            this.getPageCache().put(LINK_KEY, SerializationUtils.toJsonString((Object)collection));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean newValue;
        String propertyName = e.getProperty().getName();
        if (HIDDEN_RESET_PD.equals(propertyName)) {
            newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getView().setVisible(Boolean.valueOf(!newValue), new String[]{RESET_PD});
        }
        if (SHOWVIEWPWDBTN.equals(propertyName)) {
            newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            this.getView().setVisible(Boolean.valueOf(newValue), new String[]{"showviewpwdicon"});
        }
        if (Arrays.asList(imageArray).contains(propertyName)) {
            this.getPageCache().put(IMAGE_FLAG, "true");
        }
    }

    private void createHyperLink(String key, String name, String url) {
        Container linkZoon = (Container)this.getControl(LINK_ZOON_KEY);
        HyperlinkAp hyper = new HyperlinkAp();
        hyper.setKey(key);
        hyper.setId(key);
        hyper.setName(new LocaleString(name));
        hyper.setLinkUrl(url);
        Map runtimeMeta = hyper.createControl();
        ArrayList<Map> items = new ArrayList<Map>();
        items.add(runtimeMeta);
        linkZoon.addControls(items);
    }

    public void upload(UploadEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        Object[] data = evt.getUrls();
        if (data != null && data.length > 0) {
            String flag = "true";
            ArrayList<Object> newFileInfos = new ArrayList<Object>(Arrays.asList(data));
            if (FILE_PANEL_KEY.equals(key)) {
                this.doAfterValidate(VALIDATE, ATTACH_FILES, this.check(newFileInfos), evt, newFileInfos);
            } else if (ICONFONT_PANEL_KEY.equals(key)) {
                this.doAfterValidate(ICONFONT_VALIDATE, ICONFONT_FILES, this.checkAndSetDirIconfont(newFileInfos), evt, newFileInfos);
            } else if (LOGINPAGE_FILE_PANEL_KEY.equals(key)) {
                this.doAfterValidate(LOGINPAGE_VALIDATE, LOGINPAGE_ATTACH_FILES, this.checkLoginIndexFile(newFileInfos), evt, newFileInfos);
            }
        }
    }

    private void doAfterValidate(String validateType, String filesName, boolean validate, UploadEvent evt, List<Object> newFileInfos) {
        this.getPageCache().put(validateType, Boolean.toString(validate));
        if (!validate) {
            evt.setCancel(true);
            evt.setCancelMsg(this.getPageCache().get(validateType + "_tips"));
            return;
        }
        this.getPageCache().put(filesName, SerializationUtils.toJsonString(newFileInfos));
        this.getPageCache().put(filesName + FILECHANGE, "true");
    }

    public void afterUpload(UploadEvent evt) {
    }

    private boolean check(List<Object> newFileInfos) {
        if (newFileInfos == null) {
            return false;
        }
        for (Object newFileInfo : newFileInfos) {
            Map sourceData = (Map)newFileInfo;
            List<FileInfo> fileInfos = this.getFileInfo((String)sourceData.get(URL));
            if (fileInfos.size() == 0) {
                return false;
            }
            if (!this.checkSuffix(FILE_WHITE_LIST, fileInfos, VALIEDATA_TIPS)) {
                return false;
            }
            if (this.checkExist(fileInfos)) continue;
            this.getPageCache().put(VALIEDATA_TIPS, this.getEntryFileNotExistMsg());
            return false;
        }
        return true;
    }

    private boolean checkLoginIndexFile(List<Object> newFileInfos) {
        if (newFileInfos == null) {
            return false;
        }
        for (Object newFileInfo : newFileInfos) {
            Map sourceData = (Map)newFileInfo;
            List<FileInfo> fileInfos = this.getFileInfo((String)sourceData.get(URL));
            if (CollectionUtils.isEmpty(fileInfos)) {
                return false;
            }
            boolean fileExist = fileInfos.stream().map(FileInfo::getFullPath).collect(Collectors.toCollection(ArrayList::new)).containsAll(new ArrayList<String>(Arrays.asList("login_index.js", "login_index_m.js")));
            if (fileExist) continue;
            this.getPageCache().put(LOGINPAGE_VALIEDATA_TIPS, this.getLoginpageFileNotExistMsg());
            return false;
        }
        return true;
    }

    private boolean checkAndSetDirIconfont(List<Object> newFileInfos) {
        if (newFileInfos == null) {
            return false;
        }
        for (Object newFileInfo : newFileInfos) {
            Map sourceData = (Map)newFileInfo;
            List<FileInfo> fileInfos = this.getFileInfo((String)sourceData.get(URL));
            if (fileInfos.size() == 0) {
                return false;
            }
            if (!this.checkSuffix(ICONFONT_FILE_WHITE_LIST, fileInfos, ICONFONT_VALIEDATA_TIPS)) {
                return false;
            }
            if (!this.checkIconfontExist(fileInfos)) {
                return false;
            }
            sourceData.put("dir", fileInfos.get(0).getFullPath());
        }
        return true;
    }

    public void afterRemove(UploadEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (FILE_PANEL_KEY.equals(key)) {
            this.getPageCache().remove(VALIDATE);
            this.getPageCache().remove(ATTACH_FILES);
            this.removeMcData(FILE_KEY, this.getUniqueId(ATTACH_FILES));
        } else if (ICONFONT_PANEL_KEY.equals(key)) {
            this.getPageCache().remove(ICONFONT_VALIDATE);
            this.getPageCache().remove(ICONFONT_FILES);
            this.removeMcData(ICONFONT_KEY, ICONFONT_KEY);
        } else if (LOGINPAGE_FILE_PANEL_KEY.equals(key)) {
            this.getPageCache().remove(LOGINPAGE_VALIDATE);
            this.getPageCache().remove(LOGINPAGE_ATTACH_FILES);
            this.removeMcData(LOGINPAGE_FILE_KEY, this.getUniqueId(LOGINPAGE_ATTACH_FILES));
        }
    }

    private void removeMcData(String mcKey, String webClientKey) {
        try {
            this.setWebClientFiles(null, webClientKey);
            LoginMCServiceUtil.saveMcData(mcKey, "null");
        }
        catch (Exception e) {
            logger.info("TenantLoginConfigPlugin--removeMcData", (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileInfo> getFileInfo(String url) {
        String failedTips = new LocaleString(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\u3002", (String)"TenantLoginConfigPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])).toString();
        InputStream in = null;
        ZipArchiveEntry zipEntry = null;
        ZipArchiveInputStream zipInput = null;
        ArrayList<FileInfo> data = new ArrayList<FileInfo>();
        try {
            in = this.getInputStreamByUrl(url);
            if (in != null) {
                zipInput = new ZipArchiveInputStream(in, "GBK");
                while ((zipEntry = zipInput.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) {
                        data.add(new FileInfo(zipEntry.getName(), null, (ArchiveEntry)zipEntry));
                        continue;
                    }
                    String fileFullPath = zipEntry.getName();
                    int idx = fileFullPath.lastIndexOf(46);
                    String suffix = idx != -1 ? fileFullPath.substring(idx) : null;
                    data.add(new FileInfo(fileFullPath, suffix, (ArchiveEntry)zipEntry));
                }
                if (data.size() == 0) {
                    this.getPageCache().put(VALIEDATA_TIPS, this.getZipNullMsg());
                    this.getView().showErrorNotification(this.getZipNullMsg());
                }
            } else {
                this.getView().showErrMessage(String.format(ResManager.loadKDString((String)"\u6587\u4ef6url: %s", (String)"TenantLoginConfigPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), url), failedTips);
            }
        }
        catch (Exception e) {
            this.getView().showErrMessage(e.getMessage() + "\r\n" + url, failedTips);
        }
        finally {
            try {
                if (zipInput != null) {
                    zipInput.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.getView().showErrMessage(e.getMessage(), failedTips);
            }
        }
        return data;
    }

    private boolean checkSuffix(Set<String> suffix_white_list, List<FileInfo> fileInfos, String tipsKey) {
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo.getSuffix() == null || suffix_white_list.contains(fileInfo.getSuffix().toLowerCase())) continue;
            String tips = String.format(this.getIllegalFileSuffixMsg(), fileInfo.getFullPath(), String.join((CharSequence)"\u3001", suffix_white_list));
            this.getPageCache().put(tipsKey, tips);
            return false;
        }
        return true;
    }

    private boolean checkExist(List<FileInfo> fileInfos) {
        ArrayList fileNames = new ArrayList();
        fileInfos.forEach(fileInfo -> fileNames.add(fileInfo.getFullPath()));
        return fileNames.containsAll(new ArrayList<String>(Arrays.asList("index.js", "index_m.js")));
    }

    private boolean checkIconfontExist(List<FileInfo> fileInfos) {
        boolean hasFontDir = false;
        ArrayList<String> fileNames = new ArrayList<String>(fileInfos.size());
        for (FileInfo fileInfo : fileInfos) {
            String path = fileInfo.getFullPath();
            if ("font/".equals(path)) {
                hasFontDir = true;
            }
            fileNames.add(path);
        }
        if (!hasFontDir) {
            String msg = ResManager.loadKDString((String)"\u538b\u7f29\u6587\u4ef6\u6839\u76ee\u5f55\u4e0b\u9700\u8981\u5305\u542bfont\u76ee\u5f55\u3002", (String)"TenantLoginConfigPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            this.getPageCache().put(ICONFONT_VALIEDATA_TIPS, msg);
            return false;
        }
        boolean isExist = fileNames.containsAll(new ArrayList<String>(Arrays.asList("font/iconfont.css", "font/iconfont.json")));
        if (!isExist) {
            String msg = ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u538b\u7f29\u5305\u91ccfont\u76ee\u5f55\u4e0b\u6ca1\u6709iconfont.css\u6216iconfont.json\u6587\u4ef6\uff0c\u8bf7\u5904\u7406\u3002", (String)"TenantLoginConfigPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            this.getPageCache().put(ICONFONT_VALIEDATA_TIPS, msg);
            return false;
        }
        return true;
    }

    private String save2FileService(String tempUrl, String uid, String fileName) {
        if (this.isTempUrl(tempUrl)) {
            return AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getView().getFormShowParameter().getFormId(), (Object)uid, (String)fileName);
        }
        return tempUrl;
    }

    private String getFileServerFullPath(String path) {
        String uploadPath = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
        return this.getFileServer() + this.encodeUrl(this.addStartSlash(uploadPath));
    }

    private boolean isTempUrl(String url) {
        return StringUtils.isNotEmpty((String)url) && url.contains("tempfile/download.do?configKey");
    }

    private LocalMemoryCache getCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxItemSize(50);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), "custLoginConfig", info);
    }

    private boolean save2MC() {
        this.getView().getActionResult();
        boolean isEnableLoginConfig = LoginConfigUtils.isEnableLoginConfig();
        try {
            this.saveAttachmentData(ATTACH_FILES, FILE_KEY, GLOBAL_PATH, this.getUniqueId(ATTACH_FILES));
            this.saveAttachmentData(ICONFONT_FILES, ICONFONT_KEY, "iconfont", ICONFONT_KEY);
            this.saveAttachmentData(LOGINPAGE_ATTACH_FILES, LOGINPAGE_FILE_KEY, LOGINPAGE_PATH, this.getUniqueId(LOGINPAGE_ATTACH_FILES));
            this.saveImage2MC(isEnableLoginConfig);
            this.saveConfigData(isEnableLoginConfig);
            this.clearLoginPageCache();
        }
        catch (Exception e) {
            logger.info("save2MC error", (Object)e);
            String errorMsg = null;
            String title = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TenantLoginConfigPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            if (e instanceof KDException) {
                errorMsg = this.getErrorMsg(e);
                String message = ResManager.loadKDString((String)"\u53ef\u80fd\u662fMC\u5730\u5740\u914d\u7f6e\u9519\u8bef\u6216MC\u7f51\u7edc\u8bf7\u6c42\u8d85\u65f6\u7b49\u539f\u56e0\u5bfc\u81f4\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u8fdb\u884c\u6392\u67e5\u3002", (String)"TenantLoginConfigPlugin_19", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                title = title + message;
            } else {
                errorMsg = e.getMessage();
            }
            this.getView().showMessage(title, errorMsg, MessageTypes.Default);
            return false;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TenantLoginConfigPlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        return true;
    }

    private void saveConfigData(boolean isEnableLoginConfig) {
        HashMap<String, String> data = new HashMap<String, String>(wordTypeArray.length);
        for (String key : wordTypeArray) {
            Object object = this.getModel().getValue(key);
            if (object == null) continue;
            if (object instanceof OrmLocaleValue) {
                String valueOrm = ((OrmLocaleValue)object).entrySet().toString();
                data.put(key, StringUtils.trim((String)valueOrm));
                continue;
            }
            String value = String.valueOf(object);
            if (IMAGE_FIELD.contains(key)) {
                value = FileServiceExtFactory.getImageFileServiceExt().getRealPath(this.removeVersion(value));
            }
            data.put(key, StringUtils.trim((String)value));
        }
        String linkDataStr = this.getPageCache().get(LINK_KEY);
        if (StringUtils.isNotEmpty((String)linkDataStr)) {
            data.put(LINK_DATA, linkDataStr);
        }
        if (isEnableLoginConfig) {
            BasLoginConfigServiceImpl basLoginConfigService = new BasLoginConfigServiceImpl();
            BasLoginConfigParam basLoginConfigParam = this.wrapperData(CONFIG_KEY, SerializationUtils.toJsonString(data));
            basLoginConfigService.saveOrUpdate(basLoginConfigParam);
        } else {
            LoginMCServiceUtil.saveMcData(CONFIG_KEY, SerializationUtils.toJsonString(data));
        }
    }

    private void writeLog(String bizAppId, String entityId, String opName, String opDesc) {
        AppLogInfo appLogInfo = new AppLogInfo();
        long userId = RequestContext.get().getCurrUserId();
        appLogInfo.setUserID(Long.valueOf(userId));
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setBizAppID(bizAppId);
        appLogInfo.setBizObjID(entityId);
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(opDesc);
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        try {
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
        catch (Exception e) {
            logger.info("TenantLoginConfigPlugin writeLog error", (Object)e);
        }
    }

    private static String getIconFontKey(String key) {
        return Instance.getClusterName() + key + RequestContext.get().getTenantId();
    }

    private void clearLoginPageCache() {
        this.getCache().remove(new String[]{URL_CACHE_KEY});
        this.getPageCache().remove(IMAGE_FLAG);
        String tenantId = RequestContext.get().getTenantId();
        List accountList = AccountUtils.getAllAccounts((String)tenantId);
        CacheLoginData.remove((String)MC, (String)(CONFIG_KEY + tenantId));
        CacheLoginData.remove((String)MC, (String)(FILE_KEY + tenantId));
        CacheLoginData.remove((String)MC, (String)(LOGINPAGE_FILE_KEY + tenantId));
        CacheLoginData.remove((String)MC, (String)(IMAGE_MCDATA + tenantId));
        CacheLoginData.remove((String)MC, (String)(_TENANT_LOGIN_CONFIG + tenantId + "_" + ATTACH_FILES));
        CacheLoginData.remove((String)MC, (String)(_TENANT_LOGIN_CONFIG + tenantId + "_" + LOGINPAGE_ATTACH_FILES));
        LocalMemoryCache localcache = LoginConfigUtils.getCache();
        localcache.remove(new String[]{URL_CACHE_KEY + tenantId});
        iconfontcache.remove(TenantLoginConfigPlugin.getIconFontKey(_MC_ICONFONT_DATA));
        for (Account account : accountList) {
            String accountId = account.getAccountId();
            CacheLoginData.remove((String)MC, (String)(CONFIG_KEY + accountId));
            CacheLoginData.remove((String)MC, (String)(IMAGE_FILE_KEY + accountId));
            CacheLoginData.remove((String)MC, (String)(IMAGE_MCDATA + accountId));
            localcache.remove(new String[]{URL_CACHE_KEY + accountId});
        }
    }

    protected FileService getFileService() {
        return FileServiceFactory.getImageFileService();
    }

    private void saveImage2MC(boolean isEnableLoginConfig) throws Exception {
        boolean needCahnge;
        String mcKey = IMAGE_MCDATA;
        String isChange = this.getPageCache().get(IMAGE_FLAG);
        String isCommon = this.getPageCache().get(IS_COMMON);
        boolean bl = needCahnge = isEnableLoginConfig && "1".equals(isCommon);
        if (Boolean.parseBoolean(isChange) || needCahnge) {
            BasLoginConfigServiceImpl basLoginConfigService = new BasLoginConfigServiceImpl();
            String imageFilePathData = LoginConfigUtils.getLoginConfigValue(basLoginConfigService, mcKey);
            if (StringUtils.isNotEmpty((String)imageFilePathData) && !"null".equals(imageFilePathData)) {
                try {
                    Map dataMap = (Map)SerializationUtils.fromJsonString((String)imageFilePathData, Map.class);
                    String deletePath = (String)dataMap.get(FILE_SERVER_URL);
                    FileService fileService = FileServiceFactory.getAttachmentFileService();
                    fileService.delete(deletePath);
                }
                catch (Exception e) {
                    logger.info("delete error", (Object)e);
                }
            }
            String fileName = "tenantConfigImage" + StringUtils.randomNumber((int)3) + ".zip";
            ArrayList<String> imageNames = new ArrayList<String>(8);
            String path = this.createZipAndUpload(fileName, imageNames, isEnableLoginConfig);
            BasLoginConfigParam basLoginConfigParam = this.wrapperData(mcKey, "null");
            if (path == null) {
                this.setWebClientFiles(null, this.getUniqueId(IMAGE_FILE_KEY));
                if (isEnableLoginConfig) {
                    basLoginConfigService.saveOrUpdate(basLoginConfigParam);
                } else {
                    LoginMCServiceUtil.saveMcData(mcKey, "null");
                }
            } else {
                ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", fileName);
                map.put(FILE_SERVER_URL, this.getFileServer() + path);
                map.put("imageNames", imageNames);
                map.put("version", System.currentTimeMillis());
                map.put(URL, path);
                data.add(map);
                this.saveWithFileServeriOrDownloadPath(data, IMAGE_PATH, this.getUniqueId(IMAGE_FILE_KEY));
                if (isEnableLoginConfig) {
                    basLoginConfigParam.setValue(SerializationUtils.toJsonString(map));
                    basLoginConfigService.saveOrUpdate(basLoginConfigParam);
                } else {
                    LoginMCServiceUtil.saveMcData(mcKey, SerializationUtils.toJsonString(map));
                }
            }
            CacheLoginData.remove((String)MC, (String)(IMAGE_FILE_KEY + RequestContext.get().getTenantId()));
            CacheLoginData.remove((String)MC, (String)(IMAGE_FILE_KEY + RequestContext.get().getAccountId()));
            CacheLoginData.remove((String)MC, (String)(mcKey + RequestContext.get().getTenantId()));
            CacheLoginData.remove((String)MC, (String)(mcKey + RequestContext.get().getAccountId()));
        }
    }

    private String createZipAndUpload(String fileName, List<String> imageNames, boolean isEnableLoginConfig) throws Exception {
        FileOutputStream out = new FileOutputStream(new File(FilenameUtils.getName((String)fileName)));
        boolean hasImg = false;
        BufferedInputStream bis = null;
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            for (String image : imageArray) {
                int count;
                Object url = this.getModel().getValue(image);
                if (url == null || StringUtils.isEmpty((String)url.toString())) continue;
                hasImg = true;
                String imageUrl = this.removeVersion(url.toString());
                imageUrl = FileServiceExtFactory.getImageFileServiceExt().getRealPath(imageUrl);
                String fileType = imageUrl.substring(imageUrl.lastIndexOf(46));
                InputStream inputStream = this.getFileService().getInputStream(imageUrl);
                String imageName = image;
                imageName = isEnableLoginConfig ? imageName + RequestContext.get().getAccountId() + fileType : imageName + RequestContext.get().getTenantId() + fileType;
                imageNames.add(imageName);
                ZipEntry entry = new ZipEntry(imageName);
                zos.putNextEntry(entry);
                int bufferLen = 1024;
                byte[] data = new byte[bufferLen];
                bis = new BufferedInputStream(inputStream);
                while ((count = bis.read(data, 0, bufferLen)) != -1) {
                    zos.write(data, 0, count);
                }
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("createZipAndUpload error", "createZipAndUpload error"), new Object[0]);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                }
            }
        }
        if (hasImg) {
            String path = this.uploadToFileServer(fileName);
            this.deleteFile(fileName);
            return path;
        }
        return null;
    }

    private String removeVersion(String imageUrl) {
        if (imageUrl.contains("?v=")) {
            imageUrl = imageUrl.substring(0, imageUrl.indexOf("?v="));
        } else if (imageUrl.contains("&v=")) {
            imageUrl = imageUrl.substring(0, imageUrl.indexOf("&v="));
        }
        return imageUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadToFileServer(String fileName) throws Exception {
        String string;
        block3: {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(FilenameUtils.getName((String)fileName)));
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                RequestContext rc = RequestContext.get();
                String uuid = UUID.randomUUID().toString().replace("-", "");
                String pathParam = FileNameUtils.getAttachmentFileName((String)rc.getTenantId(), (String)rc.getAccountId(), (Object)uuid, (String)fileName);
                FileItem item = new FileItem(fileName, pathParam, (InputStream)inputStream);
                String path = fileService.upload(item);
                path = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
                string = this.encodeUrl(this.addStartSlash(path));
                if (inputStream == null) break block3;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    TenantLoginConfigPlugin.safeClose(inputStream);
                }
                throw throwable;
            }
            TenantLoginConfigPlugin.safeClose(inputStream);
        }
        return string;
    }

    public static void safeClose(InputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
        }
    }

    private void deleteFile(String fileName) {
        try {
            boolean delete;
            File file = new File(FilenameUtils.getName((String)fileName));
            if (file.exists() && (delete = file.delete())) {
                DisCardUtil.discard();
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    private void saveAttachmentData(String fileInfoPageCacheKey, String mcKey, String destPath, String webClientKey) throws Exception {
        String filechangekey = fileInfoPageCacheKey + FILECHANGE;
        String filechange = this.getPageCache().get(filechangekey);
        if (StringUtils.isEmpty((String)filechange)) {
            return;
        }
        String attachFiles = this.getPageCache().get(fileInfoPageCacheKey);
        if (StringUtils.isNotEmpty((String)attachFiles)) {
            List data = (List)SerializationUtils.fromJsonString((String)attachFiles, List.class);
            boolean isTempUrl = false;
            for (Map map : data) {
                String url = (String)map.get(URL);
                String uid = (String)map.get("uid");
                String name = (String)map.get("name");
                String newURL = this.save2FileService(url, uid, name);
                map.put(URL, this.encodeUrl(newURL));
                map.put("time", "" + System.currentTimeMillis());
                if (!this.isTempUrl(url)) continue;
                map.put(FILE_SERVER_URL, this.getFileServerFullPath(newURL));
                isTempUrl = true;
            }
            if (isTempUrl) {
                this.saveWithFileServeriOrDownloadPath(data, destPath, webClientKey);
            }
            String serialData = SerializationUtils.toJsonString((Object)data);
            LoginMCServiceUtil.saveMcData(mcKey, serialData);
            this.getPageCache().put(fileInfoPageCacheKey, serialData);
        } else {
            this.setWebClientFiles(null, webClientKey);
            LoginMCServiceUtil.saveMcData(mcKey, "null");
        }
        this.getPageCache().remove(filechangekey);
    }

    private String getUniqueId(String suffix) {
        return _TENANT_LOGIN_CONFIG + RequestContext.get().getTenantId() + "_" + suffix;
    }

    private List<Map<String, Object>> getUnionCollectionWithPageCache(List<Object> newFileInfos) {
        String filesFromCacheStr = this.getPageCache().get(ATTACH_FILES);
        if (StringUtils.isNotEmpty((String)filesFromCacheStr)) {
            List filesFromCache = (List)SerializationUtils.fromJsonString((String)filesFromCacheStr, List.class);
            Iterator it = filesFromCache.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                String oldFileId = (String)map.get("uid");
                newFileInfos.forEach(item -> {
                    Map sourceData = (Map)item;
                    if (oldFileId.equals(sourceData.get("uid"))) {
                        it.remove();
                    }
                });
            }
            return filesFromCache.size() > 0 ? filesFromCache : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    private void saveWithFileServeriOrDownloadPath(List<Map<String, Object>> data, String destPath, String key) throws Exception {
        boolean uploadFile = false;
        try {
            uploadFile = MCUploadFileUtil.setWebClientFiles((MCUploadFileDto)this.convertData(data, destPath, key));
        }
        catch (Exception e) {
            logger.info("setWebClientFiles with inputstream error", (Object)e);
        }
        if (uploadFile) {
            return;
        }
        boolean isRelativePath = this.isAttachmentSecondDev(RequestContext.get().getTenantId());
        try {
            this.setWebClientFilesWithRelativePath(data, destPath, key, isRelativePath);
        }
        catch (Exception e) {
            logger.info("setWebClientFiles first error", (Object)e);
            this.setWebClientFilesWithRelativePath(data, destPath, key, !isRelativePath);
        }
    }

    private MCUploadFileDto convertData(List<Map<String, Object>> data, String destPath, String key) {
        if (data == null) {
            return null;
        }
        Map<String, Object> item = data.get(0);
        if (item == null) {
            return null;
        }
        MCUploadFileDto dto = new MCUploadFileDto();
        String url = (String)item.get(URL);
        String name = (String)item.get("name");
        dto.setDestPath(destPath);
        dto.setName(name);
        dto.setServerType("FS");
        dto.setNeedUpdate(true);
        dto.setFileServerPath(url);
        dto.setKeys(key);
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
        dto.setInputStream(inputStream);
        String fileServerUrl = (String)item.get(FILE_SERVER_URL);
        dto.setFileServerPath(fileServerUrl);
        dto.setTenantId(RequestContext.get().getTenantId());
        dto.setDcid(RequestContext.get().getAccountId());
        String isv = ISVServiceHelper.getISVInfo().getId();
        if (StringUtils.isEmpty((String)isv)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TenantLoginConfigPlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u586b\u5199\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"TenantLoginConfigPlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        dto.setIsv(isv);
        return dto;
    }

    private void setWebClientFilesWithRelativePath(List<Map<String, Object>> data, String destPath, String key, boolean isRelativePath) throws Exception {
        List<kd.bos.mc.webclient.File> files = this.getListFile(data, destPath, isRelativePath);
        this.setWebClientFiles(files, key, String.valueOf(isRelativePath));
    }

    private void setWebClientFiles(List<kd.bos.mc.webclient.File> listFile, String key) throws Exception {
        this.setWebClientFiles(listFile, key, null);
    }

    private void setWebClientFiles(List<kd.bos.mc.webclient.File> listFile, String key, String isRelativePath) throws Exception {
        String isv = ISVServiceHelper.getISVInfo().getId();
        if (StringUtils.isEmpty((String)isv)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f00\u53d1\u5546\u6807\u8bc6\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TenantLoginConfigPlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u586b\u5199\u5f00\u53d1\u5546\u6807\u8bc6\u3002", (String)"TenantLoginConfigPlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        WebClientFiles client = new WebClientFiles();
        client.setDcid(RequestContext.get().getAccountId());
        client.setIsv(isv);
        client.setKeys(key);
        client.setTenantId(RequestContext.get().getTenantId());
        client.setFiles(listFile == null ? Collections.EMPTY_LIST : listFile);
        client.setIsRelativePath(isRelativePath);
        LoginMCServiceUtil.getMcService().setWebClientFiles(client);
    }

    private List<kd.bos.mc.webclient.File> getListFile(List<Map<String, Object>> data, String destPath, boolean isAttachmentSecondDev) {
        if (data != null) {
            ArrayList<kd.bos.mc.webclient.File> listFile = new ArrayList<kd.bos.mc.webclient.File>();
            data.forEach(item -> {
                String url;
                if (isAttachmentSecondDev) {
                    url = AttachmentServiceHelper.getEncreptURL((String)("/attachment/download.do?path=/" + item.get(URL).toString()));
                } else {
                    Object value = item.get(FILE_SERVER_URL);
                    String string = url = value == null ? null : value.toString();
                }
                if (url == null) {
                    url = item.get(URL).toString();
                }
                logger.info("for mc url:" + url);
                String name = (String)item.get("name");
                kd.bos.mc.webclient.File file = new kd.bos.mc.webclient.File();
                file.setDestPath(destPath);
                file.setName(name);
                file.setServerType("FS");
                file.setNeedUpdate(true);
                file.setFileServerPath(url);
                listFile.add(file);
            });
            return listFile;
        }
        return Collections.EMPTY_LIST;
    }

    private List<Map<String, Object>> attachNewSessionId(List<Map<String, Object>> data) {
        if (data != null && data.size() > 0) {
            data.forEach(map -> map.put(URL, this.replaceEnableSessionId((String)map.get(URL))));
        }
        return data;
    }

    private String replaceEnableSessionId(String url) {
        String newUrl;
        if (!StringUtils.isNotEmpty((String)url)) {
            return url;
        }
        String _temp_url = url.replace('?', ';');
        String sessionIdStr = "";
        if (_temp_url.contains(";")) {
            String[] arr;
            for (String s : arr = _temp_url.split(";")[1].split("&")) {
                if (!"kdedcba".equals(s.split("=")[0])) continue;
                sessionIdStr = s;
                break;
            }
        }
        if ((newUrl = url.replace(sessionIdStr, "")).endsWith("&")) {
            newUrl = newUrl.substring(0, newUrl.length() - 1);
        }
        return StringUtils.isNotEmpty((String)sessionIdStr) ? AttachmentServiceHelper.getEncreptURL((String)newUrl) : url;
    }

    private String encodeUrl(String url) {
        try {
            return StringUtils.isNotEmpty((String)url) ? URLEncoder.encode(url, StandardCharsets.UTF_8.name()) : url;
        }
        catch (UnsupportedEncodingException e) {
            this.getView().showErrMessage(e.getMessage(), ResManager.loadKDString((String)"URL\u7f16\u7801\u5f02\u5e38\u3002", (String)"TenantLoginConfigPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return url;
        }
    }

    private void hideAdvSettingPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{ADV_SETTING_PANEL_KEY});
    }

    private void showAdvSettingPanel() {
        this.getView().setVisible(Boolean.TRUE, new String[]{ADV_SETTING_PANEL_KEY});
    }

    private String getErrorMsg(Exception e) {
        if (e == null) {
            return "";
        }
        if (e instanceof KDException) {
            KDException kde = (KDException)((Object)e);
            Object[] args = kde.getArgs();
            StringBuilder buf = new StringBuilder();
            if (args != null && args.length > 0) {
                for (Object o : args) {
                    buf.append(o);
                }
            }
            buf.append("\r\n");
            buf.append(kde.getMessage());
            buf.append("\r\n");
            buf.append(kde.getStackTraceMessage());
            return buf.toString();
        }
        return e.getMessage();
    }

    private InputStream getInputStreamByUrl(String url) {
        if (StringUtils.isNotEmpty((String)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            return cache.getInputStream(url);
        }
        return null;
    }

    private String addStartSlash(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static class FileInfo {
        private String fullPath;
        private String suffix;
        private ArchiveEntry zipEntry;

        public FileInfo(String fullPath, String suffix, ArchiveEntry zipEntry) {
            this.fullPath = fullPath;
            this.suffix = suffix;
            this.zipEntry = zipEntry;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public void setFullPath(String fullPath) {
            this.fullPath = fullPath;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public ArchiveEntry getZipEntry() {
            return this.zipEntry;
        }

        public void setZipEntry(ArchiveEntry zipEntry) {
            this.zipEntry = zipEntry;
        }
    }
}

