/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin.custom;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.custom.service.CustomHelpService;

public class CustomHelpPlugin
extends AbstractBillPlugIn
implements ItemClickListener,
BeforeF7SelectListener {
    private static final String LINK_TYPE = "linktype";
    private static final String CONTROL_APPLICATION = "application";
    private static final String CONTROL_BUSOBJECT = "busobject";
    private CustomHelpService customHelpService;

    public void initialize() {
        this.customHelpService = new CustomHelpService(this.getView(), this.getModel(), this.getPageCache());
    }

    public void registerListener(EventObject e) {
        BasedataEdit control = (BasedataEdit)this.getControl(CONTROL_BUSOBJECT);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(CONTROL_APPLICATION);
        basedataEdit.setQFilter(new QFilter("masterid", "is null", null).or("masterid", "=", (Object)" "));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.customHelpService.beforeClosed(e);
    }

    public void afterLoadData(EventObject e) {
        this.customHelpService.bindData();
    }

    public void afterCreateNewData(EventObject e) {
        this.customHelpService.bindData();
    }

    public void afterCopyData(EventObject e) {
        this.customHelpService.bindData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (LINK_TYPE.equals(name)) {
            this.customHelpService.setLinkTypeValue(newValue);
        } else if (CONTROL_APPLICATION.equals(name)) {
            this.customHelpService.bizAppChange(newValue, true);
        } else if (CONTROL_BUSOBJECT.equals(name)) {
            this.customHelpService.bizObjChange(newValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.customHelpService.setRichTextToLongText(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        this.customHelpService.afterDoOperation(args);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        this.customHelpService.bizObjBeforeF7Select(arg0);
    }
}

