/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin.custom.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class CustomHelpService {
    private static final String LINK_TYPE = "linktype";
    private static final String RICH_TEXT = "0";
    private static final String URL_LINK = "1";
    private static final String CONTROL_URL_LINK = "urllink";
    private static final String ON_STATUS = "onstatus";
    private static final String RICH_TEXT_EDITOR_AP = "richtexteditorap";
    private static final String RICH_TEXT_DATA = "richtextdata";
    private static final String CONTROL_APPLICATION = "application";
    private static final String HTML_CONTENT = "htmlcontent";
    private static final String RICH_TEXT_DATA_TAG = "richtextdata_tag";
    private static final String FLEX_PANEL_AP2 = "flexpanelap2";
    private static final String FLEX_PANEL_AP1 = "flexpanelap1";
    private static final String FLEX_PANEL_AP = "flexpanelap";
    private static final String IFRAME_AP = "iframeap";
    private static final String OP_STATUS_UP = "donothingup";
    private static final String OP_STATUS_DOWN = "donothingdown";
    private static final String STATUS_UN = "B";
    private static final String STATUS_ON = "A";
    private static final String STATUS_DOWN = "C";
    private static final String CONTROL_BUSOBJECT = "busobject";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String DISABLE_COLUMN = "mulititle,application,busobject,helptype,label,weight,linktype,urllink,richtexteditorap";
    private static final String DISABLE_BTN = "btnsave,btnsaveandnew";
    private static final String REFRESH = "refresh";
    private static Log logger = LogFactory.getLog(CustomHelpService.class);
    private IFormView view;
    private IDataModel model;
    private IPageCache pageCache;

    public CustomHelpService(IFormView view, IDataModel model, IPageCache pageCache) {
        this.view = view;
        this.model = model;
        this.pageCache = pageCache;
    }

    public void bindData() {
        Object value;
        if (STATUS_ON.equals(this.model.getValue(ON_STATUS))) {
            this.setAbleValue(false);
        }
        if (STATUS_DOWN.equals(this.model.getValue(ON_STATUS))) {
            this.setAbleValue(true);
        }
        if (null != (value = this.model.getValue(LINK_TYPE)) && StringUtils.isNotEmpty((String)((String)value))) {
            this.setLinkTypeValue(value);
        } else {
            this.view.setVisible(Boolean.valueOf(false), new String[]{CONTROL_URL_LINK, RICH_TEXT_EDITOR_AP});
        }
        this.bizAppChange(this.model.getValue(CONTROL_APPLICATION), false);
    }

    private void setAbleValue(boolean b) {
        this.view.setEnable(Boolean.valueOf(b), DISABLE_COLUMN.split(","));
        this.view.setVisible(Boolean.valueOf(b), DISABLE_BTN.split(","));
    }

    public void setLinkTypeValue(Object value) {
        if (RICH_TEXT.equals(value)) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{RICH_TEXT_EDITOR_AP});
            this.view.setVisible(Boolean.valueOf(false), new String[]{CONTROL_URL_LINK});
            RichTextEditor richtexteditorap = (RichTextEditor)this.view.getControl(RICH_TEXT_EDITOR_AP);
            LargeTextEdit richtextdata = (LargeTextEdit)this.view.getControl(RICH_TEXT_DATA);
            String tagFieldKey = richtextdata.getTagFieldKey();
            Object value1 = this.model.getValue(tagFieldKey);
            String text = null == value1 ? "" : String.valueOf(value1);
            richtexteditorap.setText(text);
            this.model.setValue(CONTROL_URL_LINK, (Object)"-");
        } else if (URL_LINK.equals(value)) {
            Object modelValue = this.model.getValue(CONTROL_URL_LINK);
            if ("-".equals(modelValue)) {
                this.model.setValue(CONTROL_URL_LINK, (Object)"");
            }
            this.view.setVisible(Boolean.valueOf(true), new String[]{CONTROL_URL_LINK});
            this.view.setVisible(Boolean.valueOf(false), new String[]{RICH_TEXT_EDITOR_AP});
        }
    }

    public void selectRowsSave(AfterDoOperationEventArgs evt) {
        String itemKey = evt.getOperateKey();
        if (OP_STATUS_UP.equals(itemKey)) {
            this.selectDataSave(STATUS_ON);
        } else if (OP_STATUS_DOWN.equals(itemKey)) {
            this.selectDataSave(STATUS_DOWN);
        }
    }

    private void selectDataSave(String status) {
        IListView listView = (IListView)this.view;
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.size() < 1) {
            return;
        }
        List primaryKeys = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        Object[] objects = primaryKeys.stream().toArray();
        DynamicObject[] customHelpPageLists = BusinessDataServiceHelper.load((Object[])objects, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"custom_help_page_list"));
        Map<String, List<DynamicObject>> statusMap = Arrays.stream(customHelpPageLists).collect(Collectors.groupingBy(v -> v.getString(ON_STATUS)));
        ArrayList dynamicObjects = new ArrayList(32);
        if (STATUS_ON.equals(status)) {
            if (null != statusMap.get(STATUS_DOWN)) {
                dynamicObjects.addAll(statusMap.get(STATUS_DOWN));
            }
            if (null != statusMap.get(STATUS_UN)) {
                dynamicObjects.addAll(statusMap.get(STATUS_UN));
            }
        } else if (null != statusMap.get(STATUS_ON)) {
            dynamicObjects.addAll(statusMap.get(STATUS_ON));
        }
        if (dynamicObjects.size() < 1) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\uff0c\u65e0\u9700\u91cd\u590d\u542f\u7528\u3002", (String)"CustomHelpListPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            if (!STATUS_ON.equals(status)) {
                msg = statusMap.size() > 1 ? ResManager.loadKDString((String)"\u6570\u636e\u672a\u542f\u7528\uff0c\u65e0\u9700\u7981\u7528\u3002", (String)"CustomHelpListPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : (statusMap.get(STATUS_DOWN) != null && statusMap.get(STATUS_DOWN).size() > 0 ? ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u65e0\u9700\u91cd\u590d\u7981\u7528\u3002", (String)"CustomHelpListPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u672a\u542f\u7528\uff0c\u65e0\u9700\u7981\u7528\u3002", (String)"CustomHelpListPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            this.view.showTipNotification(msg);
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set(ON_STATUS, (Object)status);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        String message = STATUS_ON.equals(status) ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CustomHelpListPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CustomHelpListPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        this.view.showSuccessNotification(message);
        ((IListView)this.view).refresh();
    }

    public void showCustomHelpView(EventObject e) {
        try {
            FormShowParameter formShowParameter = this.view.getFormShowParameter();
            Map params = formShowParameter.getCustomParams();
            String key = (String)params.get("key");
            Long id = Long.parseLong(key);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"custom_help_page_list", (String)"onstatus,linktype,urllink,richtextdata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            this.showByTypeAndStatus(dynamicObject);
        }
        catch (Exception exp) {
            logger.info("showCustomHelpView error", (Object)exp);
        }
    }

    private void showByTypeAndStatus(DynamicObject dynamicObject) {
        if (!STATUS_ON.equals(dynamicObject.getString(ON_STATUS))) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{FLEX_PANEL_AP2});
        } else if (RICH_TEXT.equals(dynamicObject.getString(LINK_TYPE))) {
            this.view.setVisible(Boolean.valueOf(true), new String[]{FLEX_PANEL_AP1});
            RichTextEditor richTextEditor = (RichTextEditor)this.view.getControl(RICH_TEXT_EDITOR_AP);
            richTextEditor.setText(dynamicObject.getString(RICH_TEXT_DATA_TAG));
        }
    }

    public void setPageCache(String key, String value) {
        this.pageCache.put(key, value);
    }

    public void bizAppChange(Object newValue, boolean change) {
        if (newValue instanceof DynamicObject) {
            DynamicObject value = (DynamicObject)newValue;
            String appId = value.getString("id");
            this.setPageCache("busobject_newValue", appId);
            String bizAppIdFromObj = this.pageCache.get("bizappid.id");
            if (!appId.equals(bizAppIdFromObj) && change) {
                this.model.setValue(CONTROL_BUSOBJECT, null);
            }
        } else {
            this.setPageCache("busobject_newValue", null);
        }
    }

    public void bizObjChange(Object newValue) {
        if (newValue instanceof DynamicObject) {
            DynamicObject value = (DynamicObject)newValue;
            this.pageCache.put("bizappid.id", value.getString("bizappid.id"));
            this.model.setValue(CONTROL_APPLICATION, value.get("bizappid.id"));
        }
    }

    public void setRichTextToLongText(BeforeDoOperationEventArgs args) {
        FormOperate save = (FormOperate)args.getSource();
        String operateKey = save.getOperateKey();
        if ("save".equals(operateKey)) {
            this.model.setValue("helptype", (Object)URL_LINK);
            RichTextEditor richtexteditorap = (RichTextEditor)this.view.getControl(RICH_TEXT_EDITOR_AP);
            LargeTextEdit richtextdata = (LargeTextEdit)this.view.getControl(RICH_TEXT_DATA);
            String tagFieldKey = richtextdata.getTagFieldKey();
            String text = richtexteditorap.getText();
            this.model.setValue(tagFieldKey, (Object)text);
            this.model.setValue(ON_STATUS, (Object)STATUS_DOWN);
        }
    }

    public void bizObjBeforeF7Select(BeforeF7SelectEvent arg0) {
        String value = this.pageCache.get("busobject_newValue");
        if (!StringUtils.isEmpty((String)value)) {
            arg0.getFormShowParameter().setCustomParam("treeRootNodeId", (Object)value);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (STATUS_ON.equals(this.model.getValue(ON_STATUS))) {
            e.setCheckDataChange(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey = args.getOperateKey();
        if (OP_STATUS_UP.equals(itemKey) || OP_STATUS_DOWN.equals(itemKey)) {
            DynamicObject dynamicObject = this.getDynamicObject();
            if (null == dynamicObject) {
                return;
            }
            this.checkStatusAndSave(dynamicObject, itemKey);
            this.view.invokeOperation(REFRESH);
        }
    }

    private void checkStatusAndSave(DynamicObject dynamicObject, String itemKey) {
        String msg = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CustomHelpListPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        if (OP_STATUS_UP.equals(itemKey)) {
            if (STATUS_ON.equals(dynamicObject.get(ON_STATUS))) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u542f\u7528\uff0c\u65e0\u9700\u91cd\u590d\u542f\u7528\u3002", (String)"CustomHelpListPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            dynamicObject.set(ON_STATUS, (Object)STATUS_ON);
        }
        if (OP_STATUS_DOWN.equals(itemKey)) {
            if (STATUS_DOWN.equals(dynamicObject.get(ON_STATUS))) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u65e0\u9700\u91cd\u590d\u7981\u7528\u3002", (String)"CustomHelpListPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            dynamicObject.set(ON_STATUS, (Object)STATUS_DOWN);
            msg = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CustomHelpListPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.view.showSuccessNotification(msg);
    }

    private DynamicObject getDynamicObject() {
        Object id = this.model.getValue("id");
        if (ObjectUtils.isEmpty((Object)id) || id.equals(0L)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"CustomHelpListPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"custom_help_page_list");
    }
}

