/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin.pwd;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.DefaultPwdUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class DefaultPwdService {
    public static final String DEFAULT_KEY = "default_pwd";
    public static final String CONFIRM_KEY = "confirm_pwd";
    public static final String DEFAULT_KEY_ENCRYPT = "default_pwd_encrypt";
    public static final String CONFIRM_KEY_ENCRYPT = "confirm_pwd_encrypt";
    public static final String ENCRYPT = "is_encrypt";
    public static final String TOOLBARAP = "toolbarap";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_EDIT = "btn_edit";
    public static final String BTN_RETURN = "btn_return";
    public static final String BTN_CLOSE = "btn_close";
    private static final String STATUS = "status";
    private static final String EDIT = "edit";
    private static final String RETURN = "return";
    private static final String regex = "^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%^&+=])(?=\\S+$).{8,50}$";
    protected static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String DIV_STYLE_FONT_SIZE = "<div style=\"font-size: 14px; margin-left: 48px; margin-top: 8px;\">";
    private static final String DIV = "</div>";
    private static final String SPAN_STYLE_FONT_WEIGHT_BOLD = "<span style=\"font-weight: bold;\">";
    private static final String SPAN = "</span>";
    public static final String HTMLAP = "htmlap";
    public static final String SHOW = "show";
    public static final String LABEL = "_label";
    public static final String SAVEKEY = "savepwd";
    public static final String LOGIN_DEFAULT_KEY = "login_default_pwd";
    private static List<String> pwdList = new ArrayList<String>(4);
    private static Log logger;
    private IFormView view;
    private IDataModel model;
    private IPageCache pageCache;

    public DefaultPwdService(IFormView view, IDataModel model, IPageCache pageCache) {
        this.view = view;
        this.model = model;
        this.pageCache = pageCache;
    }

    public void textClick(EventObject evt) {
        Control source = (Control)evt.getSource();
        this.showPwdName(source.getKey());
    }

    private void showPwdName(String clickName) {
        switch (clickName) {
            case "close_eye": {
                this.model.setValue(DEFAULT_KEY, this.model.getValue(DEFAULT_KEY_ENCRYPT));
                this.view.setVisible(Boolean.FALSE, new String[]{"default_pwd_encrypt_flex"});
                this.view.setVisible(Boolean.TRUE, new String[]{"default_pwd_flex"});
                this.pageCache.put("default_pwdshow", DEFAULT_KEY);
                break;
            }
            case "open_eye": {
                this.model.setValue(DEFAULT_KEY_ENCRYPT, this.model.getValue(DEFAULT_KEY));
                this.view.setVisible(Boolean.FALSE, new String[]{"default_pwd_flex"});
                this.view.setVisible(Boolean.TRUE, new String[]{"default_pwd_encrypt_flex"});
                this.pageCache.put("default_pwdshow", DEFAULT_KEY_ENCRYPT);
                break;
            }
            case "open_eye_confirm": {
                this.model.setValue(CONFIRM_KEY_ENCRYPT, this.model.getValue(CONFIRM_KEY));
                this.view.setVisible(Boolean.FALSE, new String[]{"confirm_pwd_flex"});
                this.view.setVisible(Boolean.TRUE, new String[]{"confirm_pwd_encrypt_flex"});
                this.pageCache.put("confirm_pwdshow", DEFAULT_KEY_ENCRYPT);
                break;
            }
            case "close_eye_confirm": {
                this.model.setValue(CONFIRM_KEY, this.model.getValue(CONFIRM_KEY_ENCRYPT));
                this.view.setVisible(Boolean.FALSE, new String[]{"confirm_pwd_encrypt_flex"});
                this.view.setVisible(Boolean.TRUE, new String[]{"confirm_pwd_flex"});
                this.pageCache.put("confirm_pwdshow", DEFAULT_KEY_ENCRYPT);
                break;
            }
        }
    }

    public void renderData() {
        String msg = String.format(ResManager.loadKDString((String)"%1$s\u987b\u77e5\uff1a%2$s%3$s1.\u9ed8\u8ba4\u521d\u59cb\u5bc6\u7801\u4e3a123456\uff0c%4$s\u4ec5\u652f\u6301\u4fee\u6539\u4e00\u6b21\u521d\u59cb\u5bc6\u7801\uff0c%5$s\u4fee\u6539\u540e\u5c06\u65e0\u6cd5\u518d\u6b21\u4fee\u6539\uff0c\u8bf7%6$s\u8c28\u614e%7$s\u64cd\u4f5c\u3002%8$s%9$s2.\u4fee\u6539\u521d\u59cb\u5bc6\u7801\u5f3a\u5ea6\u8981\u6c42\u6700\u5c0f\u957f\u5ea68\u4f4d\uff0c\u4e14\u5305\u542b\u6570\u5b57\u3001\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u7279\u6b8a\u5b57\u7b26\u3002%10$s%11$s3.\u521d\u59cb\u5bc6\u7801\u5c5e\u4e8e\u6fc0\u6d3b\u524d\u5bc6\u7801\uff0c\u7528\u6237%12$s\u9996\u6b21\u767b\u5f55\u65f6%13$s\u9700\u901a\u8fc7%14$s\u77ed\u4fe1\u6216\u90ae\u7bb1\u9a8c\u8bc1\u7801%15$s\u9a8c\u8bc1\u7528\u6237\u8eab\u4efd\u5e76\u5f3a\u5236\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801\u3002%16$s%17$s4.\u4fee\u6539\u540e\u7684\u521d\u59cb\u5bc6\u7801\u4ec5\u5bf9\u65b0\u7528\u6237\u751f\u6548\uff0c\u5386\u53f2\u7528\u6237\u4fdd\u7559\u539f\u5bc6\u7801\u3002%18$s", (String)"DefaultPwdService_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), DIV_STYLE_FONT_SIZE, DIV, DIV_STYLE_FONT_SIZE, SPAN_STYLE_FONT_WEIGHT_BOLD, SPAN, SPAN_STYLE_FONT_WEIGHT_BOLD, SPAN, DIV, DIV_STYLE_FONT_SIZE, DIV, DIV_STYLE_FONT_SIZE, SPAN_STYLE_FONT_WEIGHT_BOLD, SPAN, SPAN_STYLE_FONT_WEIGHT_BOLD, SPAN, DIV, DIV_STYLE_FONT_SIZE, DIV);
        Html html = (Html)this.view.getControl(HTMLAP);
        html.setConent(msg);
    }

    private String getDefaultPassWord() {
        try {
            String defaultPwd = this.getDefaultPwdFromMc();
            if (StringUtils.isNotBlank((CharSequence)defaultPwd)) {
                return defaultPwd;
            }
        }
        catch (Exception e) {
            logger.info("getDefaultPwdFromMc", (Object)e);
        }
        return DefaultParameterService.getDefaultValueByKey((String)DEFAULT_KEY);
    }

    private String getDefaultPwdFromMc() {
        return DefaultPwdUtils.getDefaultPwd((String)(RequestContext.get().getAccountId() + LOGIN_DEFAULT_KEY));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args, AbstractFormPlugin formPlugin) {
        String opKey = args.getOperateKey();
        if (EDIT.equals(opKey)) {
            if (!this.isAdminUser()) {
                this.showNotAdminMsg();
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDefaultPwdFromMc())) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5bc6\u7801\u4ec5\u5141\u8bb8\u4fee\u6539\u4e00\u6b21\uff0c\u65e0\u6cd5\u518d\u6b21\u4fee\u6539\u3002", (String)"DefaultPwdService_21", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.showEditView();
            this.pageCache.put(STATUS, EDIT);
        } else if (RETURN.equals(opKey)) {
            this.view.setVisible(Boolean.FALSE, new String[]{BTN_SAVE, BTN_RETURN, "confirm_pwd_flex", "confirm_pwd_encrypt_flex", "default_pwd_flex"});
            this.view.setVisible(Boolean.TRUE, new String[]{BTN_EDIT, BTN_CLOSE, "default_pwd_encrypt_flex"});
            this.model.setValue(DEFAULT_KEY_ENCRYPT, (Object)this.getDefaultPassWord());
            this.view.setEnable(Boolean.FALSE, new String[]{DEFAULT_KEY, DEFAULT_KEY_ENCRYPT});
        } else if (SAVEKEY.equals(opKey)) {
            String input = this.pageCache.get("is_encryptdefault_pwd");
            if (StringUtils.isBlank((CharSequence)input)) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u521d\u59cb\u5bc6\u7801\u3002", (String)"DefaultPwdService_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (this.checkPsw(input)) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\u53ca\u4e2d\u6587\u5b57\u7b26\u3002", (String)"DefaultPwdService_22", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String confirm = this.pageCache.get("is_encryptconfirm_pwd");
            if (StringUtils.isBlank((CharSequence)confirm)) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u786e\u8ba4\u521d\u59cb\u5bc6\u7801\u3002", (String)"DefaultPwdService_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!input.matches(regex)) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u8981\u6c42\u6700\u5c0f\u957f\u5ea68\u4f4d\uff0c\u4e14\u5305\u542b\u6570\u5b57\u3001\u5927\u5c0f\u5199\u5b57\u6bcd\u3001\u7279\u6b8a\u5b57\u7b26\u3002", (String)"DefaultPwdService_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!input.equals(confirm)) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DefaultPwdService_17", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(SAVEKEY, (IFormPlugin)formPlugin);
            String tip = ResManager.loadKDString((String)"\u521d\u59cb\u5bc6\u7801\u4ec5\u5141\u8bb8\u4fee\u6539\u4e00\u6b21\uff0c\u6b64\u6b21\u4fee\u6539\u540e\u5c06\u65e0\u6cd5\u518d\u6b21\u4fee\u6539\uff0c\u786e\u8ba4\u8981\u4fee\u6539\u5417\uff1f", (String)"DefaultPwdService_18", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            this.view.showConfirm(tip, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
        }
    }

    private boolean checkPsw(String password) {
        String pattern = "\\s{1,}";
        String[] split = password.split(pattern);
        return StringUtils.isBlank((CharSequence)password) || split.length > 1 || !password.equals(password.trim()) || this.isContainChineseChar(password);
    }

    private boolean isContainChineseChar(String value) {
        String pattern = "[^\\x00-\\xff]{1,}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(value);
        return m.find();
    }

    private void showEditView() {
        this.view.setVisible(Boolean.FALSE, new String[]{BTN_EDIT, BTN_CLOSE});
        this.view.setVisible(Boolean.TRUE, new String[]{BTN_SAVE, BTN_RETURN, "confirm_pwd_encrypt_flex"});
        this.view.setEnable(Boolean.TRUE, new String[]{DEFAULT_KEY, DEFAULT_KEY_ENCRYPT});
        for (String s : pwdList) {
            this.model.setValue(s, (Object)"");
        }
    }

    private void showNotAdminMsg() {
        this.view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5bc6\u7801\u4ec5\u8d85\u7ea7\u7ba1\u7406\u5458\u53ef\u4fee\u6539\u3002", (String)"DefaultPwdService_20", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private boolean isAdminUser() {
        return PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId(), (String)"10");
    }

    public void changeValue(PropertyChangedArgs e) {
        if (!EDIT.equals(this.pageCache.get(STATUS))) {
            return;
        }
        String name = e.getProperty().getName();
        if (DEFAULT_KEY.equals(name) || DEFAULT_KEY_ENCRYPT.equals(name)) {
            this.pageCache.put("is_encryptdefault_pwd", (String)e.getChangeSet()[0].getNewValue());
        }
        if (CONFIRM_KEY.equals(name) || CONFIRM_KEY_ENCRYPT.equals(name)) {
            this.pageCache.put("is_encryptconfirm_pwd", (String)e.getChangeSet()[0].getNewValue());
        }
    }

    public void beforeBindData() {
        this.view.setVisible(Boolean.FALSE, new String[]{"default_pwd_flex", "confirm_pwd_encrypt_flex", "confirm_pwd_flex", BTN_SAVE, BTN_RETURN});
        this.model.setValue(DEFAULT_KEY_ENCRYPT, (Object)this.getDefaultPassWord());
        this.view.setEnable(Boolean.FALSE, new String[]{DEFAULT_KEY, DEFAULT_KEY_ENCRYPT});
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (StringUtils.equalsIgnoreCase((CharSequence)SAVEKEY, (CharSequence)event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            try {
                String accountId = RequestContext.get().getAccountId();
                String encrypt = DefaultPwdUtils.AESEncrypt((String)this.pageCache.get("is_encryptdefault_pwd"), (String)accountId);
                DefaultPwdUtils.saveMcData((String)(accountId + LOGIN_DEFAULT_KEY), (String)encrypt);
                this.view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OpConfirmListPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                this.view.setVisible(Boolean.TRUE, new String[]{"default_pwd_encrypt_flex", BTN_EDIT, BTN_CLOSE});
                this.view.updateView();
            }
            catch (Exception e) {
                logger.info("saveMcData", (Object)e);
            }
        }
    }

    public void addClickListener(AbstractFormPlugin defaultPwdPlugin) {
        TextEdit defaultPwd = (TextEdit)this.view.getControl(DEFAULT_KEY);
        TextEdit confirmPwd = (TextEdit)this.view.getControl(CONFIRM_KEY);
        TextEdit defaultPwdE = (TextEdit)this.view.getControl(DEFAULT_KEY_ENCRYPT);
        TextEdit confirmPwdE = (TextEdit)this.view.getControl(CONFIRM_KEY_ENCRYPT);
        Toolbar toolbar = (Toolbar)this.view.getControl(TOOLBARAP);
        toolbar.addClickListener((ClickListener)defaultPwdPlugin);
        defaultPwd.addClickListener((ClickListener)defaultPwdPlugin);
        confirmPwd.addClickListener((ClickListener)defaultPwdPlugin);
        defaultPwdE.addClickListener((ClickListener)defaultPwdPlugin);
        confirmPwdE.addClickListener((ClickListener)defaultPwdPlugin);
    }

    static {
        pwdList.add(DEFAULT_KEY);
        pwdList.add(CONFIRM_KEY);
        pwdList.add(DEFAULT_KEY_ENCRYPT);
        pwdList.add(CONFIRM_KEY_ENCRYPT);
        logger = LogFactory.getLog(DefaultPwdService.class);
    }
}

