/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.plugin.yzj;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.yunzhijia.YZJSpecialUtils;
import kd.bos.portal.plugin.yzj.YZJContext;
import kd.bos.portal.plugin.yzj.enums.YzjAppEnum;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import org.apache.commons.lang.StringUtils;

public class BaseYZJPlugin
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(BaseYZJPlugin.class);
    private String appID = null;
    private String formId;

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public void setAppID(String appId) {
        this.appID = appId;
    }

    public String getAppID() {
        return this.appID;
    }

    public void initialize() {
        super.initialize();
        if (this.appID == null) {
            String bosAppNum = this.getView().getFormShowParameter().getAppId();
            this.appID = YzjAppEnum.getYzjAppIdByBosAppNum(bosAppNum);
        }
    }

    public static String getURLParamCacheKey(String appId) {
        String key = "";
        if (RequestContext.get() != null) {
            key = "urlparam_" + RequestContext.get().getGlobalSessionId() + appId;
        }
        return key;
    }

    public void afterBindData(EventObject e) {
        this.doYZJ();
    }

    public static String getYzjUrl(String appID) throws Exception {
        String urlParam = "";
        if (YZJContext.get() != null && StringUtils.isNotEmpty((String)YZJContext.get().getUrlParams())) {
            urlParam = YZJContext.get().getUrlParams();
        }
        return BaseYZJPlugin.getYzjUrl(appID, urlParam);
    }

    public static String getYzjUrlByUrlParams(String yzjAppid) throws Exception {
        String permit;
        String urlParam = "";
        if (YZJContext.get() != null && StringUtils.isNotEmpty((String)YZJContext.get().getUrlParams())) {
            boolean urlFlag;
            String urlParams = YZJContext.get().getUrlParams();
            boolean bl = urlFlag = urlParams.startsWith("http://") || urlParams.startsWith("https://");
            urlParam = urlFlag ? BaseYZJPlugin.addParam(urlParams, "lang=", RequestContext.get().getLang().name()) : BaseYZJPlugin.getYzjUrl(yzjAppid);
        } else {
            urlParam = BaseYZJPlugin.getYzjUrl(yzjAppid);
        }
        String systemEnv = BaseYZJPlugin.getSystemEnv();
        urlParam = BaseYZJPlugin.addParam(urlParam, "systemEnv=", systemEnv);
        Account account = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
        if (YZJSpecialUtils.hasYZJSpecialVersion((Account)account) && kd.bos.util.StringUtils.isNotEmpty((String)(permit = YZJSpecialUtils.visitPermit((Account)account, (String)RequestContext.get().getUserOpenId())))) {
            urlParam = urlParam + "&Ticket=" + permit;
        }
        return urlParam;
    }

    private static String addParam(String urlParam, String param, String value) {
        String url = "";
        url = urlParam.contains("?") ? urlParam + "&" + param + value : urlParam + "?" + param + value;
        return url;
    }

    public static String getYzjUrl(String appID, String urlParam) throws Exception {
        String yzjUrl = "";
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        Account currentCenter = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        if (YZJSpecialUtils.hasYZJSpecialVersion((Account)currentCenter)) {
            yzjUrl = BaseYZJPlugin.getYZJAppUrl(currentCenter, appID, urlParam);
        }
        return yzjUrl;
    }

    private static String getYZJAppUrl(Account currentCenter, String appID, String urlParam) throws UnsupportedEncodingException {
        String yzjUrl = YZJSpecialUtils.getYZJAppUrl((Account)currentCenter, (String)"", (String)appID, null);
        String systemEnv = BaseYZJPlugin.getSystemEnv();
        logger.debug("systemEnv:" + systemEnv);
        StringBuilder sb = new StringBuilder(yzjUrl);
        String split = yzjUrl.contains("?") ? "&" : "?";
        sb.append(split).append("systemEnv=").append(systemEnv);
        if (StringUtils.isNotEmpty((String)urlParam)) {
            sb.append("&urlParam=").append(URLEncoder.encode(urlParam, "UTF-8"));
        }
        sb.append("&lang=").append(RequestContext.get().getLang().name());
        return sb.toString();
    }

    private static String getSystemEnv() {
        String systemEnv = "cosmic";
        List productInfos = LicenseServiceHelper.getProductInfos();
        logger.debug("yzjProdInfo:" + productInfos);
        List prodIds = productInfos.stream().map(v -> (String)v.get("prodid")).collect(Collectors.toList());
        if (prodIds.contains("1I6CUBKTC4GY")) {
            systemEnv = "constellation";
        } else if (prodIds.contains("2D3=SA5XL/92")) {
            systemEnv = "galaxy";
        }
        return systemEnv;
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject jObj;
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if ("showTRDForm".equals(eventName) && StringUtils.isNotEmpty((String)eventArgs) && "error".equals((jObj = JSON.parseObject((String)eventArgs)).getString("status"))) {
            String appId = "wklw_t";
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", this.getView());
            map.put("appname", app.getName());
            map.put("appmainnumber", app.getHomeNum());
            OpenPageUtils.openApp(app.getNumber(), "", map, this.getView());
        }
    }

    private void doYZJ() {
        IFrame iFrame = (IFrame)this.getControl("iframeap");
        try {
            String yzjUrl;
            String urlParam = this.getView().getMainView().getPageCache().get(BaseYZJPlugin.getURLParamCacheKey(this.appID));
            logger.debug("urlParam:::" + urlParam);
            if (StringUtils.isNotEmpty((String)urlParam)) {
                this.getView().getMainView().getPageCache().remove(BaseYZJPlugin.getURLParamCacheKey(this.appID));
                YZJContext context = YZJContext.get();
                context.setUrlParams(urlParam);
            }
            if (StringUtils.isNotEmpty((String)(yzjUrl = BaseYZJPlugin.getYzjUrl(this.appID)))) {
                iFrame.setSrc(yzjUrl);
            }
            iFrame.setSrc(yzjUrl);
        }
        catch (Exception e1) {
            logger.info("doYZJ", (Object)e1);
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u793a", (String)"BaseYZJPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0b\u6e38\u7cfb\u7edf\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BaseYZJPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]), MessageTypes.Default);
        }
    }
}

