/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.pluginnew;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.FilterSchemeL;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.util.StringUtils;

public class BillStatsConfigPlugin
extends AbstractFormPlugin {
    public static final String FFORMID = ":FFORMID";
    public static final String SCALE = "scale";
    public static final String CARDTITLE = "cardtitle";
    public static final String FORMNAME = "formname";
    public static final String NUMCOLOR = "numcolor";
    public static final String FILTERSCHEMA = "filterschema";
    public static final String APPNUM = "appnum";
    public static final String FORMNUM = "formnum";
    public static final String RADIOGROUPFIELD = "radiogroupfield";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String DATA_TYPE = "dataType";
    public static final String NUMTITLE = "numtitle";
    public static final String MENUID = "menuid";
    public static final String COUNT = "count";
    public static final String UNIT = "unit";
    private static Log logger = LogFactory.getLog(BillStatsConfigPlugin.class);
    public static final String BTN_PRE = "btn_pre";
    public static final String BTN_FINISH = "btn_finish";
    public static final String COMBO_SUMFIELD = "cbo_sumfield";
    public static final String SOURCE_BILLSTATSLIST = "billstatslist";
    private static final String COLSECALLBACK_ID_SELBILLFORM = "SelectBillForm";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn_pre = (Button)this.getControl(BTN_PRE);
        btn_pre.addClickListener((ClickListener)this);
        Button btn_finish = (Button)this.getControl(BTN_FINISH);
        btn_finish.addClickListener((ClickListener)this);
        TextEdit formname = (TextEdit)this.getControl(FORMNAME);
        formname.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String configJson;
        boolean isEditAgain;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{COMBO_SUMFIELD});
        this.getView().setVisible(Boolean.FALSE, new String[]{SCALE});
        this.getView().setVisible(Boolean.FALSE, new String[]{UNIT});
        String source = this.getSourceFromFSP();
        if (SOURCE_BILLSTATSLIST.equals(source)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CARDTITLE});
        }
        if ((isEditAgain = "true".equals(this.getView().getFormShowParameter().getCustomParam("edit"))) && StringUtils.isNotEmpty((String)(configJson = (String)this.getView().getFormShowParameter().getCustomParam("configJson")))) {
            LocaleString lsCardTitle;
            Map configMap = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
            String entityid = (String)configMap.get("entityid");
            FormConfig fc = FormMetadataCache.getFormConfig((String)entityid);
            String formname = fc.getCaption().getLocaleValue();
            String filterschema = (String)configMap.get(FILTERSCHEMA);
            String cardtitle = (String)configMap.get(CARDTITLE);
            String datatype = (String)configMap.get("datatype");
            String sumfield = (String)configMap.get("sumfield");
            String numtitle = (String)configMap.get(NUMTITLE);
            String numcolor = (String)configMap.get(NUMCOLOR);
            String scale = (String)configMap.get(SCALE);
            String filterclass = (String)configMap.get("filterclass");
            String menuid = (String)configMap.get(MENUID);
            String appnum = (String)configMap.get(APPNUM);
            String unit = (String)configMap.get(UNIT);
            this.getModel().setValue(APPNUM, (Object)appnum);
            this.getModel().setValue(FORMNUM, (Object)entityid);
            if (StringUtils.isNotEmpty((String)filterschema) && CardUtils.isHaveSchemeRecord(filterschema) && OpenPageUtils.isHaveSchemeAuth(filterschema, RequestContext.get().getCurrUserId())) {
                this.getModel().setValue(FILTERSCHEMA, (Object)filterschema);
            }
            this.customPropChanged(FORMNUM, entityid);
            this.getModel().setValue(FORMNAME, (Object)formname);
            this.getModel().setValue(MENUID, (Object)menuid);
            if (StringUtils.isNotEmpty((String)unit)) {
                this.getModel().setValue(UNIT, (Object)unit);
            }
            if ((lsCardTitle = CardUtils.getLocaleStrFromMapEntryStr(cardtitle)) != null) {
                this.getModel().setValue(CARDTITLE, (Object)lsCardTitle.getLocaleValue());
            } else {
                this.getModel().setValue(CARDTITLE, (Object)cardtitle);
            }
            if (COUNT.equals(datatype)) {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"1");
            } else if ("sum".equals(datatype)) {
                this.getModel().setValue(RADIOGROUPFIELD, (Object)"2");
                this.customPropChanged(RADIOGROUPFIELD, "2");
            }
            this.getModel().setValue(COMBO_SUMFIELD, (Object)sumfield);
            LocaleString lsNumTitle = CardUtils.getLocaleStrFromMapEntryStr(numtitle);
            if (lsNumTitle == null) {
                this.getModel().setValue(NUMTITLE, (Object)numtitle);
            } else {
                this.getModel().setValue(NUMTITLE, (Object)lsNumTitle);
            }
            this.getModel().setValue(NUMCOLOR, (Object)numcolor);
            this.updatePreview();
            this.getModel().setValue(SCALE, (Object)scale);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String key = null;
        Object source = e.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (BTN_FINISH.equals(key)) {
            this.setReturnData();
        } else if (FORMNAME.equals(key)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COLSECALLBACK_ID_SELBILLFORM));
            fsp.setFormId("bos_card_billselect");
            this.getView().showForm(fsp);
        } else if (BTN_PRE.equals(key)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object obj = fsp.getCustomParam("source");
            if (!SOURCE_BILLSTATSLIST.equals(obj)) {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("event_rtn_addcard", "2");
                this.getView().returnDataToParent(returnMap);
            }
            this.getView().close();
        }
    }

    private String getSourceFromFSP() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String source = (String)fsp.getCustomParam("source");
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConfig() {
        String msg = "";
        try {
            boolean emptyCardTitleFromSingleBill;
            boolean emptyNumTitle;
            boolean emptyForm = StringUtils.isEmpty((String)((String)this.getModel().getValue(FORMNUM)));
            if (emptyForm) {
                msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5355\u636e\u754c\u9762\u201d\u3002", (String)"BillStatsConfigPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                boolean bl = false;
                return bl;
            }
            boolean bl = emptyNumTitle = this.getModel().getValue(NUMTITLE) == null || StringUtils.isEmpty((String)((OrmLocaleValue)this.getModel().getValue(NUMTITLE)).getLocaleValue());
            if (emptyNumTitle) {
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7edf\u8ba1\u540d\u79f0\u201d\u3002", (String)"BillStatsConfigPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = emptyCardTitleFromSingleBill = !SOURCE_BILLSTATSLIST.equals(this.getSourceFromFSP()) && (this.getModel().getValue(CARDTITLE) == null || StringUtils.isEmpty((String)((OrmLocaleValue)this.getModel().getValue(CARDTITLE)).getLocaleValue()));
            if (emptyCardTitleFromSingleBill) {
                msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5361\u7247\u6807\u9898\u201d\u3002", (String)"BillStatsConfigPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                boolean bl4 = false;
                return bl4;
            }
        }
        finally {
            if (StringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
            }
        }
        return true;
    }

    private void setReturnData() {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (!SOURCE_BILLSTATSLIST.equals(this.getSourceFromFSP())) {
            returnMap.put("cardType", "bos_card_billstats");
        }
        if (!this.validateConfig()) {
            return;
        }
        String formNum = (String)this.getModel().getValue(FORMNUM);
        String appNum = (String)this.getModel().getValue(APPNUM);
        Object filterSchema = this.getModel().getValue(FILTERSCHEMA);
        String strFilterschema = "";
        if (filterSchema != null) {
            strFilterschema = filterSchema.toString();
        }
        String cardtitle = null;
        if (!SOURCE_BILLSTATSLIST.equals(this.getSourceFromFSP())) {
            cardtitle = ((OrmLocaleValue)this.getModel().getValue(CARDTITLE)).entrySet().toString();
        }
        String numtitle = ((OrmLocaleValue)this.getModel().getValue(NUMTITLE)).entrySet().toString();
        String numcolor = this.getModel().getValue(NUMCOLOR).toString();
        String scale = Optional.ofNullable(this.getModel().getValue(SCALE)).map(s -> s.toString()).orElse("0");
        String menuId = (String)this.getModel().getValue(MENUID);
        String unit = (String)this.getModel().getValue(UNIT);
        returnMap.put(APPNUM, appNum);
        returnMap.put(UNIT, unit);
        returnMap.put("entityid", formNum);
        returnMap.put(FILTERSCHEMA, strFilterschema);
        if (!SOURCE_BILLSTATSLIST.equals(this.getSourceFromFSP())) {
            returnMap.put(CARDTITLE, cardtitle);
        }
        returnMap.put(NUMTITLE, numtitle);
        returnMap.put(NUMCOLOR, numcolor);
        returnMap.put(SCALE, scale);
        returnMap.put(MENUID, menuId);
        String dataType = this.getPageCache().get(DATA_TYPE);
        if (StringUtils.isEmpty((String)dataType)) {
            dataType = COUNT;
        }
        if (dataType.equals("sum")) {
            String sumField = (String)this.getModel().getValue(COMBO_SUMFIELD);
            if (StringUtils.isEmpty((String)sumField)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u8ba1\u5217\u3002", (String)"BillStatsConfigPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(2500));
                return;
            }
            returnMap.put("sumfield", sumField);
        }
        returnMap.put("datatype", dataType);
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("edit"))) {
            returnMap.put("edit", "true");
            if (SOURCE_BILLSTATSLIST.equals(this.getSourceFromFSP())) {
                String index = (String)this.getView().getFormShowParameter().getCustomParam("index");
                returnMap.put("index", index);
            }
        }
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (COLSECALLBACK_ID_SELBILLFORM.equals(actionId)) {
            Map retData = (Map)e.getReturnData();
            if (retData == null) {
                return;
            }
            String appNum = (String)retData.get("cache_sel_appNum");
            String formNum = (String)retData.get("cache_sel_formnum");
            String menuId = (String)retData.get("cache_sel_menuid");
            this.getModel().setValue(APPNUM, (Object)appNum);
            String formName = FormMetadataCache.getFormConfig((String)formNum).getCaption().getLocaleValue();
            this.getModel().setValue(FORMNAME, (Object)formName);
            this.getModel().setValue(FORMNUM, (Object)formNum);
            this.getModel().setValue(MENUID, (Object)menuId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        this.customPropChanged(name, newValue);
    }

    private void customPropChanged(String name, Object newValue) {
        switch (name) {
            case "formnum": {
                this.entityChanged((String)newValue);
                this.updatePreview();
                this.loadSumFields();
                break;
            }
            case "showentityname": {
                this.getView().setVisible((Boolean)newValue, new String[]{"entityname"});
                this.updatePreview();
                break;
            }
            case "filterschema": {
                if (newValue == null) {
                    return;
                }
                if (newValue.equals("new_schema")) {
                    if (this.getModel().getValue(FORMNUM) == null) {
                        return;
                    }
                    String formNum = (String)this.getModel().getValue(FORMNUM);
                    String appNum = (String)this.getModel().getValue(APPNUM);
                    String menuid = (String)this.getModel().getValue(MENUID);
                    this.openBillListPage(appNum, formNum, menuid);
                    this.getView().close();
                    return;
                }
                Map schemaMap = null;
                String shemaStr = this.getPageCache().get("shemas");
                schemaMap = (Map)SerializationUtils.fromJsonString((String)shemaStr, Map.class);
                this.getModel().setValue(NUMTITLE, schemaMap.get(newValue));
                this.updatePreview();
                break;
            }
            case "numtitle": 
            case "numcolor": {
                this.updatePreview();
                break;
            }
            case "radiogroupfield": {
                if ("1".equals(newValue)) {
                    this.getPageCache().put(DATA_TYPE, COUNT);
                    this.getView().setVisible(Boolean.FALSE, new String[]{COMBO_SUMFIELD});
                    this.getView().setVisible(Boolean.FALSE, new String[]{SCALE});
                    this.getView().setVisible(Boolean.FALSE, new String[]{UNIT});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{COMBO_SUMFIELD});
                this.getView().setVisible(Boolean.TRUE, new String[]{SCALE});
                this.getView().setVisible(Boolean.TRUE, new String[]{UNIT});
                this.getPageCache().put(DATA_TYPE, "sum");
                if (this.getModel().getValue(FORMNUM) == null) {
                    return;
                }
                this.loadSumFields();
                break;
            }
        }
    }

    private String getEntityNum() {
        String formNum = (String)this.getModel().getValue(FORMNUM);
        if (StringUtils.isEmpty((String)formNum)) {
            return null;
        }
        return this.getEntityNum(formNum);
    }

    private String getEntityNum(String formNum) {
        String entityNumber = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        if (StringUtils.isEmpty((String)entityNumber) || "empty".equals(entityNumber)) {
            entityNumber = formNum;
        }
        return entityNumber;
    }

    private void loadSumFields() {
        String entityNumber = this.getEntityNum();
        if (entityNumber == null) {
            return;
        }
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (!(met instanceof BillEntityType)) {
            return;
        }
        ComboEdit cboSumField = (ComboEdit)this.getControl(COMBO_SUMFIELD);
        ArrayList<ComboItem> cboSumItems = new ArrayList<ComboItem>();
        Map entityTypeHashMap = met.getAllEntities();
        for (EntityType entityType : entityTypeHashMap.values()) {
            String entityName = null;
            if (StringUtils.isEmpty((String)entityType.getAlias())) continue;
            if (entityType instanceof SubEntryType) {
                entityName = entityType.getParent().getName() + "." + entityType.getName();
            } else if (entityType instanceof EntryType) {
                entityName = entityType.getName();
            }
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty item : properties) {
                String dbFieldName;
                String name;
                if (entityType instanceof EntryType && "seq".equals(item.getName()) || !(item instanceof DecimalProp) || (name = item.getName()).equals("masterid") || StringUtils.isEmpty((String)(dbFieldName = item.getAlias()))) continue;
                if (StringUtils.isNotEmpty((String)entityName)) {
                    name = entityName + "." + name;
                }
                String displayName = null;
                displayName = entityType instanceof SubEntryType ? entityType.getParent().getDisplayName() + "_" + entityType.getDisplayName().getLocaleValue() + "_" + item.getDisplayName().getLocaleValue() : (entityType instanceof EntryType ? entityType.getDisplayName().getLocaleValue() + "_" + item.getDisplayName().getLocaleValue() : item.getDisplayName().getLocaleValue());
                LocaleString lstTitle = new LocaleString();
                lstTitle.setItem(Lang.get().toString(), (Object)displayName);
                ComboItem cboItem = new ComboItem(lstTitle, name);
                cboSumItems.add(cboItem);
            }
        }
        cboSumField.setComboItems(cboSumItems);
    }

    private void updatePreview() {
        String numtitle = null;
        String numcolor = null;
        if (this.getModel().getValue(NUMTITLE) != null) {
            numtitle = this.getModel().getValue(NUMTITLE).toString();
        }
        if (this.getModel().getValue(NUMCOLOR) != null) {
            numcolor = this.getModel().getValue(NUMCOLOR).toString();
        }
        if (!StringUtils.isEmpty(numcolor)) {
            HashMap<String, String> ctrl = new HashMap<String, String>();
            ctrl.put("fc", numcolor);
            this.getView().updateControlMetadata("labelap1", ctrl);
        }
        Label labSchmemaName = (Label)this.getControl("labfilter");
        if (!StringUtils.isEmpty((String)numtitle)) {
            labSchmemaName.setText(numtitle);
        } else {
            labSchmemaName.setText(ResManager.loadKDString((String)"\u8fc7\u6ee4\u65b9\u6848", (String)"BillStatsConfigPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void entityChanged(String formNum) {
        String userId = RequestContext.get().getUserId();
        ComboEdit filterSchema = (ComboEdit)this.getControl(FILTERSCHEMA);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        if (StringUtils.isEmpty((String)formNum)) {
            filterSchema.setComboItems(items);
            this.getModel().setValue(NUMTITLE, null);
            this.getModel().setValue(CARDTITLE, null);
            Label labSchmemaName = (Label)this.getControl("labfilter");
            labSchmemaName.setText(ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0", (String)"BillStatsConfigPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            ComboEdit cboSumField = (ComboEdit)this.getControl(COMBO_SUMFIELD);
            cboSumField.setComboItems(new ArrayList());
            return;
        }
        String formName = (String)this.getModel().getValue(FORMNAME);
        String langName = RequestContext.get().getLang().name();
        String cardTitleMapEntryStr = "[" + langName + "=" + formName + "]";
        LocaleString localeStrCardTitle = CardUtils.getLocaleStrFromMapEntryStr(cardTitleMapEntryStr);
        this.getModel().setValue(CARDTITLE, (Object)localeStrCardTitle);
        List<FilterScheme> schemas = this.getSchemeList(formNum);
        String local = RequestContext.get().getLang().name();
        HashMap<String, String> schemaMap = new HashMap<String, String>(schemas.size());
        for (int i = 0; i < schemas.size(); ++i) {
            FilterScheme schema = schemas.get(i);
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(local, schema.getSchemeName()));
            item.setValue(schema.getId());
            items.add(item);
            schemaMap.put(schema.getId(), schema.getSchemeName());
        }
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(local, ResManager.loadKDString((String)"\u65b0\u5efa\u65b9\u6848", (String)"BillStatsConfigPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])));
        item.setValue("new_schema");
        items.add(item);
        filterSchema.setComboItems(items);
        this.getPageCache().put("shemas", SerializationUtils.toJsonString(schemaMap));
    }

    private void openBillListPage(String appNum, String entityNumber, String menuid) {
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfo((String)appNum);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5e94\u7528\u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u662f\u5426\u542f\u7528\u6216\u53ef\u89c1\u3002", (String)"BillStatsConfigPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), appNum));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", this.getView());
        map.put("appname", appInfo.getName().getLocaleValue());
        String formNum = appInfo.getHomeNum();
        map.put("appmainnumber", formNum);
        map.put("formnumber", entityNumber);
        map.put("parametertype", "ListShowParameter");
        OpenPageUtils.openApp(appNum, menuid, map, this.getView());
    }

    public static boolean isHaveSchemeAuth(String schemeId, Long userId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)schemeId), new SqlParameter(":FUSERID", -5, (Object)userId), new SqlParameter(":FBASEDATAID", -5, (Object)userId)};
        String sql = "SELECT COUNT(1) FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_SHAREFILTERSCHEME T3 ON T1.FSCHEMEID = T3.FSCHEMEID LEFT JOIN T_BAS_SCHEMESHAREUSERS T4 ON T3.FID = T4.FID WHERE T1.FSCHEMEID = ? AND (T1.FISFIXED = '1' OR T1.FUSERID = ? OR T4.FBASEDATAID = ?)";
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next() && rs.getInt(1) > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        Boolean isHaveSchemeAuth = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)action);
        return isHaveSchemeAuth;
    }

    public List<FilterScheme> getSchemeList(String formId) {
        String userId = RequestContext.get().getUserId();
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(":FUSERID", -5, (Object)Long.parseLong(userId)), new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(":FBASEDATAID", -5, (Object)Long.parseLong(userId))};
        String sql = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID,T1.FCREATETIME,T1.FMODIFYTIME  FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID WHERE T1.FFORMID=? AND T1.FISFIXED='1' UNION ALL SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID,T1.FCREATETIME,T1.FMODIFYTIME  FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID WHERE T1.FFORMID=? AND T1.FUSERID=? UNION ALL SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID,T1.FCREATETIME,T1.FMODIFYTIME  FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID  LEFT JOIN T_BAS_SHAREFILTERSCHEME T3 ON T1.FSCHEMEID = T3.FSCHEMEID LEFT JOIN T_BAS_SCHEMESHAREUSERS T4 ON T3.FID = T4.FID WHERE T1.FFORMID=? AND  T4.FBASEDATAID =?  ORDER BY FCREATETIME DESC";
        return this.getSchemeList(params, sql);
    }

    private List<FilterScheme> getSchemeList(SqlParameter[] params, String sql) {
        new ArrayList();
        try {
            List schemeList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<FilterScheme>>(){

                public List<FilterScheme> handle(ResultSet rs) throws KDException {
                    ArrayList<FilterScheme> list = new ArrayList<FilterScheme>();
                    HashMap<String, FilterScheme> map = new HashMap<String, FilterScheme>();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL;
                            FilterScheme filterScheme;
                            if (map.containsKey(rs.getString(1))) {
                                filterScheme = (FilterScheme)map.get(rs.getString(1));
                                if (rs.getString(12) == null) continue;
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                if (filterSchemeL.getLocaleId().equals(Lang.get().getLocale().toString())) {
                                    filterScheme.setDescription(filterSchemeL.getDescription());
                                }
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                continue;
                            }
                            filterScheme = new FilterScheme();
                            filterScheme.setId(rs.getString(1));
                            filterScheme.setFormId(rs.getString(2));
                            filterScheme.setSchemeName(rs.getString(3));
                            filterScheme.setUserId(rs.getLong(4));
                            filterScheme.setDefault(rs.getBoolean(5));
                            filterScheme.setScheme(rs.getString(6));
                            filterScheme.setShare(rs.getBoolean(7));
                            filterScheme.setNextEntryScheme(rs.getBoolean(8));
                            filterScheme.setSeq(rs.getInt(9));
                            filterScheme.setEntryEntity(rs.getString(10));
                            filterScheme.setFixed(rs.getBoolean(11));
                            filterScheme.setCreateTime((Date)rs.getDate(18));
                            filterScheme.setModifyTime((Date)rs.getDate(19));
                            if (rs.getString(12) != null) {
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                if (filterSchemeL.getLocaleId().equals(Lang.get().getLocale().toString())) {
                                    filterScheme.setDescription(filterSchemeL.getDescription());
                                }
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                            }
                            map.put(rs.getString(1), filterScheme);
                            list.add(filterScheme);
                        }
                        return list;
                    }
                    catch (SQLException var6) {
                        throw new KDException((Throwable)var6, BosErrorCode.sQL, new Object[]{String.format("Error:%s", var6.getMessage())});
                    }
                }
            });
            return schemeList;
        }
        catch (Exception var6) {
            String msg = String.format("error:%s;  sql:%s", var6.getMessage(), sql);
            throw new KDException((Throwable)var6, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    private static boolean isBillPreSchema(String entityId, String schemaId) {
        List schemeList = FilterServiceHelper.getPreSchemeList((String)entityId);
        ArrayList<String> schemeIdList = new ArrayList<String>();
        if (schemeList != null && schemeList.size() > 0) {
            for (FilterScheme scheme : schemeList) {
                schemeIdList.add(scheme.getId());
            }
            return schemeIdList.contains(schemaId);
        }
        return false;
    }
}

